/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.shaded.netty.handler.ssl;

import com.datastax.oss.driver.shaded.netty.buffer.ByteBuf;
import com.datastax.oss.driver.shaded.netty.buffer.ByteBufAllocator;
import com.datastax.oss.driver.shaded.netty.buffer.ByteBufUtil;
import com.datastax.oss.driver.shaded.netty.channel.AbstractCoalescingBufferQueue;
import com.datastax.oss.driver.shaded.netty.channel.Channel;
import com.datastax.oss.driver.shaded.netty.util.internal.PlatformDependent;

abstract class SslHandlerCoalescingBufferQueue
extends AbstractCoalescingBufferQueue {
    private final boolean wantsDirectBuffer;

    SslHandlerCoalescingBufferQueue(Channel channel, int initSize, boolean wantsDirectBuffer) {
        super(channel, initSize);
        this.wantsDirectBuffer = wantsDirectBuffer;
    }

    protected abstract int wrapDataSize();

    @Override
    protected ByteBuf compose(ByteBufAllocator alloc, ByteBuf cumulation, ByteBuf next) {
        return SslHandlerCoalescingBufferQueue.attemptCopyToCumulation(cumulation, next, this.wrapDataSize()) ? cumulation : this.copyAndCompose(alloc, cumulation, next);
    }

    @Override
    protected ByteBuf composeFirst(ByteBufAllocator allocator, ByteBuf first, int bufferSize) {
        ByteBuf newFirst = this.wantsDirectBuffer ? allocator.directBuffer(bufferSize) : allocator.heapBuffer(bufferSize);
        try {
            newFirst.writeBytes(first);
        }
        catch (Throwable cause) {
            newFirst.release();
            PlatformDependent.throwException(cause);
        }
        assert (!first.isReadable());
        first.release();
        return newFirst;
    }

    @Override
    protected ByteBuf removeEmptyValue() {
        return null;
    }

    private static boolean attemptCopyToCumulation(ByteBuf cumulation, ByteBuf next, int wrapDataSize) {
        int inReadableBytes = next.readableBytes();
        if (inReadableBytes == 0) {
            next.release();
            return true;
        }
        int cumulationCapacity = cumulation.capacity();
        if (wrapDataSize - cumulation.readableBytes() >= inReadableBytes && (cumulation.isWritable(inReadableBytes) && cumulationCapacity >= wrapDataSize || cumulationCapacity < wrapDataSize && ByteBufUtil.ensureWritableSuccess(cumulation.ensureWritable(inReadableBytes, false)))) {
            cumulation.writeBytes(next);
            next.release();
            return true;
        }
        return false;
    }
}

