/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.loadbalancing.nodeset;

import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.internal.core.loadbalancing.nodeset.NodeSet;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicBoolean;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class MultiDcNodeSet
implements NodeSet {
    private static final String UNKNOWN_DC = "";
    private final Map<String, Set<Node>> nodes = new ConcurrentHashMap<String, Set<Node>>();

    @Override
    public boolean add(@NonNull Node node) {
        AtomicBoolean added = new AtomicBoolean();
        this.nodes.compute(this.getMapKey(node), (key, current) -> {
            if (current == null) {
                current = new CopyOnWriteArraySet<Node>();
            }
            if (current.add(node)) {
                added.set(true);
            }
            return current;
        });
        return added.get();
    }

    @Override
    public boolean remove(@NonNull Node node) {
        AtomicBoolean removed = new AtomicBoolean();
        this.nodes.compute(this.getMapKey(node), (key, current) -> {
            if (current != null && current.remove(node)) {
                removed.set(true);
            }
            return current;
        });
        return removed.get();
    }

    @Override
    @NonNull
    public Set<Node> dc(@Nullable String dc) {
        return this.nodes.getOrDefault(this.getMapKey(dc), Collections.emptySet());
    }

    @Override
    public Set<String> dcs() {
        return this.nodes.keySet();
    }

    @NonNull
    private String getMapKey(@NonNull Node node) {
        return this.getMapKey(node.getDatacenter());
    }

    @NonNull
    private String getMapKey(@Nullable String dc) {
        return dc == null ? UNKNOWN_DC : dc;
    }
}

