/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type.codec;

import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.api.core.type.codec.TypeCodecs;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.internal.core.util.Strings;
import com.datastax.oss.driver.shaded.netty.util.concurrent.FastThreadLocal;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.nio.ByteBuffer;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.ZoneId;
import java.util.Date;
import java.util.Optional;
import java.util.TimeZone;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class TimestampCodec
implements TypeCodec<Instant> {
    private static final String[] DATE_STRING_PATTERNS = new String[]{"yyyy-MM-dd'T'HH:mm", "yyyy-MM-dd'T'HH:mm:ss", "yyyy-MM-dd'T'HH:mm:ss.SSS", "yyyy-MM-dd'T'HH:mmX", "yyyy-MM-dd'T'HH:mmXX", "yyyy-MM-dd'T'HH:mmXXX", "yyyy-MM-dd'T'HH:mm:ssX", "yyyy-MM-dd'T'HH:mm:ssXX", "yyyy-MM-dd'T'HH:mm:ssXXX", "yyyy-MM-dd'T'HH:mm:ss.SSSX", "yyyy-MM-dd'T'HH:mm:ss.SSSXX", "yyyy-MM-dd'T'HH:mm:ss.SSSXXX", "yyyy-MM-dd'T'HH:mm z", "yyyy-MM-dd'T'HH:mm:ss z", "yyyy-MM-dd'T'HH:mm:ss.SSS z", "yyyy-MM-dd HH:mm", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm:ss.SSS", "yyyy-MM-dd HH:mmX", "yyyy-MM-dd HH:mmXX", "yyyy-MM-dd HH:mmXXX", "yyyy-MM-dd HH:mm:ssX", "yyyy-MM-dd HH:mm:ssXX", "yyyy-MM-dd HH:mm:ssXXX", "yyyy-MM-dd HH:mm:ss.SSSX", "yyyy-MM-dd HH:mm:ss.SSSXX", "yyyy-MM-dd HH:mm:ss.SSSXXX", "yyyy-MM-dd HH:mm z", "yyyy-MM-dd HH:mm:ss z", "yyyy-MM-dd HH:mm:ss.SSS z", "yyyy-MM-dd", "yyyy-MM-ddX", "yyyy-MM-ddXX", "yyyy-MM-ddXXX", "yyyy-MM-dd z"};
    private final FastThreadLocal<SimpleDateFormat> parser;
    private final FastThreadLocal<SimpleDateFormat> formatter;

    public TimestampCodec() {
        this(ZoneId.systemDefault());
    }

    public TimestampCodec(final ZoneId defaultZoneId) {
        this.parser = new FastThreadLocal<SimpleDateFormat>(){

            @Override
            protected SimpleDateFormat initialValue() {
                SimpleDateFormat parser = new SimpleDateFormat();
                parser.setLenient(false);
                parser.setTimeZone(TimeZone.getTimeZone(defaultZoneId));
                return parser;
            }
        };
        this.formatter = new FastThreadLocal<SimpleDateFormat>(){

            @Override
            protected SimpleDateFormat initialValue() {
                SimpleDateFormat parser = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
                parser.setTimeZone(TimeZone.getTimeZone(defaultZoneId));
                return parser;
            }
        };
    }

    @Override
    @NonNull
    public GenericType<Instant> getJavaType() {
        return GenericType.INSTANT;
    }

    @Override
    @NonNull
    public DataType getCqlType() {
        return DataTypes.TIMESTAMP;
    }

    @Override
    public boolean accepts(@NonNull Object value) {
        return value instanceof Instant;
    }

    @Override
    public boolean accepts(@NonNull Class<?> javaClass) {
        return javaClass == Instant.class;
    }

    @Override
    @Nullable
    public ByteBuffer encode(@Nullable Instant value, @NonNull ProtocolVersion protocolVersion) {
        return value == null ? null : TypeCodecs.BIGINT.encodePrimitive(value.toEpochMilli(), protocolVersion);
    }

    @Override
    @Nullable
    public Instant decode(@Nullable ByteBuffer bytes, @NonNull ProtocolVersion protocolVersion) {
        return bytes == null || bytes.remaining() == 0 ? null : Instant.ofEpochMilli(TypeCodecs.BIGINT.decodePrimitive(bytes, protocolVersion));
    }

    @Override
    @NonNull
    public String format(@Nullable Instant value) {
        return value == null ? "NULL" : Strings.quote(this.formatter.get().format(Date.from(value)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Instant parse(@Nullable String value) {
        if (value == null || value.isEmpty() || value.equalsIgnoreCase("NULL")) {
            return null;
        }
        String unquoted = Strings.unquote(value);
        if (Strings.isLongLiteral(unquoted)) {
            try {
                return Instant.ofEpochMilli(Long.parseLong(unquoted));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(String.format("Cannot parse timestamp value from \"%s\"", value));
            }
        }
        if (!Strings.isQuoted(value)) {
            throw new IllegalArgumentException(String.format("Alphanumeric timestamp literal must be quoted: \"%s\"", value));
        }
        SimpleDateFormat parser = this.parser.get();
        TimeZone timeZone = parser.getTimeZone();
        ParsePosition pos = new ParsePosition(0);
        for (String pattern : DATE_STRING_PATTERNS) {
            parser.applyPattern(pattern);
            pos.setIndex(0);
            try {
                Date date = parser.parse(unquoted, pos);
                if (date == null || pos.getIndex() != unquoted.length()) continue;
                Instant instant = date.toInstant();
                return instant;
            }
            finally {
                parser.setTimeZone(timeZone);
            }
        }
        throw new IllegalArgumentException(String.format("Cannot parse timestamp value from \"%s\"", value));
    }

    @Override
    @NonNull
    public Optional<Integer> serializedSize() {
        return Optional.of(8);
    }
}

