/*
 * Decompiled with CFR 0.152.
 */
package com.scwang.smartrefresh.layout.util;

import android.graphics.PointF;
import android.os.Build;
import android.support.annotation.NonNull;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import com.scwang.smartrefresh.layout.util.SmartUtil;

public class ScrollBoundaryUtil {
    public static boolean canRefresh(@NonNull View targetView, PointF touch) {
        if (ScrollBoundaryUtil.canScrollUp(targetView) && targetView.getVisibility() == 0) {
            return false;
        }
        if (targetView instanceof ViewGroup && touch != null) {
            ViewGroup viewGroup = (ViewGroup)targetView;
            int childCount = viewGroup.getChildCount();
            PointF point = new PointF();
            for (int i = childCount; i > 0; --i) {
                View child = viewGroup.getChildAt(i - 1);
                if (!ScrollBoundaryUtil.isTransformedTouchPointInView((View)viewGroup, child, touch.x, touch.y, point)) continue;
                touch.offset(point.x, point.y);
                boolean can = ScrollBoundaryUtil.canRefresh(child, touch);
                touch.offset(-point.x, -point.y);
                return can;
            }
        }
        return true;
    }

    public static boolean canLoadMore(@NonNull View targetView, PointF touch, boolean contentFull) {
        if (ScrollBoundaryUtil.canScrollDown(targetView) && targetView.getVisibility() == 0) {
            return false;
        }
        if (targetView instanceof ViewGroup && touch != null && !SmartUtil.isScrollableView(targetView)) {
            ViewGroup viewGroup = (ViewGroup)targetView;
            int childCount = viewGroup.getChildCount();
            PointF point = new PointF();
            for (int i = 0; i < childCount; ++i) {
                View child = viewGroup.getChildAt(i);
                if (!ScrollBoundaryUtil.isTransformedTouchPointInView((View)viewGroup, child, touch.x, touch.y, point)) continue;
                touch.offset(point.x, point.y);
                boolean can = ScrollBoundaryUtil.canLoadMore(child, touch, contentFull);
                touch.offset(-point.x, -point.y);
                return can;
            }
        }
        return contentFull || ScrollBoundaryUtil.canScrollUp(targetView);
    }

    public static boolean canScrollUp(@NonNull View targetView) {
        if (Build.VERSION.SDK_INT < 14) {
            if (targetView instanceof AbsListView) {
                ViewGroup viewGroup = (ViewGroup)targetView;
                AbsListView absListView = (AbsListView)targetView;
                return viewGroup.getChildCount() > 0 && (absListView.getFirstVisiblePosition() > 0 || viewGroup.getChildAt(0).getTop() < targetView.getPaddingTop());
            }
            return targetView.getScrollY() > 0;
        }
        return targetView.canScrollVertically(-1);
    }

    public static boolean canScrollDown(@NonNull View targetView) {
        if (Build.VERSION.SDK_INT < 14) {
            if (targetView instanceof AbsListView) {
                ViewGroup viewGroup = (ViewGroup)targetView;
                AbsListView absListView = (AbsListView)targetView;
                int childCount = viewGroup.getChildCount();
                return childCount > 0 && (absListView.getLastVisiblePosition() < childCount - 1 || viewGroup.getChildAt(childCount - 1).getBottom() > targetView.getPaddingBottom());
            }
            return targetView.getScrollY() < 0;
        }
        return targetView.canScrollVertically(1);
    }

    public static boolean isTransformedTouchPointInView(@NonNull View group, @NonNull View child, float x, float y, PointF outLocalPoint) {
        boolean isInView;
        if (child.getVisibility() != 0) {
            return false;
        }
        float[] point = new float[]{x, y};
        point[0] = point[0] + (float)(group.getScrollX() - child.getLeft());
        point[1] = point[1] + (float)(group.getScrollY() - child.getTop());
        boolean bl = isInView = point[0] >= 0.0f && point[1] >= 0.0f && point[0] < (float)child.getWidth() && point[1] < (float)child.getHeight();
        if (isInView && outLocalPoint != null) {
            outLocalPoint.set(point[0] - x, point[1] - y);
        }
        return isInView;
    }
}

