/*
 * Decompiled with CFR 0.152.
 */
package com.scwang.smartrefresh.layout.header;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.scwang.smartrefresh.layout.R;
import com.scwang.smartrefresh.layout.api.RefreshHeader;
import com.scwang.smartrefresh.layout.api.RefreshLayout;
import com.scwang.smartrefresh.layout.constant.RefreshState;
import com.scwang.smartrefresh.layout.constant.SpinnerStyle;
import com.scwang.smartrefresh.layout.internal.ArrowDrawable;
import com.scwang.smartrefresh.layout.internal.InternalClassics;
import com.scwang.smartrefresh.layout.internal.ProgressDrawable;
import com.scwang.smartrefresh.layout.util.DensityUtil;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public class ClassicsHeader
extends InternalClassics<ClassicsHeader>
implements RefreshHeader {
    public static final byte ID_TEXT_UPDATE = 4;
    public static String REFRESH_HEADER_PULLING = null;
    public static String REFRESH_HEADER_REFRESHING = null;
    public static String REFRESH_HEADER_LOADING = null;
    public static String REFRESH_HEADER_RELEASE = null;
    public static String REFRESH_HEADER_FINISH = null;
    public static String REFRESH_HEADER_FAILED = null;
    public static String REFRESH_HEADER_UPDATE = null;
    public static String REFRESH_HEADER_SECONDARY = null;
    protected String KEY_LAST_UPDATE_TIME = "LAST_UPDATE_TIME";
    protected Date mLastTime;
    protected TextView mLastUpdateText;
    protected SharedPreferences mShared;
    protected DateFormat mLastUpdateFormat;
    protected boolean mEnableLastTime = true;

    public ClassicsHeader(Context context) {
        this(context, null);
    }

    public ClassicsHeader(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ClassicsHeader(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        if (REFRESH_HEADER_PULLING == null) {
            REFRESH_HEADER_PULLING = context.getString(R.string.srl_header_pulling);
        }
        if (REFRESH_HEADER_REFRESHING == null) {
            REFRESH_HEADER_REFRESHING = context.getString(R.string.srl_header_refreshing);
        }
        if (REFRESH_HEADER_LOADING == null) {
            REFRESH_HEADER_LOADING = context.getString(R.string.srl_header_loading);
        }
        if (REFRESH_HEADER_RELEASE == null) {
            REFRESH_HEADER_RELEASE = context.getString(R.string.srl_header_release);
        }
        if (REFRESH_HEADER_FINISH == null) {
            REFRESH_HEADER_FINISH = context.getString(R.string.srl_header_finish);
        }
        if (REFRESH_HEADER_FAILED == null) {
            REFRESH_HEADER_FAILED = context.getString(R.string.srl_header_failed);
        }
        if (REFRESH_HEADER_UPDATE == null) {
            REFRESH_HEADER_UPDATE = context.getString(R.string.srl_header_update);
        }
        if (REFRESH_HEADER_SECONDARY == null) {
            REFRESH_HEADER_SECONDARY = context.getString(R.string.srl_header_secondary);
        }
        this.mLastUpdateText = new TextView(context);
        this.mLastUpdateText.setTextColor(-8618884);
        this.mLastUpdateFormat = new SimpleDateFormat(REFRESH_HEADER_UPDATE, Locale.getDefault());
        ClassicsHeader thisView = this;
        ImageView arrowView = this.mArrowView;
        TextView updateView = this.mLastUpdateText;
        ImageView progressView = this.mProgressView;
        LinearLayout centerLayout = this.mCenterLayout;
        DensityUtil density = new DensityUtil();
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.ClassicsHeader);
        RelativeLayout.LayoutParams lpArrow = (RelativeLayout.LayoutParams)arrowView.getLayoutParams();
        RelativeLayout.LayoutParams lpProgress = (RelativeLayout.LayoutParams)progressView.getLayoutParams();
        LinearLayout.LayoutParams lpUpdateText = new LinearLayout.LayoutParams(-2, -2);
        lpUpdateText.topMargin = ta.getDimensionPixelSize(R.styleable.ClassicsHeader_srlTextTimeMarginTop, density.dip2px(0.0f));
        lpArrow.rightMargin = lpProgress.rightMargin = ta.getDimensionPixelSize(R.styleable.ClassicsFooter_srlDrawableMarginRight, density.dip2px(20.0f));
        lpArrow.width = ta.getLayoutDimension(R.styleable.ClassicsHeader_srlDrawableArrowSize, lpArrow.width);
        lpArrow.height = ta.getLayoutDimension(R.styleable.ClassicsHeader_srlDrawableArrowSize, lpArrow.height);
        lpProgress.width = ta.getLayoutDimension(R.styleable.ClassicsHeader_srlDrawableProgressSize, lpProgress.width);
        lpProgress.height = ta.getLayoutDimension(R.styleable.ClassicsHeader_srlDrawableProgressSize, lpProgress.height);
        lpArrow.width = ta.getLayoutDimension(R.styleable.ClassicsHeader_srlDrawableSize, lpArrow.width);
        lpArrow.height = ta.getLayoutDimension(R.styleable.ClassicsHeader_srlDrawableSize, lpArrow.height);
        lpProgress.width = ta.getLayoutDimension(R.styleable.ClassicsHeader_srlDrawableSize, lpProgress.width);
        lpProgress.height = ta.getLayoutDimension(R.styleable.ClassicsHeader_srlDrawableSize, lpProgress.height);
        this.mFinishDuration = ta.getInt(R.styleable.ClassicsHeader_srlFinishDuration, this.mFinishDuration);
        this.mEnableLastTime = ta.getBoolean(R.styleable.ClassicsHeader_srlEnableLastTime, this.mEnableLastTime);
        this.mSpinnerStyle = SpinnerStyle.values()[ta.getInt(R.styleable.ClassicsHeader_srlClassicsSpinnerStyle, this.mSpinnerStyle.ordinal())];
        if (ta.hasValue(R.styleable.ClassicsHeader_srlDrawableArrow)) {
            this.mArrowView.setImageDrawable(ta.getDrawable(R.styleable.ClassicsHeader_srlDrawableArrow));
        } else {
            this.mArrowDrawable = new ArrowDrawable();
            this.mArrowDrawable.setColor(-10066330);
            this.mArrowView.setImageDrawable((Drawable)this.mArrowDrawable);
        }
        if (ta.hasValue(R.styleable.ClassicsHeader_srlDrawableProgress)) {
            this.mProgressView.setImageDrawable(ta.getDrawable(R.styleable.ClassicsHeader_srlDrawableProgress));
        } else {
            this.mProgressDrawable = new ProgressDrawable();
            this.mProgressDrawable.setColor(-10066330);
            this.mProgressView.setImageDrawable((Drawable)this.mProgressDrawable);
        }
        if (ta.hasValue(R.styleable.ClassicsHeader_srlTextSizeTitle)) {
            this.mTitleText.setTextSize(0, (float)ta.getDimensionPixelSize(R.styleable.ClassicsHeader_srlTextSizeTitle, DensityUtil.dp2px(16.0f)));
        } else {
            this.mTitleText.setTextSize(16.0f);
        }
        if (ta.hasValue(R.styleable.ClassicsHeader_srlTextSizeTime)) {
            this.mLastUpdateText.setTextSize(0, (float)ta.getDimensionPixelSize(R.styleable.ClassicsHeader_srlTextSizeTime, DensityUtil.dp2px(12.0f)));
        } else {
            this.mLastUpdateText.setTextSize(12.0f);
        }
        if (ta.hasValue(R.styleable.ClassicsHeader_srlPrimaryColor)) {
            this.setPrimaryColor(ta.getColor(R.styleable.ClassicsHeader_srlPrimaryColor, 0));
        }
        if (ta.hasValue(R.styleable.ClassicsHeader_srlAccentColor)) {
            this.setAccentColor(ta.getColor(R.styleable.ClassicsHeader_srlAccentColor, 0));
        }
        ta.recycle();
        updateView.setId(4);
        updateView.setVisibility(this.mEnableLastTime ? 0 : 8);
        centerLayout.addView((View)updateView, (ViewGroup.LayoutParams)lpUpdateText);
        this.mTitleText.setText((CharSequence)(thisView.isInEditMode() ? REFRESH_HEADER_REFRESHING : REFRESH_HEADER_PULLING));
        try {
            List fragments;
            FragmentManager manager;
            if (context instanceof FragmentActivity && (manager = ((FragmentActivity)context).getSupportFragmentManager()) != null && (fragments = manager.getFragments()) != null && fragments.size() > 0) {
                this.setLastUpdateTime(new Date());
                return;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        this.KEY_LAST_UPDATE_TIME = this.KEY_LAST_UPDATE_TIME + context.getClass().getName();
        this.mShared = context.getSharedPreferences("ClassicsHeader", 0);
        this.setLastUpdateTime(new Date(this.mShared.getLong(this.KEY_LAST_UPDATE_TIME, System.currentTimeMillis())));
    }

    @Override
    public int onFinish(@NonNull RefreshLayout layout, boolean success) {
        if (success) {
            this.mTitleText.setText((CharSequence)REFRESH_HEADER_FINISH);
            if (this.mLastTime != null) {
                this.setLastUpdateTime(new Date());
            }
        } else {
            this.mTitleText.setText((CharSequence)REFRESH_HEADER_FAILED);
        }
        return super.onFinish(layout, success);
    }

    @Override
    public void onStateChanged(@NonNull RefreshLayout refreshLayout, @NonNull RefreshState oldState, @NonNull RefreshState newState) {
        ImageView arrowView = this.mArrowView;
        TextView updateView = this.mLastUpdateText;
        switch (newState) {
            case None: {
                updateView.setVisibility(this.mEnableLastTime ? 0 : 8);
            }
            case PullDownToRefresh: {
                this.mTitleText.setText((CharSequence)REFRESH_HEADER_PULLING);
                arrowView.setVisibility(0);
                arrowView.animate().rotation(0.0f);
                break;
            }
            case Refreshing: 
            case RefreshReleased: {
                this.mTitleText.setText((CharSequence)REFRESH_HEADER_REFRESHING);
                arrowView.setVisibility(8);
                break;
            }
            case ReleaseToRefresh: {
                this.mTitleText.setText((CharSequence)REFRESH_HEADER_RELEASE);
                arrowView.animate().rotation(180.0f);
                break;
            }
            case ReleaseToTwoLevel: {
                this.mTitleText.setText((CharSequence)REFRESH_HEADER_SECONDARY);
                arrowView.animate().rotation(0.0f);
                break;
            }
            case Loading: {
                arrowView.setVisibility(8);
                updateView.setVisibility(this.mEnableLastTime ? 4 : 8);
                this.mTitleText.setText((CharSequence)REFRESH_HEADER_LOADING);
            }
        }
    }

    public ClassicsHeader setLastUpdateTime(Date time) {
        ClassicsHeader thisView = this;
        this.mLastTime = time;
        this.mLastUpdateText.setText((CharSequence)this.mLastUpdateFormat.format(time));
        if (this.mShared != null && !thisView.isInEditMode()) {
            this.mShared.edit().putLong(this.KEY_LAST_UPDATE_TIME, time.getTime()).apply();
        }
        return this;
    }

    public ClassicsHeader setTimeFormat(DateFormat format) {
        this.mLastUpdateFormat = format;
        if (this.mLastTime != null) {
            this.mLastUpdateText.setText((CharSequence)this.mLastUpdateFormat.format(this.mLastTime));
        }
        return this;
    }

    public ClassicsHeader setLastUpdateText(CharSequence text) {
        this.mLastTime = null;
        this.mLastUpdateText.setText(text);
        return this;
    }

    @Override
    public ClassicsHeader setAccentColor(@ColorInt int accentColor) {
        this.mLastUpdateText.setTextColor(accentColor & 0xFFFFFF | 0xCC000000);
        return (ClassicsHeader)super.setAccentColor(accentColor);
    }

    public ClassicsHeader setEnableLastTime(boolean enable) {
        TextView updateView = this.mLastUpdateText;
        this.mEnableLastTime = enable;
        updateView.setVisibility(enable ? 0 : 8);
        if (this.mRefreshKernel != null) {
            this.mRefreshKernel.requestRemeasureHeightFor(this);
        }
        return this;
    }

    public ClassicsHeader setTextSizeTime(float size) {
        this.mLastUpdateText.setTextSize(size);
        if (this.mRefreshKernel != null) {
            this.mRefreshKernel.requestRemeasureHeightFor(this);
        }
        return this;
    }

    public ClassicsHeader setTextTimeMarginTop(float dp) {
        TextView updateView = this.mLastUpdateText;
        ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)updateView.getLayoutParams();
        lp.topMargin = DensityUtil.dp2px(dp);
        updateView.setLayoutParams((ViewGroup.LayoutParams)lp);
        return this;
    }
}

