/*
 * Decompiled with CFR 0.152.
 */
package com.scwang.smartrefresh.layout.internal.pathview;

import android.content.Context;
import android.graphics.Canvas;
import android.util.AttributeSet;
import android.view.View;
import com.scwang.smartrefresh.layout.internal.pathview.PathsDrawable;

public class PathsView
extends View {
    protected PathsDrawable mPathsDrawable = new PathsDrawable();

    public PathsView(Context context) {
        super(context);
        this.initView(context, null, 0);
    }

    public PathsView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView(context, attrs, 0);
    }

    public PathsView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView(context, attrs, defStyleAttr);
    }

    private void initView(Context context, AttributeSet attrs, int defStyleAttr) {
        this.mPathsDrawable = new PathsDrawable();
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        if (this.getTag() instanceof String) {
            this.parserPaths(this.getTag().toString());
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.setMeasuredDimension(PathsView.resolveSize((int)(this.mPathsDrawable.width() + this.getPaddingLeft() + this.getPaddingRight()), (int)widthMeasureSpec), PathsView.resolveSize((int)(this.mPathsDrawable.height() + this.getPaddingTop() + this.getPaddingBottom()), (int)heightMeasureSpec));
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.mPathsDrawable.setBounds(this.getPaddingLeft(), this.getPaddingTop(), Math.max(right - left - this.getPaddingRight(), this.getPaddingLeft()), Math.max(bottom - top - this.getPaddingTop(), this.getPaddingTop()));
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.mPathsDrawable.draw(canvas);
    }

    public void parserPaths(String ... paths) {
        this.mPathsDrawable.parserPaths(paths);
    }

    public void parserColors(int ... colors) {
        this.mPathsDrawable.parserColors(colors);
    }
}

