/*
 * Decompiled with CFR 0.152.
 */
package com.scwang.smartrefresh.layout.impl;

import android.view.MotionEvent;
import android.view.View;
import com.scwang.smartrefresh.layout.api.ScrollBoundaryDecider;
import com.scwang.smartrefresh.layout.util.ScrollBoundaryUtil;

public class ScrollBoundaryDeciderAdapter
implements ScrollBoundaryDecider {
    protected MotionEvent mActionEvent;
    protected ScrollBoundaryDecider boundary;
    protected boolean mEnableLoadMoreWhenContentNotFull;

    void setScrollBoundaryDecider(ScrollBoundaryDecider boundary) {
        this.boundary = boundary;
    }

    void setActionEvent(MotionEvent event) {
        this.mActionEvent = event;
    }

    @Override
    public boolean canRefresh(View content) {
        if (this.boundary != null) {
            return this.boundary.canRefresh(content);
        }
        return ScrollBoundaryUtil.canRefresh(content, this.mActionEvent);
    }

    @Override
    public boolean canLoadMore(View content) {
        if (this.boundary != null) {
            return this.boundary.canLoadMore(content);
        }
        if (this.mEnableLoadMoreWhenContentNotFull) {
            return !ScrollBoundaryUtil.canScrollDown(content, this.mActionEvent);
        }
        return ScrollBoundaryUtil.canLoadMore(content, this.mActionEvent);
    }

    public void setEnableLoadMoreWhenContentNotFull(boolean enable) {
        this.mEnableLoadMoreWhenContentNotFull = enable;
    }
}

