/*
 * Decompiled with CFR 0.152.
 */
package com.scwang.smartrefresh.layout.impl;

import android.annotation.SuppressLint;
import android.support.annotation.NonNull;
import android.view.View;
import android.view.ViewGroup;
import com.scwang.smartrefresh.layout.SmartRefreshLayout;
import com.scwang.smartrefresh.layout.api.RefreshInternal;
import com.scwang.smartrefresh.layout.api.RefreshKernel;
import com.scwang.smartrefresh.layout.api.RefreshLayout;
import com.scwang.smartrefresh.layout.constant.RefreshState;
import com.scwang.smartrefresh.layout.constant.SpinnerStyle;

@SuppressLint(value={"RestrictedApi"})
public class RefreshInternalWrapper
implements RefreshInternal {
    View mWrapperView;
    private SpinnerStyle mSpinnerStyle;

    RefreshInternalWrapper(View wrapper) {
        this.mWrapperView = wrapper;
    }

    @Override
    @NonNull
    public View getView() {
        return this.mWrapperView;
    }

    @Override
    public int onFinish(@NonNull RefreshLayout refreshLayout, boolean success) {
        if (this.mWrapperView instanceof RefreshInternal) {
            return ((RefreshInternal)this.mWrapperView).onFinish(refreshLayout, success);
        }
        return 0;
    }

    @Override
    @Deprecated
    public void setPrimaryColors(int ... colors) {
        if (this.mWrapperView instanceof RefreshInternal) {
            ((RefreshInternal)this.mWrapperView).setPrimaryColors(colors);
        }
    }

    @Override
    @NonNull
    public SpinnerStyle getSpinnerStyle() {
        if (this.mWrapperView instanceof RefreshInternal) {
            return ((RefreshInternal)this.mWrapperView).getSpinnerStyle();
        }
        if (this.mSpinnerStyle != null) {
            return this.mSpinnerStyle;
        }
        ViewGroup.LayoutParams params = this.mWrapperView.getLayoutParams();
        if (params instanceof SmartRefreshLayout.LayoutParams) {
            this.mSpinnerStyle = ((SmartRefreshLayout.LayoutParams)params).spinnerStyle;
            if (this.mSpinnerStyle != null) {
                return this.mSpinnerStyle;
            }
        }
        if (params != null && (params.height == 0 || params.height == -1)) {
            this.mSpinnerStyle = SpinnerStyle.Scale;
            return this.mSpinnerStyle;
        }
        this.mSpinnerStyle = SpinnerStyle.Translate;
        return this.mSpinnerStyle;
    }

    @Override
    public void onInitialized(@NonNull RefreshKernel kernel, int height, int extendHeight) {
        if (this.mWrapperView instanceof RefreshInternal) {
            ((RefreshInternal)this.mWrapperView).onInitialized(kernel, height, extendHeight);
        }
    }

    @Override
    public boolean isSupportHorizontalDrag() {
        return this.mWrapperView instanceof RefreshInternal && ((RefreshInternal)this.mWrapperView).isSupportHorizontalDrag();
    }

    @Override
    public void onHorizontalDrag(float percentX, int offsetX, int offsetMax) {
        if (this.mWrapperView instanceof RefreshInternal) {
            ((RefreshInternal)this.mWrapperView).onHorizontalDrag(percentX, offsetX, offsetMax);
        }
    }

    @Override
    public void onPulling(float percent, int offset, int height, int extendHeight) {
        if (this.mWrapperView instanceof RefreshInternal) {
            ((RefreshInternal)this.mWrapperView).onPulling(percent, offset, height, extendHeight);
        }
    }

    @Override
    public void onReleasing(float percent, int offset, int height, int extendHeight) {
        if (this.mWrapperView instanceof RefreshInternal) {
            ((RefreshInternal)this.mWrapperView).onReleasing(percent, offset, height, extendHeight);
        }
    }

    @Override
    public void onReleased(RefreshLayout refreshLayout, int height, int extendHeight) {
        if (this.mWrapperView instanceof RefreshInternal) {
            ((RefreshInternal)this.mWrapperView).onReleased(refreshLayout, height, extendHeight);
        }
    }

    @Override
    public void onStartAnimator(@NonNull RefreshLayout refreshLayout, int height, int extendHeight) {
        if (this.mWrapperView instanceof RefreshInternal) {
            ((RefreshInternal)this.mWrapperView).onStartAnimator(refreshLayout, height, extendHeight);
        }
    }

    @Override
    public void onStateChanged(RefreshLayout refreshLayout, RefreshState oldState, RefreshState newState) {
        if (this.mWrapperView instanceof RefreshInternal) {
            ((RefreshInternal)this.mWrapperView).onStateChanged(refreshLayout, oldState, newState);
        }
    }
}

