/*
 * Decompiled with CFR 0.152.
 */
package com.scwang.smartrefresh.layout.impl;

import android.support.annotation.NonNull;
import android.view.View;
import android.view.ViewGroup;
import com.scwang.smartrefresh.layout.SmartRefreshLayout;
import com.scwang.smartrefresh.layout.api.RefreshFooter;
import com.scwang.smartrefresh.layout.api.RefreshInternal;
import com.scwang.smartrefresh.layout.api.RefreshKernel;
import com.scwang.smartrefresh.layout.impl.RefreshInternalWrapper;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class RefreshFooterWrapper
extends RefreshInternalWrapper
implements RefreshFooter,
InvocationHandler {
    private RefreshKernel mRefreshKernel;
    private Method mRequestDrawBackgroundForHeaderMethod;
    private Method mRequestRemeasureHeightForHeaderMethod;
    private Method mRequestNeedTouchEventWhenRefreshingMethod;

    public RefreshFooterWrapper(View wrapper) {
        super(wrapper);
    }

    @Override
    public void onInitialized(@NonNull RefreshKernel kernel, int height, int extendHeight) {
        if (this.mWrapperView instanceof RefreshInternal) {
            RefreshKernel proxy = (RefreshKernel)Proxy.newProxyInstance(RefreshKernel.class.getClassLoader(), new Class[]{RefreshKernel.class}, (InvocationHandler)this);
            proxy.requestDrawBackgroundForHeader(0);
            proxy.requestRemeasureHeightForHeader();
            proxy.requestNeedTouchEventWhenRefreshing(false);
            this.mRefreshKernel = kernel;
            ((RefreshInternal)this.mWrapperView).onInitialized(proxy, height, extendHeight);
        } else {
            ViewGroup.LayoutParams params = this.mWrapperView.getLayoutParams();
            if (params instanceof SmartRefreshLayout.LayoutParams) {
                kernel.requestDrawBackgroundForFooter(((SmartRefreshLayout.LayoutParams)params).backgroundColor);
            }
        }
    }

    @Override
    public boolean setNoMoreData(boolean noMoreData) {
        if (this.mWrapperView instanceof RefreshFooter) {
            ((RefreshFooter)this.mWrapperView).setNoMoreData(noMoreData);
        }
        return false;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object returnValue = null;
        if (this.mRefreshKernel != null) {
            if (method.equals(this.mRequestDrawBackgroundForHeaderMethod)) {
                this.mRefreshKernel.requestDrawBackgroundForFooter((Integer)args[0]);
            } else if (method.equals(this.mRequestRemeasureHeightForHeaderMethod)) {
                this.mRefreshKernel.requestRemeasureHeightForFooter();
            } else if (method.equals(this.mRequestNeedTouchEventWhenRefreshingMethod)) {
                this.mRefreshKernel.requestNeedTouchEventWhenLoading((Boolean)args[0]);
            } else {
                returnValue = method.invoke((Object)this.mRefreshKernel, args);
            }
        }
        if (method.getReturnType().equals(RefreshKernel.class)) {
            if (this.mRefreshKernel == null && RefreshKernel.class.equals(method.getDeclaringClass())) {
                if (this.mRequestDrawBackgroundForHeaderMethod == null) {
                    this.mRequestDrawBackgroundForHeaderMethod = method;
                } else if (this.mRequestRemeasureHeightForHeaderMethod == null) {
                    this.mRequestRemeasureHeightForHeaderMethod = method;
                } else if (this.mRequestNeedTouchEventWhenRefreshingMethod == null) {
                    this.mRequestNeedTouchEventWhenRefreshingMethod = method;
                }
            }
            return proxy;
        }
        return returnValue;
    }
}

