/*
 * Decompiled with CFR 0.152.
 */
package com.scwang.smartrefresh.layout.header;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;
import android.support.annotation.NonNull;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.DecelerateInterpolator;
import android.widget.FrameLayout;
import com.scwang.smartrefresh.layout.R;
import com.scwang.smartrefresh.layout.api.RefreshHeader;
import com.scwang.smartrefresh.layout.api.RefreshKernel;
import com.scwang.smartrefresh.layout.api.RefreshLayout;
import com.scwang.smartrefresh.layout.constant.RefreshState;
import com.scwang.smartrefresh.layout.constant.SpinnerStyle;
import com.scwang.smartrefresh.layout.header.bezierradar.RippleView;
import com.scwang.smartrefresh.layout.header.bezierradar.RoundDotView;
import com.scwang.smartrefresh.layout.header.bezierradar.RoundProgressView;
import com.scwang.smartrefresh.layout.header.bezierradar.WaveView;
import com.scwang.smartrefresh.layout.util.DensityUtil;

public class BezierRadarHeader
extends FrameLayout
implements RefreshHeader {
    private WaveView mWaveView;
    private RippleView mRippleView;
    private RoundDotView mDotView;
    private RoundProgressView mProgressView;
    private boolean mEnableHorizontalDrag = false;
    private boolean mIsRunning;
    private Integer mAccentColor;
    private Integer mPrimaryColor;

    public BezierRadarHeader(Context context) {
        this(context, null);
    }

    public BezierRadarHeader(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BezierRadarHeader(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView(context, attrs, defStyleAttr);
    }

    private void initView(Context context, AttributeSet attrs, int defStyleAttr) {
        this.setMinimumHeight(DensityUtil.dp2px(100.0f));
        this.mWaveView = new WaveView(this.getContext());
        this.mRippleView = new RippleView(this.getContext());
        this.mDotView = new RoundDotView(this.getContext());
        this.mProgressView = new RoundProgressView(this.getContext());
        if (this.isInEditMode()) {
            this.addView(this.mWaveView, -1, -1);
            this.addView(this.mProgressView, -1, -1);
            this.mWaveView.setHeadHeight(1000);
        } else {
            this.addView(this.mWaveView, -1, -1);
            this.addView(this.mDotView, -1, -1);
            this.addView(this.mProgressView, -1, -1);
            this.addView(this.mRippleView, -1, -1);
            this.mProgressView.setScaleX(0.0f);
            this.mProgressView.setScaleY(0.0f);
        }
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.BezierRadarHeader);
        this.mEnableHorizontalDrag = ta.getBoolean(R.styleable.BezierRadarHeader_srlEnableHorizontalDrag, this.mEnableHorizontalDrag);
        if (ta.hasValue(R.styleable.BezierRadarHeader_srlPrimaryColor)) {
            this.setPrimaryColor(ta.getColor(R.styleable.BezierRadarHeader_srlPrimaryColor, 0));
        }
        if (ta.hasValue(R.styleable.BezierRadarHeader_srlAccentColor)) {
            this.setAccentColor(ta.getColor(R.styleable.BezierRadarHeader_srlAccentColor, 0));
        }
        ta.recycle();
    }

    public BezierRadarHeader setPrimaryColor(@ColorInt int color) {
        this.mPrimaryColor = color;
        this.mWaveView.setWaveColor(color);
        this.mProgressView.setBackColor(color);
        return this;
    }

    public BezierRadarHeader setAccentColor(@ColorInt int color) {
        this.mAccentColor = color;
        this.mDotView.setDotColor(color);
        this.mRippleView.setFrontColor(color);
        this.mProgressView.setFrontColor(color);
        return this;
    }

    public BezierRadarHeader setPrimaryColorId(@ColorRes int colorId) {
        this.setPrimaryColor(ContextCompat.getColor((Context)this.getContext(), (int)colorId));
        return this;
    }

    public BezierRadarHeader setAccentColorId(@ColorRes int colorId) {
        this.setAccentColor(ContextCompat.getColor((Context)this.getContext(), (int)colorId));
        return this;
    }

    public BezierRadarHeader setEnableHorizontalDrag(boolean enable) {
        this.mEnableHorizontalDrag = enable;
        if (!enable) {
            this.mWaveView.setWaveOffsetX(-1);
        }
        return this;
    }

    @Override
    @Deprecated
    public void setPrimaryColors(int ... colors) {
        if (colors.length > 0 && this.mPrimaryColor == null) {
            this.setPrimaryColor(colors[0]);
            this.mPrimaryColor = null;
        }
        if (colors.length > 1 && this.mAccentColor == null) {
            this.setAccentColor(colors[1]);
            this.mAccentColor = null;
        }
    }

    @Override
    @NonNull
    public View getView() {
        return this;
    }

    @Override
    @NonNull
    public SpinnerStyle getSpinnerStyle() {
        return SpinnerStyle.Scale;
    }

    @Override
    public void onInitialized(@NonNull RefreshKernel kernel, int height, int extendHeight) {
    }

    @Override
    public boolean isSupportHorizontalDrag() {
        return this.mEnableHorizontalDrag;
    }

    @Override
    public void onHorizontalDrag(float percentX, int offsetX, int offsetMax) {
        this.mWaveView.setWaveOffsetX(offsetX);
        this.mWaveView.invalidate();
    }

    @Override
    public void onPulling(float percent, int offset, int height, int extendHeight) {
        this.mWaveView.setHeadHeight(Math.min(height, offset));
        this.mWaveView.setWaveHeight((int)(1.9f * (float)Math.max(0, offset - height)));
        this.mDotView.setFraction(percent);
        if (this.mIsRunning) {
            this.mWaveView.invalidate();
        }
    }

    @Override
    public void onReleasing(float percent, int offset, int height, int extendHeight) {
        this.onPulling(percent, offset, height, extendHeight);
    }

    @Override
    public void onReleased(final RefreshLayout layout, int height, int extendHeight) {
        this.mIsRunning = true;
        this.mWaveView.setHeadHeight(height);
        ValueAnimator animator = ValueAnimator.ofInt((int[])new int[]{this.mWaveView.getWaveHeight(), 0, -((int)((double)this.mWaveView.getWaveHeight() * 0.8)), 0, -((int)((float)this.mWaveView.getWaveHeight() * 0.4f)), 0});
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                BezierRadarHeader.this.mWaveView.setWaveHeight((Integer)animation.getAnimatedValue() / 2);
                BezierRadarHeader.this.mWaveView.invalidate();
            }
        });
        animator.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        animator.setDuration(800L);
        animator.start();
        ValueAnimator valueAnimator = ValueAnimator.ofFloat((float[])new float[]{1.0f, 0.0f});
        valueAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                BezierRadarHeader.this.mDotView.setVisibility(4);
                BezierRadarHeader.this.mProgressView.animate().scaleX(1.0f);
                BezierRadarHeader.this.mProgressView.animate().scaleY(1.0f);
                layout.getLayout().postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        BezierRadarHeader.this.mProgressView.startAnim();
                    }
                }, 200L);
            }
        });
        valueAnimator.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        valueAnimator.setDuration(300L);
        valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                BezierRadarHeader.this.mDotView.setAlpha(((Float)animation.getAnimatedValue()).floatValue());
            }
        });
        valueAnimator.start();
    }

    @Override
    public void onStartAnimator(@NonNull RefreshLayout layout, int height, int extendHeight) {
    }

    @Override
    public int onFinish(@NonNull RefreshLayout layout, boolean success) {
        this.mProgressView.stopAnim();
        this.mProgressView.animate().scaleX(0.0f);
        this.mProgressView.animate().scaleY(0.0f);
        this.mRippleView.setVisibility(0);
        this.mRippleView.startReveal();
        return 400;
    }

    @Override
    public void onStateChanged(RefreshLayout refreshLayout, RefreshState oldState, RefreshState newState) {
        switch (newState) {
            case None: {
                this.mRippleView.setVisibility(8);
                this.mDotView.setAlpha(1.0f);
                this.mDotView.setVisibility(0);
                break;
            }
            case PullDownToRefresh: {
                this.mProgressView.setScaleX(0.0f);
                this.mProgressView.setScaleY(0.0f);
                break;
            }
            case PullUpToLoad: {
                break;
            }
            case Refreshing: {
                break;
            }
        }
    }
}

