/*
 * Decompiled with CFR 0.152.
 */
package com.scwang.smartrefresh.layout.footer;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.AttrRes;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.graphics.ColorUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import com.scwang.smartrefresh.layout.R;
import com.scwang.smartrefresh.layout.api.RefreshFooter;
import com.scwang.smartrefresh.layout.api.RefreshKernel;
import com.scwang.smartrefresh.layout.api.RefreshLayout;
import com.scwang.smartrefresh.layout.constant.RefreshState;
import com.scwang.smartrefresh.layout.constant.SpinnerStyle;
import com.scwang.smartrefresh.layout.footer.ballpulse.BallPulseView;
import com.scwang.smartrefresh.layout.util.DensityUtil;

public class BallPulseFooter
extends ViewGroup
implements RefreshFooter {
    private BallPulseView mBallPulseView;
    private SpinnerStyle mSpinnerStyle = SpinnerStyle.Translate;
    private Integer mNormalColor;
    private Integer mAnimationColor;

    public BallPulseFooter(@NonNull Context context) {
        super(context);
        this.initView(context, null, 0);
    }

    public BallPulseFooter(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.initView(context, attrs, 0);
    }

    public BallPulseFooter(@NonNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView(context, attrs, defStyleAttr);
    }

    private void initView(Context context, AttributeSet attrs, int defStyleAttr) {
        this.mBallPulseView = new BallPulseView(context);
        this.addView(this.mBallPulseView, -2, -2);
        this.setMinimumHeight(DensityUtil.dp2px(60.0f));
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.BallPulseFooter);
        if (ta.hasValue(R.styleable.BallPulseFooter_srlAnimatingColor)) {
            this.setAnimatingColor(ta.getColor(R.styleable.BallPulseFooter_srlAnimatingColor, 0));
        }
        if (ta.hasValue(R.styleable.BallPulseFooter_srlNormalColor)) {
            this.setNormalColor(ta.getColor(R.styleable.BallPulseFooter_srlNormalColor, 0));
        }
        if (ta.hasValue(R.styleable.BallPulseFooter_srlIndicatorColor)) {
            this.setIndicatorColor(ta.getColor(R.styleable.BallPulseFooter_srlIndicatorColor, 0));
        }
        this.mSpinnerStyle = SpinnerStyle.values()[ta.getInt(R.styleable.BallPulseFooter_srlClassicsSpinnerStyle, this.mSpinnerStyle.ordinal())];
        ta.recycle();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthSpec = View.MeasureSpec.makeMeasureSpec((int)View.MeasureSpec.getSize((int)widthMeasureSpec), (int)Integer.MIN_VALUE);
        int heightSpec = View.MeasureSpec.makeMeasureSpec((int)View.MeasureSpec.getSize((int)heightMeasureSpec), (int)Integer.MIN_VALUE);
        this.mBallPulseView.measure(widthSpec, heightSpec);
        this.setMeasuredDimension(BallPulseFooter.resolveSize((int)this.mBallPulseView.getMeasuredWidth(), (int)widthMeasureSpec), BallPulseFooter.resolveSize((int)this.mBallPulseView.getMeasuredHeight(), (int)heightMeasureSpec));
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int p_width = this.getMeasuredWidth();
        int p_height = this.getMeasuredHeight();
        int c_width = this.mBallPulseView.getMeasuredWidth();
        int c_height = this.mBallPulseView.getMeasuredHeight();
        int left = p_width / 2 - c_width / 2;
        int top = p_height / 2 - c_height / 2;
        this.mBallPulseView.layout(left, top, left + c_width, top + c_height);
    }

    @Override
    public void onInitialized(@NonNull RefreshKernel kernel, int height, int extendHeight) {
    }

    @Override
    public boolean isSupportHorizontalDrag() {
        return false;
    }

    @Override
    public void onHorizontalDrag(float percentX, int offsetX, int offsetMax) {
    }

    @Override
    public void onPulling(float percent, int offset, int footerHeight, int extendHeight) {
    }

    @Override
    public void onReleasing(float percent, int offset, int footerHeight, int extendHeight) {
    }

    @Override
    public void onReleased(RefreshLayout layout, int footerHeight, int extendHeight) {
    }

    @Override
    public void onStartAnimator(@NonNull RefreshLayout layout, int footerHeight, int extendHeight) {
        this.mBallPulseView.startAnim();
    }

    @Override
    public void onStateChanged(RefreshLayout refreshLayout, RefreshState oldState, RefreshState newState) {
    }

    @Override
    public int onFinish(@NonNull RefreshLayout layout, boolean success) {
        this.mBallPulseView.stopAnim();
        return 0;
    }

    @Override
    public boolean setNoMoreData(boolean noMoreData) {
        return false;
    }

    @Override
    @Deprecated
    public void setPrimaryColors(int ... colors) {
        if (this.mAnimationColor == null && colors.length > 1) {
            this.mBallPulseView.setAnimatingColor(colors[0]);
        }
        if (this.mNormalColor == null) {
            if (colors.length > 1) {
                this.mBallPulseView.setNormalColor(colors[1]);
            } else if (colors.length > 0) {
                this.mBallPulseView.setNormalColor(ColorUtils.compositeColors((int)-1711276033, (int)colors[0]));
            }
        }
    }

    @Override
    @NonNull
    public View getView() {
        return this;
    }

    @Override
    @NonNull
    public SpinnerStyle getSpinnerStyle() {
        return this.mSpinnerStyle;
    }

    public BallPulseFooter setSpinnerStyle(SpinnerStyle mSpinnerStyle) {
        this.mSpinnerStyle = mSpinnerStyle;
        return this;
    }

    public BallPulseFooter setIndicatorColor(@ColorInt int color) {
        this.mBallPulseView.setIndicatorColor(color);
        return this;
    }

    public BallPulseFooter setNormalColor(@ColorInt int color) {
        this.mNormalColor = color;
        this.mBallPulseView.setNormalColor(color);
        return this;
    }

    public BallPulseFooter setAnimatingColor(@ColorInt int color) {
        this.mAnimationColor = color;
        this.mBallPulseView.setAnimatingColor(color);
        return this;
    }
}

