/*
 * Decompiled with CFR 0.152.
 */
package com.scwang.smartrefresh.header.material;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RadialGradient;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.OvalShape;
import android.graphics.drawable.shapes.Shape;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.widget.ImageView;

@SuppressLint(value={"ViewConstructor"})
public class CircleImageView
extends ImageView {
    protected static final int KEY_SHADOW_COLOR = 0x1E000000;
    protected static final int FILL_SHADOW_COLOR = 0x3D000000;
    protected static final float X_OFFSET = 0.0f;
    protected static final float Y_OFFSET = 1.75f;
    protected static final float SHADOW_RADIUS = 3.5f;
    protected static final int SHADOW_ELEVATION = 4;
    int mShadowRadius;

    public CircleImageView(Context context, int color) {
        super(context);
        ShapeDrawable circle;
        CircleImageView thisView = this;
        float density = thisView.getResources().getDisplayMetrics().density;
        int shadowYOffset = (int)(density * 1.75f);
        int shadowXOffset = (int)(density * 0.0f);
        this.mShadowRadius = (int)(density * 3.5f);
        if (Build.VERSION.SDK_INT >= 21) {
            circle = new ShapeDrawable((Shape)new OvalShape());
            thisView.setElevation(4.0f * density);
        } else {
            OvalShadow oval = new OvalShadow(this.mShadowRadius);
            circle = new ShapeDrawable((Shape)oval);
            thisView.setLayerType(1, circle.getPaint());
            circle.getPaint().setShadowLayer((float)this.mShadowRadius, (float)shadowXOffset, (float)shadowYOffset, 0x1E000000);
            int padding = this.mShadowRadius;
            thisView.setPadding(padding, padding, padding, padding);
        }
        circle.getPaint().setColor(color);
        if (Build.VERSION.SDK_INT >= 16) {
            thisView.setBackground((Drawable)circle);
        } else {
            thisView.setBackgroundDrawable((Drawable)circle);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        CircleImageView thisView = this;
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (Build.VERSION.SDK_INT < 21) {
            super.setMeasuredDimension(thisView.getMeasuredWidth() + this.mShadowRadius * 2, thisView.getMeasuredHeight() + this.mShadowRadius * 2);
        }
    }

    public void setBackgroundColor(@ColorInt int color) {
        CircleImageView thisView = this;
        if (thisView.getBackground() instanceof ShapeDrawable) {
            ((ShapeDrawable)thisView.getBackground()).getPaint().setColor(color);
        }
    }

    protected class OvalShadow
    extends OvalShape {
        protected RadialGradient mRadialGradient;
        protected Paint mShadowPaint = new Paint();

        protected OvalShadow(int shadowRadius) {
            CircleImageView.this.mShadowRadius = shadowRadius;
            this.updateRadialGradient((int)super.rect().width());
        }

        protected void onResize(float width, float height) {
            super.onResize(width, height);
            this.updateRadialGradient((int)width);
        }

        public void draw(Canvas canvas, Paint paint) {
            CircleImageView thisView = CircleImageView.this;
            int viewWidth = thisView.getWidth();
            int viewHeight = thisView.getHeight();
            canvas.drawCircle((float)viewWidth / 2.0f, (float)viewHeight / 2.0f, (float)viewWidth / 2.0f, this.mShadowPaint);
            canvas.drawCircle((float)viewWidth / 2.0f, (float)viewHeight / 2.0f, (float)viewWidth / 2.0f - (float)CircleImageView.this.mShadowRadius, paint);
        }

        protected void updateRadialGradient(int diameter) {
            this.mRadialGradient = new RadialGradient((float)diameter / 2.0f, (float)diameter / 2.0f, (float)CircleImageView.this.mShadowRadius, new int[]{0x3D000000, 0}, null, Shader.TileMode.CLAMP);
            this.mShadowPaint.setShader((Shader)this.mRadialGradient);
        }
    }
}

