/*
 * Decompiled with CFR 0.152.
 */
package com.scwang.smartrefresh.header.internal.pathview;

import android.content.Context;
import android.graphics.Canvas;
import android.util.AttributeSet;
import android.view.View;
import com.scwang.smartrefresh.header.internal.pathview.PathsDrawable;

public class PathsView
extends View {
    protected PathsDrawable mPathsDrawable = new PathsDrawable();

    public PathsView(Context context) {
        this(context, null);
    }

    public PathsView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        PathsView thisView = this;
        if (thisView.getTag() instanceof String) {
            this.parserPaths(thisView.getTag().toString());
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        PathsView thisView = this;
        PathsDrawable drawable = this.mPathsDrawable;
        super.setMeasuredDimension(View.resolveSize((int)(drawable.getBounds().width() + thisView.getPaddingLeft() + thisView.getPaddingRight()), (int)widthMeasureSpec), View.resolveSize((int)(drawable.getBounds().height() + thisView.getPaddingTop() + thisView.getPaddingBottom()), (int)heightMeasureSpec));
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        PathsView thisView = this;
        super.onLayout(changed, left, top, right, bottom);
        this.mPathsDrawable.setBounds(thisView.getPaddingLeft(), thisView.getPaddingTop(), Math.max(right - left - thisView.getPaddingRight(), thisView.getPaddingLeft()), Math.max(bottom - top - thisView.getPaddingTop(), thisView.getPaddingTop()));
    }

    protected void onDraw(Canvas canvas) {
        this.mPathsDrawable.draw(canvas);
    }

    public boolean parserPaths(String ... paths) {
        return this.mPathsDrawable.parserPaths(paths);
    }

    public void parserColors(int ... colors) {
        this.mPathsDrawable.parserColors(colors);
    }
}

