/*
 * Decompiled with CFR 0.152.
 */
package com.scwang.smartrefresh.header;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Point;
import android.support.annotation.NonNull;
import android.support.v4.graphics.ColorUtils;
import android.util.AttributeSet;
import com.scwang.smartrefresh.header.R;
import com.scwang.smartrefresh.header.fungame.FunGameView;
import com.scwang.smartrefresh.layout.api.RefreshKernel;
import com.scwang.smartrefresh.layout.util.SmartUtil;
import java.util.ArrayList;
import java.util.List;

public class FunGameHitBlockHeader
extends FunGameView {
    protected static final int BLOCK_VERTICAL_NUM = 5;
    protected static final int BLOCK_HORIZONTAL_NUM = 3;
    protected static final float BLOCK_WIDTH_RATIO = 0.01806f;
    protected static final float RACKET_POSITION_RATIO = 0.8f;
    protected static final float BLOCK_POSITION_RATIO = 0.08f;
    protected static final int DEFAULT_ANGLE = 30;
    static final float DIVIDING_LINE_SIZE = 1.0f;
    protected static final int SPEED = 3;
    protected float blockHeight;
    protected float blockWidth;
    protected float BALL_RADIUS;
    protected Paint blockPaint;
    protected float blockLeft;
    protected float racketLeft;
    protected float cx;
    protected float cy;
    protected List<Point> pointList;
    protected boolean isLeft;
    protected int angle;
    protected int blockHorizontalNum;
    protected int speed;

    public FunGameHitBlockHeader(Context context) {
        this(context, null);
    }

    public FunGameHitBlockHeader(Context context, AttributeSet attrs) {
        super(context, attrs, 0);
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.FunGameHitBlockHeader);
        this.speed = ta.getInt(R.styleable.FunGameHitBlockHeader_fghBallSpeed, SmartUtil.dp2px((float)3.0f));
        this.blockHorizontalNum = ta.getInt(R.styleable.FunGameHitBlockHeader_fghBlockHorizontalNum, 3);
        ta.recycle();
        this.blockPaint = new Paint(1);
        this.blockPaint.setStyle(Paint.Style.FILL);
        this.BALL_RADIUS = SmartUtil.dp2px((float)4.0f);
    }

    @Override
    public void onInitialized(@NonNull RefreshKernel kernel, int height, int maxDragHeight) {
        FunGameHitBlockHeader thisView = this;
        int measuredWidth = thisView.getMeasuredWidth();
        this.blockHeight = 1.0f * (float)height / 5.0f - 1.0f;
        this.blockWidth = (float)measuredWidth * 0.01806f;
        this.blockLeft = (float)measuredWidth * 0.08f;
        this.racketLeft = (float)measuredWidth * 0.8f;
        this.controllerSize = (int)(this.blockHeight * 1.6f);
        super.onInitialized(kernel, height, maxDragHeight);
    }

    @Override
    protected void resetConfigParams() {
        this.cx = this.racketLeft - 3.0f * this.BALL_RADIUS;
        this.cy = (int)((float)this.mHeaderHeight * 0.5f);
        this.controllerPosition = 1.0f;
        this.angle = 30;
        this.isLeft = true;
        if (this.pointList == null) {
            this.pointList = new ArrayList<Point>();
        } else {
            this.pointList.clear();
        }
    }

    protected boolean checkTouchRacket(float y) {
        boolean flag = false;
        float diffVal = y - this.controllerPosition;
        if (diffVal >= 0.0f && diffVal <= (float)this.controllerSize) {
            flag = true;
        }
        return flag;
    }

    protected boolean checkTouchBlock(float x, float y) {
        int columnX = (int)((x - this.blockLeft - this.BALL_RADIUS - (float)this.speed) / this.blockWidth);
        columnX = columnX == this.blockHorizontalNum ? columnX - 1 : columnX;
        int rowY = (int)(y / this.blockHeight);
        rowY = rowY == 5 ? rowY - 1 : rowY;
        Point p = new Point();
        p.set(columnX, rowY);
        boolean flag = false;
        for (Point point : this.pointList) {
            if (!point.equals(p.x, p.y)) continue;
            flag = true;
            break;
        }
        if (!flag) {
            this.pointList.add(p);
        }
        return !flag;
    }

    @Override
    protected void drawGame(Canvas canvas, int width, int height) {
        FunGameHitBlockHeader thisView = this;
        this.drawColorBlock(canvas);
        this.drawRacket(canvas);
        if (this.status == 1 || this.status == 3 || this.status == 4 || thisView.isInEditMode()) {
            this.drawBallPath(canvas, width);
        }
    }

    protected void drawRacket(Canvas canvas) {
        this.mPaint.setColor(this.rModelColor);
        canvas.drawRect(this.racketLeft, this.controllerPosition, this.racketLeft + this.blockWidth, this.controllerPosition + (float)this.controllerSize, this.mPaint);
    }

    protected void drawBallPath(Canvas canvas, int width) {
        this.mPaint.setColor(this.mModelColor);
        if (this.cx <= this.blockLeft + (float)this.blockHorizontalNum * this.blockWidth + (float)(this.blockHorizontalNum - 1) * 1.0f + this.BALL_RADIUS && this.checkTouchBlock(this.cx, this.cy)) {
            this.isLeft = false;
        }
        if (this.cx <= this.blockLeft + this.BALL_RADIUS) {
            this.isLeft = false;
        }
        if (this.cx + this.BALL_RADIUS >= this.racketLeft && this.cx - this.BALL_RADIUS < this.racketLeft + this.blockWidth) {
            if (this.checkTouchRacket(this.cy)) {
                if (this.pointList.size() == this.blockHorizontalNum * 5) {
                    this.status = 2;
                    return;
                }
                this.isLeft = true;
            }
        } else if (this.cx > (float)width) {
            this.status = 2;
        }
        if (this.cy <= this.BALL_RADIUS + 1.0f) {
            this.angle = 150;
        } else if (this.cy >= (float)this.mHeaderHeight - this.BALL_RADIUS - 1.0f) {
            this.angle = 210;
        }
        this.cx = this.isLeft ? (this.cx -= (float)this.speed) : (this.cx += (float)this.speed);
        this.cy -= (float)Math.tan(Math.toRadians(this.angle)) * (float)this.speed;
        canvas.drawCircle(this.cx, this.cy, this.BALL_RADIUS, this.mPaint);
        FunGameHitBlockHeader thisView = this;
        thisView.invalidate();
    }

    protected void drawColorBlock(Canvas canvas) {
        for (int i = 0; i < this.blockHorizontalNum * 5; ++i) {
            int row = i / this.blockHorizontalNum;
            int column = i % this.blockHorizontalNum;
            boolean flag = false;
            for (Point point : this.pointList) {
                if (!point.equals(column, row)) continue;
                flag = true;
                break;
            }
            if (flag) continue;
            this.blockPaint.setColor(ColorUtils.setAlphaComponent((int)this.lModelColor, (int)(255 / (column + 1))));
            float left = this.blockLeft + (float)column * (this.blockWidth + 1.0f);
            float top = 1.0f + (float)row * (this.blockHeight + 1.0f);
            canvas.drawRect(left, top, left + this.blockWidth, top + this.blockHeight, this.blockPaint);
        }
    }
}

