/*
 * Decompiled with CFR 0.152.
 */
package com.scwang.smartrefresh.header.waveswipe;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.util.Log;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.BounceInterpolator;
import com.scwang.smartrefresh.header.waveswipe.DropBounceInterpolator;

public class WaveView
extends View
implements ViewTreeObserver.OnPreDrawListener {
    private static final long DROP_CIRCLE_ANIMATOR_DURATION = 500L;
    private static final long DROP_VERTEX_ANIMATION_DURATION = 500L;
    private static final long DROP_BOUNCE_ANIMATOR_DURATION = 500L;
    private static final int DROP_REMOVE_ANIMATOR_DURATION = 200;
    private static final int WAVE_ANIMATOR_DURATION = 1000;
    private static final float MAX_WAVE_HEIGHT = 0.2f;
    private static final int SHADOW_COLOR = -1728053248;
    private float mDropCircleRadius = 100.0f;
    private Paint mPaint;
    private Path mWavePath;
    private Path mDropTangentPath;
    private Path mDropCirclePath;
    private Path mShadowPath;
    private RectF mDropRect;
    private int mWidth;
    private float mCurrentCircleCenterY;
    private int mMaxDropHeight;
    private boolean mIsManualRefreshing = false;
    private boolean mDropHeightUpdated = false;
    private int mUpdateMaxDropHeight;
    private ValueAnimator mDropVertexAnimator;
    private ValueAnimator mDropBounceVerticalAnimator;
    private ValueAnimator mDropBounceHorizontalAnimator;
    private ValueAnimator mDropCircleAnimator;
    private ValueAnimator mDisappearCircleAnimator;
    private ValueAnimator mWaveReverseAnimator;
    private static final float[][] BEGIN_PHASE_POINTS = new float[][]{{0.1655f, 0.0f}, {0.4188f, -0.0109f}, {0.4606f, -0.0049f}, {0.4893f, 0.0f}, {0.4893f, 0.0f}, {0.5f, 0.0f}};
    private static final float[][] APPEAR_PHASE_POINTS = new float[][]{{0.1655f, 0.0f}, {0.5237f, 0.0553f}, {0.4557f, 0.0936f}, {0.3908f, 0.1302f}, {0.4303f, 0.2173f}, {0.5f, 0.2173f}};
    private static final float[][] EXPAND_PHASE_POINTS = new float[][]{{0.1655f, 0.0f}, {0.5909f, 0.0f}, {0.4557f, 0.1642f}, {0.3941f, 0.2061f}, {0.4303f, 0.2889f}, {0.5f, 0.2889f}};
    private ValueAnimator.AnimatorUpdateListener mAnimatorUpdateListener = new ValueAnimator.AnimatorUpdateListener(){

        public void onAnimationUpdate(ValueAnimator valueAnimator) {
            WaveView.this.postInvalidate();
        }
    };

    public WaveView(Context context) {
        super(context);
        this.getViewTreeObserver().addOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
        this.initView();
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        this.mWidth = w;
        this.mDropCircleRadius = (float)w / 14.4f;
        this.updateMaxDropHeight((int)Math.min((float)Math.min(w, h), (float)this.getHeight() - this.mDropCircleRadius));
        super.onSizeChanged(w, h, oldw, oldh);
    }

    public boolean onPreDraw() {
        this.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
        if (this.mDropHeightUpdated) {
            this.updateMaxDropHeight(this.mUpdateMaxDropHeight);
        }
        return false;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        canvas.drawPath(this.mWavePath, this.mPaint);
        if (!this.isInEditMode()) {
            this.mWavePath.rewind();
            this.mDropTangentPath.rewind();
            this.mDropCirclePath.rewind();
        }
        float circleCenterY = ((Float)this.mDropCircleAnimator.getAnimatedValue()).floatValue();
        float circleCenterX = (float)this.mWidth / 2.0f;
        this.mDropRect.setEmpty();
        float scale = ((Float)this.mDisappearCircleAnimator.getAnimatedValue()).floatValue();
        float vertical = ((Float)this.mDropBounceVerticalAnimator.getAnimatedValue()).floatValue();
        float horizontal = ((Float)this.mDropBounceHorizontalAnimator.getAnimatedValue()).floatValue();
        this.mDropRect.set(circleCenterX - this.mDropCircleRadius * (1.0f + vertical) * scale + this.mDropCircleRadius * horizontal / 2.0f, circleCenterY + this.mDropCircleRadius * (1.0f + horizontal) * scale - this.mDropCircleRadius * vertical / 2.0f, circleCenterX + this.mDropCircleRadius * (1.0f + vertical) * scale - this.mDropCircleRadius * horizontal / 2.0f, circleCenterY - this.mDropCircleRadius * (1.0f + horizontal) * scale + this.mDropCircleRadius * vertical / 2.0f);
        float vertex = ((Float)this.mDropVertexAnimator.getAnimatedValue()).floatValue();
        this.mDropTangentPath.moveTo(circleCenterX, vertex);
        double q = (Math.pow(this.mDropCircleRadius, 2.0) + (double)(circleCenterY * vertex) - Math.pow(circleCenterY, 2.0)) / (double)(vertex - circleCenterY);
        double b = -2.0 * (double)this.mWidth / 2.0;
        double c = Math.pow(q - (double)circleCenterY, 2.0) + Math.pow(circleCenterX, 2.0) - Math.pow(this.mDropCircleRadius, 2.0);
        double p1 = (-b + Math.sqrt(b * b - 4.0 * c)) / 2.0;
        double p2 = (-b - Math.sqrt(b * b - 4.0 * c)) / 2.0;
        this.mDropTangentPath.lineTo((float)p1, (float)q);
        this.mDropTangentPath.lineTo((float)p2, (float)q);
        this.mDropTangentPath.close();
        this.mShadowPath.set(this.mDropTangentPath);
        this.mShadowPath.addOval(this.mDropRect, Path.Direction.CCW);
        this.mDropCirclePath.addOval(this.mDropRect, Path.Direction.CCW);
        if (this.mDropVertexAnimator.isRunning()) {
            // empty if block
        }
        canvas.drawPath(this.mDropTangentPath, this.mPaint);
        canvas.drawPath(this.mDropCirclePath, this.mPaint);
    }

    protected void onDetachedFromWindow() {
        if (this.mDisappearCircleAnimator != null) {
            this.mDisappearCircleAnimator.end();
            this.mDisappearCircleAnimator.removeAllUpdateListeners();
        }
        if (this.mDropCircleAnimator != null) {
            this.mDropCircleAnimator.end();
            this.mDropCircleAnimator.removeAllUpdateListeners();
        }
        if (this.mDropVertexAnimator != null) {
            this.mDropVertexAnimator.end();
            this.mDropVertexAnimator.removeAllUpdateListeners();
        }
        if (this.mWaveReverseAnimator != null) {
            this.mWaveReverseAnimator.end();
            this.mWaveReverseAnimator.removeAllUpdateListeners();
        }
        if (this.mDropBounceHorizontalAnimator != null) {
            this.mDropBounceHorizontalAnimator.end();
            this.mDropBounceHorizontalAnimator.removeAllUpdateListeners();
        }
        if (this.mDropBounceVerticalAnimator != null) {
            this.mDropBounceVerticalAnimator.end();
            this.mDropBounceVerticalAnimator.removeAllUpdateListeners();
        }
        super.onDetachedFromWindow();
    }

    private void initView() {
        this.setUpPaint();
        this.setUpPath();
        this.resetAnimator();
        this.mDropRect = new RectF();
        this.setLayerType(1, null);
    }

    private void setUpPaint() {
        float density = this.getResources().getDisplayMetrics().density;
        this.mPaint = new Paint();
        this.mPaint.setColor(-14575885);
        this.mPaint.setAntiAlias(true);
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mPaint.setShadowLayer((float)((int)(0.5f + 2.0f * density)), 0.0f, 0.0f, -1728053248);
    }

    private void setUpPath() {
        this.mWavePath = new Path();
        this.mDropTangentPath = new Path();
        this.mDropCirclePath = new Path();
        this.mShadowPath = new Path();
    }

    private void resetAnimator() {
        this.mDropVertexAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 0.0f});
        this.mDropBounceVerticalAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 0.0f});
        this.mDropBounceHorizontalAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 0.0f});
        this.mDropCircleAnimator = ValueAnimator.ofFloat((float[])new float[]{-1000.0f, -1000.0f});
        this.mDropCircleAnimator.start();
        this.mDisappearCircleAnimator = ValueAnimator.ofFloat((float[])new float[]{1.0f, 1.0f});
        this.mDisappearCircleAnimator.setDuration(1L);
        this.mDisappearCircleAnimator.start();
    }

    private void onPreDragWave() {
        if (this.mWaveReverseAnimator != null && this.mWaveReverseAnimator.isRunning()) {
            this.mWaveReverseAnimator.cancel();
        }
    }

    public void manualRefresh() {
        if (this.mIsManualRefreshing) {
            return;
        }
        this.mIsManualRefreshing = true;
        this.mDropCircleAnimator = ValueAnimator.ofFloat((float[])new float[]{this.mMaxDropHeight, this.mMaxDropHeight});
        this.mDropCircleAnimator.start();
        this.mDropVertexAnimator = ValueAnimator.ofFloat((float[])new float[]{(float)this.mMaxDropHeight - this.mDropCircleRadius, (float)this.mMaxDropHeight - this.mDropCircleRadius});
        this.mDropVertexAnimator.start();
        this.mCurrentCircleCenterY = this.mMaxDropHeight;
        this.postInvalidate();
    }

    public void beginPhase(float move1) {
        this.onPreDragWave();
        this.mWavePath.moveTo(0.0f, 0.0f);
        this.mWavePath.cubicTo((float)this.mWidth * BEGIN_PHASE_POINTS[0][0], BEGIN_PHASE_POINTS[0][1], (float)this.mWidth * BEGIN_PHASE_POINTS[1][0], (float)this.mWidth * (BEGIN_PHASE_POINTS[1][1] + move1), (float)this.mWidth * BEGIN_PHASE_POINTS[2][0], (float)this.mWidth * (BEGIN_PHASE_POINTS[2][1] + move1));
        this.mWavePath.cubicTo((float)this.mWidth * BEGIN_PHASE_POINTS[3][0], (float)this.mWidth * (BEGIN_PHASE_POINTS[3][1] + move1), (float)this.mWidth * BEGIN_PHASE_POINTS[4][0], (float)this.mWidth * (BEGIN_PHASE_POINTS[4][1] + move1), (float)this.mWidth * BEGIN_PHASE_POINTS[5][0], (float)this.mWidth * (BEGIN_PHASE_POINTS[5][1] + move1));
        this.mWavePath.cubicTo((float)this.mWidth - (float)this.mWidth * BEGIN_PHASE_POINTS[4][0], (float)this.mWidth * (BEGIN_PHASE_POINTS[4][1] + move1), (float)this.mWidth - (float)this.mWidth * BEGIN_PHASE_POINTS[3][0], (float)this.mWidth * (BEGIN_PHASE_POINTS[3][1] + move1), (float)this.mWidth - (float)this.mWidth * BEGIN_PHASE_POINTS[2][0], (float)this.mWidth * (BEGIN_PHASE_POINTS[2][1] + move1));
        this.mWavePath.cubicTo((float)this.mWidth - (float)this.mWidth * BEGIN_PHASE_POINTS[1][0], (float)this.mWidth * (BEGIN_PHASE_POINTS[1][1] + move1), (float)this.mWidth - (float)this.mWidth * BEGIN_PHASE_POINTS[0][0], BEGIN_PHASE_POINTS[0][1], (float)this.mWidth, 0.0f);
        this.postInvalidateOnAnimation();
    }

    public void postInvalidateOnAnimation() {
        if (Build.VERSION.SDK_INT >= 16) {
            super.postInvalidateOnAnimation();
        } else {
            super.invalidate();
        }
    }

    public void appearPhase(float move1, float move2) {
        this.onPreDragWave();
        this.mWavePath.moveTo(0.0f, 0.0f);
        this.mWavePath.cubicTo((float)this.mWidth * APPEAR_PHASE_POINTS[0][0], (float)this.mWidth * APPEAR_PHASE_POINTS[0][1], (float)this.mWidth * Math.min(BEGIN_PHASE_POINTS[1][0] + move2, APPEAR_PHASE_POINTS[1][0]), (float)this.mWidth * Math.max(BEGIN_PHASE_POINTS[1][1] + move1 - move2, APPEAR_PHASE_POINTS[1][1]), (float)this.mWidth * Math.max(BEGIN_PHASE_POINTS[2][0] - move2, APPEAR_PHASE_POINTS[2][0]), (float)this.mWidth * Math.max(BEGIN_PHASE_POINTS[2][1] + move1 - move2, APPEAR_PHASE_POINTS[2][1]));
        this.mWavePath.cubicTo((float)this.mWidth * Math.max(BEGIN_PHASE_POINTS[3][0] - move2, APPEAR_PHASE_POINTS[3][0]), (float)this.mWidth * Math.min(BEGIN_PHASE_POINTS[3][1] + move1 + move2, APPEAR_PHASE_POINTS[3][1]), (float)this.mWidth * Math.max(BEGIN_PHASE_POINTS[4][0] - move2, APPEAR_PHASE_POINTS[4][0]), (float)this.mWidth * Math.min(BEGIN_PHASE_POINTS[4][1] + move1 + move2, APPEAR_PHASE_POINTS[4][1]), (float)this.mWidth * APPEAR_PHASE_POINTS[5][0], (float)this.mWidth * Math.min(BEGIN_PHASE_POINTS[0][1] + move1 + move2, APPEAR_PHASE_POINTS[5][1]));
        this.mWavePath.cubicTo((float)this.mWidth - (float)this.mWidth * Math.max(BEGIN_PHASE_POINTS[4][0] - move2, APPEAR_PHASE_POINTS[4][0]), (float)this.mWidth * Math.min(BEGIN_PHASE_POINTS[4][1] + move1 + move2, APPEAR_PHASE_POINTS[4][1]), (float)this.mWidth - (float)this.mWidth * Math.max(BEGIN_PHASE_POINTS[3][0] - move2, APPEAR_PHASE_POINTS[3][0]), (float)this.mWidth * Math.min(BEGIN_PHASE_POINTS[3][1] + move1 + move2, APPEAR_PHASE_POINTS[3][1]), (float)this.mWidth - (float)this.mWidth * Math.max(BEGIN_PHASE_POINTS[2][0] - move2, APPEAR_PHASE_POINTS[2][0]), (float)this.mWidth * Math.max(BEGIN_PHASE_POINTS[2][1] + move1 - move2, APPEAR_PHASE_POINTS[2][1]));
        this.mWavePath.cubicTo((float)this.mWidth - (float)this.mWidth * Math.min(BEGIN_PHASE_POINTS[1][0] + move2, APPEAR_PHASE_POINTS[1][0]), (float)this.mWidth * Math.max(BEGIN_PHASE_POINTS[1][1] + move1 - move2, APPEAR_PHASE_POINTS[1][1]), (float)this.mWidth - (float)this.mWidth * APPEAR_PHASE_POINTS[0][0], (float)this.mWidth * APPEAR_PHASE_POINTS[0][1], (float)this.mWidth, 0.0f);
        this.mCurrentCircleCenterY = (float)this.mWidth * Math.min(BEGIN_PHASE_POINTS[3][1] + move1 + move2, APPEAR_PHASE_POINTS[3][1]) + this.mDropCircleRadius;
        this.postInvalidateOnAnimation();
    }

    public void expandPhase(float move1, float move2, float move3) {
        this.onPreDragWave();
        this.mWavePath.moveTo(0.0f, 0.0f);
        this.mWavePath.cubicTo((float)this.mWidth * EXPAND_PHASE_POINTS[0][0], (float)this.mWidth * EXPAND_PHASE_POINTS[0][1], (float)this.mWidth * Math.min(Math.min(BEGIN_PHASE_POINTS[1][0] + move2, APPEAR_PHASE_POINTS[1][0]) + move3, EXPAND_PHASE_POINTS[1][0]), (float)this.mWidth * Math.max(Math.max(BEGIN_PHASE_POINTS[1][1] + move1 - move2, APPEAR_PHASE_POINTS[1][1]) - move3, EXPAND_PHASE_POINTS[1][1]), (float)this.mWidth * Math.max(BEGIN_PHASE_POINTS[2][0] - move2, EXPAND_PHASE_POINTS[2][0]), (float)this.mWidth * Math.min(Math.max(BEGIN_PHASE_POINTS[2][1] + move1 - move2, APPEAR_PHASE_POINTS[2][1]) + move3, EXPAND_PHASE_POINTS[2][1]));
        this.mWavePath.cubicTo((float)this.mWidth * Math.min(Math.max(BEGIN_PHASE_POINTS[3][0] - move2, APPEAR_PHASE_POINTS[3][0]) + move3, EXPAND_PHASE_POINTS[3][0]), (float)this.mWidth * Math.min(Math.min(BEGIN_PHASE_POINTS[3][1] + move1 + move2, APPEAR_PHASE_POINTS[3][1]) + move3, EXPAND_PHASE_POINTS[3][1]), (float)this.mWidth * Math.max(BEGIN_PHASE_POINTS[4][0] - move2, EXPAND_PHASE_POINTS[4][0]), (float)this.mWidth * Math.min(Math.min(BEGIN_PHASE_POINTS[4][1] + move1 + move2, APPEAR_PHASE_POINTS[4][1]) + move3, EXPAND_PHASE_POINTS[4][1]), (float)this.mWidth * EXPAND_PHASE_POINTS[5][0], (float)this.mWidth * Math.min(Math.min(BEGIN_PHASE_POINTS[0][1] + move1 + move2, APPEAR_PHASE_POINTS[5][1]) + move3, EXPAND_PHASE_POINTS[5][1]));
        this.mWavePath.cubicTo((float)this.mWidth - (float)this.mWidth * Math.max(BEGIN_PHASE_POINTS[4][0] - move2, EXPAND_PHASE_POINTS[4][0]), (float)this.mWidth * Math.min(Math.min(BEGIN_PHASE_POINTS[4][1] + move1 + move2, APPEAR_PHASE_POINTS[4][1]) + move3, EXPAND_PHASE_POINTS[4][1]), (float)this.mWidth - (float)this.mWidth * Math.min(Math.max(BEGIN_PHASE_POINTS[3][0] - move2, APPEAR_PHASE_POINTS[3][0]) + move3, EXPAND_PHASE_POINTS[3][0]), (float)this.mWidth * Math.min(Math.min(BEGIN_PHASE_POINTS[3][1] + move1 + move2, APPEAR_PHASE_POINTS[3][1]) + move3, EXPAND_PHASE_POINTS[3][1]), (float)this.mWidth - (float)this.mWidth * Math.max(BEGIN_PHASE_POINTS[2][0] - move2, EXPAND_PHASE_POINTS[2][0]), (float)this.mWidth * Math.min(Math.max(BEGIN_PHASE_POINTS[2][1] + move1 - move2, APPEAR_PHASE_POINTS[2][1]) + move3, EXPAND_PHASE_POINTS[2][1]));
        this.mWavePath.cubicTo((float)this.mWidth - (float)this.mWidth * Math.min(Math.min(BEGIN_PHASE_POINTS[1][0] + move2, APPEAR_PHASE_POINTS[1][0]) + move3, EXPAND_PHASE_POINTS[1][0]), (float)this.mWidth * Math.max(Math.max(BEGIN_PHASE_POINTS[1][1] + move1 - move2, APPEAR_PHASE_POINTS[1][1]) - move3, EXPAND_PHASE_POINTS[1][1]), (float)this.mWidth - (float)this.mWidth * EXPAND_PHASE_POINTS[0][0], (float)this.mWidth * EXPAND_PHASE_POINTS[0][1], (float)this.mWidth, 0.0f);
        this.mCurrentCircleCenterY = (float)this.mWidth * Math.min(Math.min(BEGIN_PHASE_POINTS[3][1] + move1 + move2, APPEAR_PHASE_POINTS[3][1]) + move3, EXPAND_PHASE_POINTS[3][1]) + this.mDropCircleRadius;
        this.postInvalidateOnAnimation();
    }

    private void updateMaxDropHeight(int height) {
        if (500.0f * ((float)this.mWidth / 1440.0f) > (float)height) {
            Log.w((String)"WaveView", (String)("DropHeight is more than " + 500.0f * ((float)this.mWidth / 1440.0f)));
            return;
        }
        this.mMaxDropHeight = (int)Math.min((float)height, (float)this.getHeight() - this.mDropCircleRadius);
        if (this.mIsManualRefreshing) {
            this.mIsManualRefreshing = false;
            this.manualRefresh();
        }
    }

    public void startDropAnimation() {
        this.mDisappearCircleAnimator = ValueAnimator.ofFloat((float[])new float[]{1.0f, 1.0f});
        this.mDisappearCircleAnimator.setDuration(1L);
        this.mDisappearCircleAnimator.start();
        this.mDropCircleAnimator = ValueAnimator.ofFloat((float[])new float[]{500.0f * ((float)this.mWidth / 1440.0f), this.mMaxDropHeight});
        this.mDropCircleAnimator.setDuration(500L);
        this.mDropCircleAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                WaveView.this.mCurrentCircleCenterY = ((Float)animation.getAnimatedValue()).floatValue();
                WaveView.this.postInvalidateOnAnimation();
            }
        });
        this.mDropCircleAnimator.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        this.mDropCircleAnimator.start();
        this.mDropVertexAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, (float)this.mMaxDropHeight - this.mDropCircleRadius});
        this.mDropVertexAnimator.setDuration(500L);
        this.mDropVertexAnimator.addUpdateListener(this.mAnimatorUpdateListener);
        this.mDropVertexAnimator.start();
        this.mDropBounceVerticalAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        this.mDropBounceVerticalAnimator.setDuration(500L);
        this.mDropBounceVerticalAnimator.addUpdateListener(this.mAnimatorUpdateListener);
        this.mDropBounceVerticalAnimator.setInterpolator((TimeInterpolator)new DropBounceInterpolator());
        this.mDropBounceVerticalAnimator.setStartDelay(500L);
        this.mDropBounceVerticalAnimator.start();
        this.mDropBounceHorizontalAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        this.mDropBounceHorizontalAnimator.setDuration(500L);
        this.mDropBounceHorizontalAnimator.addUpdateListener(this.mAnimatorUpdateListener);
        this.mDropBounceHorizontalAnimator.setInterpolator((TimeInterpolator)new DropBounceInterpolator());
        this.mDropBounceHorizontalAnimator.setStartDelay(625L);
        this.mDropBounceHorizontalAnimator.start();
    }

    public void startDisappearCircleAnimation() {
        this.mDisappearCircleAnimator = ValueAnimator.ofFloat((float[])new float[]{1.0f, 0.0f});
        this.mDisappearCircleAnimator.addUpdateListener(this.mAnimatorUpdateListener);
        this.mDisappearCircleAnimator.setDuration(200L);
        this.mDisappearCircleAnimator.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animator) {
            }

            public void onAnimationEnd(Animator animator) {
                WaveView.this.resetAnimator();
                WaveView.this.mIsManualRefreshing = false;
            }

            public void onAnimationCancel(Animator animator) {
            }

            public void onAnimationRepeat(Animator animator) {
            }
        });
        this.mDisappearCircleAnimator.start();
    }

    public void startWaveAnimation(float h) {
        h = Math.min(h, 0.2f) * (float)this.mWidth;
        this.mWaveReverseAnimator = ValueAnimator.ofFloat((float[])new float[]{h, 0.0f});
        this.mWaveReverseAnimator.setDuration(1000L);
        this.mWaveReverseAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                float h = ((Float)valueAnimator.getAnimatedValue()).floatValue();
                WaveView.this.mWavePath.moveTo(0.0f, 0.0f);
                WaveView.this.mWavePath.quadTo(0.25f * (float)WaveView.this.mWidth, 0.0f, 0.333f * (float)WaveView.this.mWidth, h * 0.5f);
                WaveView.this.mWavePath.quadTo((float)WaveView.this.mWidth * 0.5f, h * 1.4f, 0.666f * (float)WaveView.this.mWidth, h * 0.5f);
                WaveView.this.mWavePath.quadTo(0.75f * (float)WaveView.this.mWidth, 0.0f, (float)WaveView.this.mWidth, 0.0f);
                WaveView.this.postInvalidate();
            }
        });
        this.mWaveReverseAnimator.setInterpolator((TimeInterpolator)new BounceInterpolator());
        this.mWaveReverseAnimator.start();
    }

    public void animationDropCircle() {
        if (this.mDisappearCircleAnimator.isRunning()) {
            return;
        }
        this.startDropAnimation();
        this.startWaveAnimation(0.1f);
    }

    public float getCurrentCircleCenterY() {
        return this.mCurrentCircleCenterY;
    }

    public void setMaxDropHeight(int maxDropHeight) {
        if (this.mDropHeightUpdated) {
            this.updateMaxDropHeight(maxDropHeight);
        } else {
            this.mUpdateMaxDropHeight = maxDropHeight;
            this.mDropHeightUpdated = true;
            if (this.getViewTreeObserver().isAlive()) {
                this.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                this.getViewTreeObserver().addOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
            }
        }
    }

    public boolean isDisappearCircleAnimatorRunning() {
        return this.mDisappearCircleAnimator.isRunning();
    }

    public void setShadowRadius(int radius) {
        this.mPaint.setShadowLayer((float)radius, 0.0f, 0.0f, -1728053248);
    }

    public void setShadow(int radius, int color) {
        this.mPaint.setShadowLayer((float)radius, 0.0f, 0.0f, color);
    }

    public void setWaveColor(@ColorInt int color) {
        this.mPaint.setColor(color);
        this.invalidate();
    }

    public void setWaveARGBColor(int a, int r, int g, int b) {
        this.mPaint.setARGB(a, r, g, b);
        this.invalidate();
    }
}

