/*
 * Decompiled with CFR 0.152.
 */
package com.scwang.smartrefresh.header.util;

import android.graphics.Color;
import android.support.annotation.ColorInt;
import android.support.annotation.IntRange;

public final class ColorUtils {
    private ColorUtils() {
    }

    public static int compositeColors(@ColorInt int foreground, @ColorInt int background) {
        int bgAlpha = Color.alpha((int)background);
        int fgAlpha = Color.alpha((int)foreground);
        int a = ColorUtils.compositeAlpha(fgAlpha, bgAlpha);
        int r = ColorUtils.compositeComponent(Color.red((int)foreground), fgAlpha, Color.red((int)background), bgAlpha, a);
        int g = ColorUtils.compositeComponent(Color.green((int)foreground), fgAlpha, Color.green((int)background), bgAlpha, a);
        int b = ColorUtils.compositeComponent(Color.blue((int)foreground), fgAlpha, Color.blue((int)background), bgAlpha, a);
        return Color.argb((int)a, (int)r, (int)g, (int)b);
    }

    private static int compositeAlpha(int foregroundAlpha, int backgroundAlpha) {
        return 255 - (255 - backgroundAlpha) * (255 - foregroundAlpha) / 255;
    }

    private static int compositeComponent(int fgC, int fgA, int bgC, int bgA, int a) {
        if (a == 0) {
            return 0;
        }
        return (255 * fgC * fgA + bgC * bgA * (255 - fgA)) / (a * 255);
    }

    @ColorInt
    public static int setAlphaComponent(@ColorInt int color, @IntRange(from=0L, to=255L) int alpha) {
        if (alpha < 0 || alpha > 255) {
            throw new IllegalArgumentException("alpha must be between 0 and 255.");
        }
        return color & 0xFFFFFF | alpha << 24;
    }
}

