/*
 * Decompiled with CFR 0.152.
 */
package com.scwang.smartrefresh.header;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import com.scwang.smartrefresh.header.internal.MaterialProgressDrawable;
import com.scwang.smartrefresh.header.waterdrop.WaterDropView;
import com.scwang.smartrefresh.layout.api.RefreshHeader;
import com.scwang.smartrefresh.layout.api.RefreshKernel;
import com.scwang.smartrefresh.layout.api.RefreshLayout;
import com.scwang.smartrefresh.layout.constant.RefreshState;
import com.scwang.smartrefresh.layout.constant.SpinnerStyle;
import com.scwang.smartrefresh.layout.internal.ProgressDrawable;
import com.scwang.smartrefresh.layout.util.DensityUtil;

public class WaterDropHeader
extends ViewGroup
implements RefreshHeader {
    private static final float MAX_PROGRESS_ANGLE = 0.8f;
    private RefreshState mState;
    private ImageView mImageView;
    private WaterDropView mWaterDropView;
    private ProgressDrawable mProgressDrawable;
    private MaterialProgressDrawable mProgress;
    private int mProgressDegree = 0;

    public WaterDropHeader(Context context) {
        super(context);
        this.initView(context);
    }

    public WaterDropHeader(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView(context);
    }

    public WaterDropHeader(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView(context);
    }

    @RequiresApi(value=21)
    public WaterDropHeader(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.initView(context);
    }

    private void initView(Context context) {
        DensityUtil density = new DensityUtil();
        this.mWaterDropView = new WaterDropView(context);
        this.addView(this.mWaterDropView, -1, -1);
        this.mWaterDropView.updateCompleteState(0);
        this.mProgressDrawable = new ProgressDrawable();
        this.mProgressDrawable.setBounds(0, 0, density.dip2px(20.0f), density.dip2px(20.0f));
        this.mProgressDrawable.setCallback((Drawable.Callback)this);
        this.mImageView = new ImageView(context);
        this.mProgress = new MaterialProgressDrawable(context, (View)this.mImageView);
        this.mProgress.setBackgroundColor(-1);
        this.mProgress.setAlpha(255);
        this.mProgress.setColorSchemeColors(-1, -16737844, -48060, -10053376, -5609780, -30720);
        this.mImageView.setImageDrawable((Drawable)this.mProgress);
        this.addView((View)this.mImageView, density.dip2px(30.0f), density.dip2px(30.0f));
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        ViewGroup.LayoutParams lpImage = this.mImageView.getLayoutParams();
        this.mImageView.measure(View.MeasureSpec.makeMeasureSpec((int)lpImage.width, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)lpImage.height, (int)0x40000000));
        this.mWaterDropView.measure(View.MeasureSpec.makeMeasureSpec((int)View.MeasureSpec.getSize((int)widthMeasureSpec), (int)Integer.MIN_VALUE), heightMeasureSpec);
        int maxWidth = Math.max(this.mImageView.getMeasuredWidth(), this.mWaterDropView.getMeasuredHeight());
        int maxHeight = Math.max(this.mImageView.getMeasuredHeight(), this.mWaterDropView.getMeasuredHeight());
        this.setMeasuredDimension(WaterDropHeader.resolveSize((int)maxWidth, (int)widthMeasureSpec), WaterDropHeader.resolveSize((int)maxHeight, (int)heightMeasureSpec));
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int measuredWidth = this.getMeasuredWidth();
        int widthWaterDrop = this.mWaterDropView.getMeasuredWidth();
        int heightWaterDrop = this.mWaterDropView.getMeasuredHeight();
        int leftWaterDrop = measuredWidth / 2 - widthWaterDrop / 2;
        boolean topWaterDrop = false;
        this.mWaterDropView.layout(leftWaterDrop, 0, leftWaterDrop + widthWaterDrop, 0 + heightWaterDrop);
        int widthImage = this.mImageView.getMeasuredWidth();
        int heightImage = this.mImageView.getMeasuredHeight();
        int leftImage = measuredWidth / 2 - widthImage / 2;
        int topImage = widthWaterDrop / 2 - widthImage / 2;
        if (topImage + heightImage > this.mWaterDropView.getBottom() - (widthWaterDrop - widthImage) / 2) {
            topImage = this.mWaterDropView.getBottom() - (widthWaterDrop - widthImage) / 2 - heightImage;
        }
        this.mImageView.layout(leftImage, topImage, leftImage + widthImage, topImage + heightImage);
    }

    protected void dispatchDraw(Canvas canvas) {
        super.dispatchDraw(canvas);
        if (this.mState == RefreshState.Refreshing) {
            canvas.save();
            canvas.translate((float)(this.getWidth() / 2 - this.mProgressDrawable.width() / 2), (float)(this.mWaterDropView.getMaxCircleRadius() + this.mWaterDropView.getPaddingTop() - this.mProgressDrawable.height() / 2));
            this.mProgressDrawable.draw(canvas);
            canvas.restore();
        }
    }

    public void invalidateDrawable(@NonNull Drawable drawable) {
        if (drawable == this.mProgressDrawable) {
            this.invalidate();
        } else {
            super.invalidateDrawable(drawable);
        }
    }

    public void onInitialized(@NonNull RefreshKernel kernel, int height, int extendHeight) {
    }

    public boolean isSupportHorizontalDrag() {
        return false;
    }

    public void onHorizontalDrag(float percentX, int offsetX, int offsetMax) {
    }

    public void onPulling(float percent, int offset, int height, int extendHeight) {
        this.mWaterDropView.updateCompleteState(offset, height + extendHeight);
        this.mWaterDropView.postInvalidate();
        float originalDragPercent = 1.0f * (float)offset / (float)height;
        float dragPercent = Math.min(1.0f, Math.abs(originalDragPercent));
        float adjustedPercent = (float)Math.max((double)dragPercent - 0.4, 0.0) * 5.0f / 3.0f;
        float extraOS = Math.abs(offset) - height;
        float tensionSlingshotPercent = Math.max(0.0f, Math.min(extraOS, (float)height * 2.0f) / (float)height);
        float tensionPercent = (float)((double)(tensionSlingshotPercent / 4.0f) - Math.pow(tensionSlingshotPercent / 4.0f, 2.0)) * 2.0f;
        float strokeStart = adjustedPercent * 0.8f;
        float rotation = (-0.25f + 0.4f * adjustedPercent + tensionPercent * 2.0f) * 0.5f;
        this.mProgress.showArrow(true);
        this.mProgress.setStartEndTrim(0.0f, Math.min(0.8f, strokeStart));
        this.mProgress.setArrowScale(Math.min(1.0f, adjustedPercent));
        this.mProgress.setProgressRotation(rotation);
    }

    public void onReleasing(float percent, int offset, int height, int extendHeight) {
        if (this.mState != RefreshState.Refreshing && this.mState != RefreshState.RefreshReleased) {
            this.mWaterDropView.updateCompleteState(Math.max(offset, 0), height + extendHeight);
            this.mWaterDropView.postInvalidate();
        }
    }

    public void onReleased(RefreshLayout layout, int height, int extendHeight) {
        this.mProgressDrawable.start();
        this.mWaterDropView.createAnimator().start();
        this.mWaterDropView.animate().alpha(0.0f).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                WaterDropHeader.this.mWaterDropView.setVisibility(8);
                WaterDropHeader.this.mWaterDropView.setAlpha(1.0f);
            }
        });
    }

    public void onStartAnimator(@NonNull RefreshLayout layout, int height, int extendHeight) {
    }

    public int onFinish(@NonNull RefreshLayout layout, boolean success) {
        this.mProgressDrawable.stop();
        return 0;
    }

    @Deprecated
    public void setPrimaryColors(int ... colors) {
        if (colors.length > 0) {
            this.mWaterDropView.setIndicatorColor(colors[0]);
        }
    }

    @NonNull
    public View getView() {
        return this;
    }

    @NonNull
    public SpinnerStyle getSpinnerStyle() {
        return SpinnerStyle.Scale;
    }

    public void onStateChanged(RefreshLayout refreshLayout, RefreshState oldState, RefreshState newState) {
        this.mState = newState;
        switch (newState) {
            case None: {
                this.mWaterDropView.setVisibility(0);
                break;
            }
            case PullDownToRefresh: {
                this.mWaterDropView.setVisibility(0);
                break;
            }
            case PullDownCanceled: {
                break;
            }
            case ReleaseToRefresh: {
                this.mWaterDropView.setVisibility(0);
                break;
            }
            case Refreshing: {
                break;
            }
            case RefreshFinish: {
                this.mWaterDropView.setVisibility(8);
            }
        }
    }
}

