/*
 * Decompiled with CFR 0.152.
 */
package com.scwang.smartrefresh.header;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.Animation;
import android.view.animation.Interpolator;
import android.view.animation.Transformation;
import com.scwang.smartrefresh.header.R;
import com.scwang.smartrefresh.layout.api.RefreshHeader;
import com.scwang.smartrefresh.layout.api.RefreshKernel;
import com.scwang.smartrefresh.layout.api.RefreshLayout;
import com.scwang.smartrefresh.layout.constant.RefreshState;
import com.scwang.smartrefresh.layout.constant.SpinnerStyle;
import com.scwang.smartrefresh.layout.internal.pathview.PathsDrawable;
import com.scwang.smartrefresh.layout.util.DensityUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;

public class TaurusHeader
extends View
implements RefreshHeader {
    private static final float SCALE_START_PERCENT = 0.5f;
    private static final int ANIMATION_DURATION = 1000;
    private static final float SIDE_CLOUDS_INITIAL_SCALE = 0.6f;
    private static final float SIDE_CLOUDS_FINAL_SCALE = 1.0f;
    private static final float CENTER_CLOUDS_INITIAL_SCALE = 0.8f;
    private static final float CENTER_CLOUDS_FINAL_SCALE = 1.0f;
    private static final Interpolator ACCELERATE_DECELERATE_INTERPOLATOR = new AccelerateDecelerateInterpolator();
    private static final int LOADING_ANIMATION_COEFFICIENT = 80;
    private static final int SLOW_DOWN_ANIMATION_COEFFICIENT = 6;
    private static final int WIND_SET_AMOUNT = 10;
    private static final int Y_SIDE_CLOUDS_SLOW_DOWN_COF = 4;
    private static final int X_SIDE_CLOUDS_SLOW_DOWN_COF = 2;
    private static final int MIN_WIND_LINE_WIDTH = 50;
    private static final int MAX_WIND_LINE_WIDTH = 300;
    private static final int MIN_WIND_X_OFFSET = 1000;
    private static final int MAX_WIND_X_OFFSET = 2000;
    private static final int RANDOM_Y_COEFFICIENT = 5;
    private PathsDrawable mAirplane;
    private PathsDrawable mCloudCenter;
    private Matrix mMatrix;
    private float mPercent;
    private int mHeaderHeight;
    private Animation mAnimation;
    private boolean isRefreshing = false;
    private float mLoadingAnimationTime;
    private float mLastAnimationTime;
    private Random mRandom;
    private Map<Float, Float> mWinds;
    private Paint mWindPaint;
    private float mWindLineWidth;
    private boolean mNewWindSet;
    private boolean mInverseDirection;
    private float mFinishTransformation;

    public TaurusHeader(Context context) {
        super(context);
        this.initView(context, null);
    }

    public TaurusHeader(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView(context, attrs);
    }

    public TaurusHeader(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView(context, attrs);
    }

    @RequiresApi(value=21)
    public TaurusHeader(Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.initView(context, attrs);
    }

    private void initView(Context context, AttributeSet attrs) {
        this.setMinimumHeight(DensityUtil.dp2px((float)100.0f));
        this.mMatrix = new Matrix();
        this.mWinds = new HashMap<Float, Float>();
        this.mRandom = new Random();
        this.mWindPaint = new Paint();
        this.mWindPaint.setColor(-1);
        this.mWindPaint.setStrokeWidth((float)DensityUtil.dp2px((float)3.0f));
        this.mWindPaint.setAlpha(50);
        this.setupAnimations();
        this.setupPathDrawable();
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.TaurusHeader);
        int primaryColor = ta.getColor(R.styleable.TaurusHeader_thPrimaryColor, 0);
        if (primaryColor != 0) {
            this.setBackgroundColor(primaryColor);
        } else {
            this.setBackgroundColor(-15614977);
        }
        ta.recycle();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.setMeasuredDimension(TaurusHeader.resolveSize((int)this.getSuggestedMinimumWidth(), (int)widthMeasureSpec), TaurusHeader.resolveSize((int)this.getSuggestedMinimumHeight(), (int)heightMeasureSpec));
    }

    public void onInitialized(@NonNull RefreshKernel kernel, int height, int extendHeight) {
    }

    public boolean isSupportHorizontalDrag() {
        return false;
    }

    public void onHorizontalDrag(float percentX, int offsetX, int offsetMax) {
    }

    public void onPulling(float percent, int offset, int height, int extendHeight) {
        this.mPercent = percent;
        this.mHeaderHeight = height;
        this.mFinishTransformation = 0.0f;
    }

    public void onReleasing(float percent, int offset, int height, int extendHeight) {
        this.mPercent = percent;
        this.mHeaderHeight = height;
    }

    public void onStartAnimator(@NonNull RefreshLayout layout, int height, int extendHeight) {
        this.isRefreshing = true;
        this.mFinishTransformation = 0.0f;
        this.startAnimation(this.mAnimation);
    }

    public void onReleased(RefreshLayout layout, int height, int extendHeight) {
    }

    public void onStateChanged(RefreshLayout refreshLayout, RefreshState oldState, RefreshState newState) {
    }

    public int onFinish(@NonNull RefreshLayout layout, boolean success) {
        this.clearAnimation();
        if (success) {
            this.startAnimation(new Animation(){
                {
                    this.setDuration(100L);
                    this.setInterpolator((Interpolator)new AccelerateInterpolator());
                }

                protected void applyTransformation(float interpolatedTime, Transformation t) {
                    if (interpolatedTime == 1.0f) {
                        TaurusHeader.this.isRefreshing = false;
                    }
                    TaurusHeader.this.mFinishTransformation = interpolatedTime;
                    TaurusHeader.this.invalidate();
                }
            });
            return 200;
        }
        this.isRefreshing = false;
        return 0;
    }

    @Deprecated
    public void setPrimaryColors(int ... colors) {
        this.setBackgroundColor(colors[0]);
    }

    @NonNull
    public View getView() {
        return this;
    }

    @NonNull
    public SpinnerStyle getSpinnerStyle() {
        return SpinnerStyle.Scale;
    }

    public void onDraw(Canvas canvas) {
        int width = this.getWidth();
        int height = this.getHeight();
        if (this.isRefreshing) {
            while (this.mWinds.size() < 10) {
                float y = (float)((double)this.mHeaderHeight / (Math.random() * 5.0));
                float x = this.random(1000, 2000);
                if (this.mWinds.size() > 1) {
                    y = 0.0f;
                    block1: while (y == 0.0f) {
                        float tmp = (float)((double)this.mHeaderHeight / (Math.random() * 5.0));
                        for (Map.Entry<Float, Float> wind : this.mWinds.entrySet()) {
                            if (Math.abs(wind.getKey().floatValue() - tmp) > (float)(this.mHeaderHeight / 5)) {
                                y = tmp;
                                continue;
                            }
                            y = 0.0f;
                            continue block1;
                        }
                    }
                }
                this.mWinds.put(Float.valueOf(y), Float.valueOf(x));
                this.drawWind(canvas, y, x, width);
            }
            if (this.mWinds.size() >= 10) {
                for (Map.Entry<Float, Float> wind : this.mWinds.entrySet()) {
                    this.drawWind(canvas, wind.getKey().floatValue(), wind.getValue().floatValue(), width);
                }
            }
            if (this.mInverseDirection && this.mNewWindSet) {
                this.mWinds.clear();
                this.mNewWindSet = false;
                this.mWindLineWidth = this.random(50, 300);
            }
            this.mLastAnimationTime = this.mLoadingAnimationTime;
        }
        this.drawAirplane(canvas, width, height);
        this.drawSideClouds(canvas, width, height);
        this.drawCenterClouds(canvas, width, height);
    }

    private void drawWind(Canvas canvas, float y, float xOffset, int width) {
        float cof = ((float)width + xOffset) / 13.0f;
        float time = this.mLoadingAnimationTime;
        if (this.mLastAnimationTime - this.mLoadingAnimationTime > 0.0f) {
            this.mInverseDirection = true;
            time = 13.0f - this.mLoadingAnimationTime;
        } else {
            this.mNewWindSet = true;
            this.mInverseDirection = false;
        }
        float x = (float)width - time * cof + xOffset - this.mWindLineWidth;
        float xEnd = x + this.mWindLineWidth;
        canvas.drawLine(x, y, xEnd, y, this.mWindPaint);
    }

    private void drawSideClouds(Canvas canvas, int width, int height) {
        float scale;
        float scalePercentDelta;
        Matrix matrix = this.mMatrix;
        matrix.reset();
        PathsDrawable mCloudLeft = this.mCloudCenter;
        PathsDrawable mCloudRight = this.mCloudCenter;
        float dragPercent = Math.min(1.0f, Math.abs(this.mPercent));
        if (this.isInEditMode()) {
            dragPercent = 1.0f;
            this.mHeaderHeight = height;
        }
        if ((scalePercentDelta = dragPercent - 0.5f) > 0.0f) {
            float scalePercent = scalePercentDelta / 0.5f;
            scale = 0.6f + 0.39999998f * scalePercent;
        } else {
            scale = 0.6f;
        }
        float dragYOffset = (float)this.mHeaderHeight * (1.0f - dragPercent);
        float offsetLeftX = 0 - mCloudLeft.width() / 2;
        float offsetLeftY = dragYOffset;
        float offsetRightX = width - mCloudRight.width() / 2;
        float offsetRightY = dragYOffset;
        if (this.isRefreshing) {
            if (this.checkCurrentAnimationPart(AnimationPart.FIRST)) {
                offsetLeftX -= 2.0f * this.getAnimationPartValue(AnimationPart.FIRST) / 4.0f;
                offsetRightX += this.getAnimationPartValue(AnimationPart.FIRST) / 2.0f;
            } else if (this.checkCurrentAnimationPart(AnimationPart.SECOND)) {
                offsetLeftX -= 2.0f * this.getAnimationPartValue(AnimationPart.SECOND) / 4.0f;
                offsetRightX += this.getAnimationPartValue(AnimationPart.SECOND) / 2.0f;
            } else if (this.checkCurrentAnimationPart(AnimationPart.THIRD)) {
                offsetLeftX -= this.getAnimationPartValue(AnimationPart.THIRD) / 4.0f;
                offsetRightX += 2.0f * this.getAnimationPartValue(AnimationPart.THIRD) / 2.0f;
            } else if (this.checkCurrentAnimationPart(AnimationPart.FOURTH)) {
                offsetLeftX -= this.getAnimationPartValue(AnimationPart.FOURTH) / 2.0f;
                offsetRightX += 2.0f * this.getAnimationPartValue(AnimationPart.FOURTH) / 4.0f;
            }
        }
        if (offsetLeftY + scale * (float)mCloudLeft.height() < (float)(height + 2)) {
            offsetLeftY = (float)(height + 2) - scale * (float)mCloudLeft.height();
        }
        if (offsetRightY + scale * (float)mCloudRight.height() < (float)(height + 2)) {
            offsetRightY = (float)(height + 2) - scale * (float)mCloudRight.height();
        }
        int saveCount = canvas.getSaveCount();
        canvas.save();
        canvas.translate(offsetLeftX, offsetLeftY);
        matrix.postScale(scale, scale, (float)(mCloudLeft.width() * 3 / 4), (float)mCloudLeft.height());
        canvas.concat(matrix);
        mCloudLeft.setAlpha(100);
        mCloudLeft.draw(canvas);
        mCloudLeft.setAlpha(255);
        canvas.restoreToCount(saveCount);
        canvas.save();
        canvas.translate(offsetRightX, offsetRightY);
        matrix.postScale(scale, scale, 0.0f, (float)mCloudRight.height());
        canvas.concat(matrix);
        mCloudRight.setAlpha(100);
        mCloudRight.draw(canvas);
        mCloudRight.setAlpha(255);
        canvas.restoreToCount(saveCount);
    }

    private void drawCenterClouds(Canvas canvas, int width, int height) {
        float sy;
        float scale;
        float scalePercentDelta;
        Matrix matrix = this.mMatrix;
        matrix.reset();
        float dragPercent = Math.min(1.0f, Math.abs(this.mPercent));
        if (this.isInEditMode()) {
            dragPercent = 1.0f;
            this.mHeaderHeight = height;
        }
        float overDragPercent = 0.0f;
        boolean overDrag = false;
        if (this.mPercent > 1.0f) {
            overDrag = true;
            overDragPercent = Math.abs(1.0f - this.mPercent);
        }
        if ((scalePercentDelta = dragPercent - 0.5f) > 0.0f) {
            float scalePercent = scalePercentDelta / 0.5f;
            scale = 0.8f + 0.19999999f * scalePercent;
        } else {
            scale = 0.8f;
        }
        float parallaxPercent = 0.0f;
        boolean parallax = false;
        float dragYOffset = (float)this.mHeaderHeight * dragPercent;
        int startParallaxHeight = this.mHeaderHeight - this.mCloudCenter.height() / 2;
        if (dragYOffset > (float)startParallaxHeight) {
            parallax = true;
            parallaxPercent = dragYOffset - (float)startParallaxHeight;
        }
        float offsetX = width / 2 - this.mCloudCenter.width() / 2;
        float offsetY = dragYOffset - (parallax ? (float)(this.mCloudCenter.height() / 2) + parallaxPercent : (float)(this.mCloudCenter.height() / 2));
        float sx = overDrag ? scale + overDragPercent / 4.0f : scale;
        float f = sy = overDrag ? scale + overDragPercent / 2.0f : scale;
        if (this.isRefreshing && !overDrag) {
            if (this.checkCurrentAnimationPart(AnimationPart.FIRST)) {
                sx = scale - this.getAnimationPartValue(AnimationPart.FIRST) / 80.0f / 8.0f;
            } else if (this.checkCurrentAnimationPart(AnimationPart.SECOND)) {
                sx = scale - this.getAnimationPartValue(AnimationPart.SECOND) / 80.0f / 8.0f;
            } else if (this.checkCurrentAnimationPart(AnimationPart.THIRD)) {
                sx = scale + this.getAnimationPartValue(AnimationPart.THIRD) / 80.0f / 6.0f;
            } else if (this.checkCurrentAnimationPart(AnimationPart.FOURTH)) {
                sx = scale + this.getAnimationPartValue(AnimationPart.FOURTH) / 80.0f / 6.0f;
            }
            sy = sx;
        }
        matrix.postScale(sx, sy, (float)(this.mCloudCenter.width() / 2), 0.0f);
        if (offsetY + sy * (float)this.mCloudCenter.height() < (float)(height + 2)) {
            offsetY = (float)(height + 2) - sy * (float)this.mCloudCenter.height();
        }
        int saveCount = canvas.getSaveCount();
        canvas.save();
        canvas.translate(offsetX, offsetY);
        canvas.concat(matrix);
        this.mCloudCenter.draw(canvas);
        canvas.restoreToCount(saveCount);
    }

    private void drawAirplane(Canvas canvas, int width, int height) {
        Matrix matrix = this.mMatrix;
        matrix.reset();
        float dragPercent = this.mPercent;
        float rotateAngle = 0.0f;
        if (this.isInEditMode()) {
            dragPercent = 1.0f;
            this.mHeaderHeight = height;
        }
        if (dragPercent > 1.0f) {
            rotateAngle = 20.0f * (float)(1.0 - Math.pow(100.0, -(dragPercent - 1.0f) / 2.0f));
            dragPercent = 1.0f;
        }
        float offsetX = (float)width * dragPercent / 2.0f - (float)(this.mAirplane.width() / 2);
        float offsetY = (float)this.mHeaderHeight * (1.0f - dragPercent / 2.0f) - (float)(this.mAirplane.height() / 2);
        if (this.mFinishTransformation > 0.0f) {
            offsetY += (0.0f - offsetY) * this.mFinishTransformation;
            offsetX += ((float)(width + this.mAirplane.width()) - offsetX) * this.mFinishTransformation;
        }
        if (this.isRefreshing) {
            if (this.checkCurrentAnimationPart(AnimationPart.FIRST)) {
                offsetY -= this.getAnimationPartValue(AnimationPart.FIRST);
            } else if (this.checkCurrentAnimationPart(AnimationPart.SECOND)) {
                offsetY -= this.getAnimationPartValue(AnimationPart.SECOND);
            } else if (this.checkCurrentAnimationPart(AnimationPart.THIRD)) {
                offsetY += this.getAnimationPartValue(AnimationPart.THIRD);
            } else if (this.checkCurrentAnimationPart(AnimationPart.FOURTH)) {
                offsetY += this.getAnimationPartValue(AnimationPart.FOURTH);
            }
        }
        if (rotateAngle > 0.0f) {
            matrix.postRotate(rotateAngle, (float)(this.mAirplane.width() / 2), (float)(this.mAirplane.height() / 2));
        }
        int saveCount = canvas.getSaveCount();
        canvas.save();
        canvas.translate(offsetX, offsetY);
        canvas.concat(matrix);
        this.mAirplane.draw(canvas);
        canvas.restoreToCount(saveCount);
    }

    private void setupPathDrawable() {
        DensityUtil density = new DensityUtil();
        this.mAirplane = new PathsDrawable();
        this.mAirplane.parserPaths(new String[]{"m23.01,81.48c-0.21,-0.3 -0.38,-0.83 -0.38,-1.19 0,-0.55 0.24,-0.78 1.5,-1.48 1.78,-0.97 2.62,-1.94 2.24,-2.57 -0.57,-0.93 -1.97,-1.24 -11.64,-2.59 -5.35,-0.74 -10.21,-1.44 -10.82,-1.54l-1.09,-0.18 1.19,-0.91c0.99,-0.76 1.38,-0.91 2.35,-0.91 0.64,0 6.39,0.33 12.79,0.74 6.39,0.41 12.09,0.71 12.65,0.67l1.03,-0.07 -1.24,-2.19C30.18,66.77 15.91,42 15.13,40.68l-0.51,-0.87 4.19,-1.26c2.3,-0.69 4.27,-1.26 4.37,-1.26 0.1,0 5.95,3.85 13,8.55 14.69,9.81 17.1,11.31 19.7,12.31 4.63,1.78 6.45,1.69 12.94,-0.64 13.18,-4.73 25.22,-9.13 25.75,-9.4 0.69,-0.36 3.6,1.33 -24.38,-14.22L50.73,23.07 46.74,16.42 42.75,9.77 43.63,8.89c0.83,-0.83 0.91,-0.86 1.46,-0.52 0.32,0.2 3.72,3.09 7.55,6.44 3.83,3.34 7.21,6.16 7.5,6.27 0.29,0.11 13.6,2.82 29.58,6.03 15.98,3.21 31.86,6.4 35.3,7.1l6.26,1.26 3.22,-1.13c41.63,-14.63 67.88,-23.23 85.38,-28 14.83,-4.04 23.75,-4.75 32.07,-2.57 7.04,1.84 9.87,4.88 7.71,8.27 -1.6,2.5 -4.6,4.63 -10.61,7.54 -5.94,2.88 -10.22,4.46 -25.4,9.41 -8.15,2.66 -16.66,5.72 -39.01,14.02 -66.79,24.82 -88.49,31.25 -121.66,36.07 -14.56,2.11 -24.17,2.95 -34.08,2.95 -5.43,0 -5.52,-0.01 -5.89,-0.54z"});
        this.mAirplane.setBounds(0, 0, density.dip2px(65.0f), density.dip2px(20.0f));
        this.mAirplane.parserColors(new int[]{-1});
        this.mCloudCenter = new PathsDrawable();
        this.mCloudCenter.parserPaths(new String[]{"M551.81,1.01A65.42,65.42 0,0 0,504.38 21.5A50.65,50.65 0,0 0,492.4 20A50.65,50.65 0,0 0,441.75 70.65A50.65,50.65 0,0 0,492.4 121.3A50.65,50.65 0,0 0,511.22 117.64A65.42,65.42 0,0 0,517.45 122L586.25,122A65.42,65.42 0,0 0,599.79 110.78A59.79,59.79 0,0 0,607.81 122L696.34,122A59.79,59.79 0,0 0,711.87 81.9A59.79,59.79 0,0 0,652.07 22.11A59.79,59.79 0,0 0,610.93 38.57A65.42,65.42 0,0 0,551.81 1.01zM246.2,1.71A54.87,54.87 0,0 0,195.14 36.64A46.78,46.78 0,0 0,167.77 27.74A46.78,46.78 0,0 0,120.99 74.52A46.78,46.78 0,0 0,167.77 121.3A46.78,46.78 0,0 0,208.92 96.74A54.87,54.87 0,0 0,246.2 111.45A54.87,54.87 0,0 0,268.71 106.54A39.04,39.04 0,0 0,281.09 122L327.6,122A39.04,39.04 0,0 0,343.38 90.7A39.04,39.04 0,0 0,304.34 51.66A39.04,39.04 0,0 0,300.82 51.85A54.87,54.87 0,0 0,246.2 1.71z", "m506.71,31.37a53.11,53.11 0,0 0,-53.11 53.11,53.11 53.11,0 0,0 15.55,37.5h75.12a53.11,53.11 0,0 0,1.88 -2.01,28.49 28.49,0 0,0 0.81,2.01h212.96a96.72,96.72 0,0 0,-87.09 -54.85,96.72 96.72,0 0,0 -73.14,33.52 28.49,28.49 0,0 0,-26.74 -18.74,28.49 28.49,0 0,0 -13.16,3.23 53.11,53.11 0,0 0,0.03 -0.66,53.11 53.11,0 0,0 -53.11,-53.11zM206.23,31.81a53.81,53.81 0,0 0,-49.99 34.03,74.91 74.91,0 0,0 -47.45,-17 74.91,74.91 0,0 0,-73.54 60.82,31.3 31.3,0 0,0 -10.17,-1.73 31.3,31.3 0,0 0,-26.09 14.05L300.86,121.98a37.63,37.63 0,0 0,0.2 -3.85,37.63 37.63,0 0,0 -37.63,-37.63 37.63,37.63 0,0 0,-3.65 0.21,53.81 53.81,0 0,0 -53.54,-48.9z", "m424.05,36.88a53.46,53.46 0,0 0,-40.89 19.02,53.46 53.46,0 0,0 -1.34,1.76 62.6,62.6 0,0 0,-5.39 -0.27,62.6 62.6,0 0,0 -61.36,50.17 62.6,62.6 0,0 0,-0.53 3.51,15.83 15.83,0 0,0 -10.33,-3.84 15.83,15.83 0,0 0,-8.06 2.23,21.1 21.1,0 0,0 -18.31,-10.67 21.1,21.1 0,0 0,-19.47 12.97,21.81 21.81,0 0,0 -6.56,-1.01 21.81,21.81 0,0 0,-19.09 11.32L522.84,122.07a43.61,43.61 0,0 0,-43.11 -37.35,43.61 43.61,0 0,0 -2.57,0.09 53.46,53.46 0,0 0,-53.11 -47.93zM129.08,38.4a50.29,50.29 0,0 0,-50.29 50.29,50.29 50.29,0 0,0 2.37,15.06 15.48,15.83 0,0 0,-5.87 1.68,15.48 15.83,0 0,0 -0.98,0.58 16.53,16.18 0,0 0,-0.19 -0.21,16.53 16.18,0 0,0 -11.86,-4.91 16.53,16.18 0,0 0,-16.38 14.13,20.05 16.18,0 0,0 -14.97,7.04L223.95,122.07a42.56,42.56 0,0 0,1.14 -9.56,42.56 42.56,0 0,0 -42.56,-42.56 42.56,42.56 0,0 0,-6.58 0.54,50.29 50.29,0 0,0 -0,-0.01 50.29,50.29 0,0 0,-46.88 -32.07zM631.67,82.61a64.01,64.01 0,0 0,-44.9 18.42,26.73 26.73,0 0,0 -10.67,-2.24 26.73,26.73 0,0 0,-22.72 12.71,16.88 16.88,0 0,0 -0.25,-0.12 16.88,16.88 0,0 0,-6.57 -1.33,16.88 16.88,0 0,0 -16.15,12.03h160.36a64.01,64.01 0,0 0,-59.1 -39.46z"});
        this.mCloudCenter.parserColors(new int[]{-1429742351, -571935747, -131587});
        this.mCloudCenter.setBounds(0, 0, density.dip2px(260.0f), density.dip2px(45.0f));
    }

    private float random(int min, int max) {
        return this.mRandom.nextInt(max - min + 1) + min;
    }

    private float getAnimationPartValue(AnimationPart part) {
        switch (part) {
            case FIRST: {
                return this.mLoadingAnimationTime;
            }
            case SECOND: {
                return (float)this.getAnimationTimePart(AnimationPart.FOURTH) - (this.mLoadingAnimationTime - (float)this.getAnimationTimePart(AnimationPart.FOURTH));
            }
            case THIRD: {
                return this.mLoadingAnimationTime - (float)this.getAnimationTimePart(AnimationPart.SECOND);
            }
            case FOURTH: {
                return (float)this.getAnimationTimePart(AnimationPart.THIRD) - (this.mLoadingAnimationTime - (float)this.getAnimationTimePart(AnimationPart.FOURTH));
            }
        }
        return 0.0f;
    }

    private boolean checkCurrentAnimationPart(AnimationPart part) {
        switch (part) {
            case FIRST: {
                return this.mLoadingAnimationTime < (float)this.getAnimationTimePart(AnimationPart.FOURTH);
            }
            case SECOND: 
            case THIRD: {
                return this.mLoadingAnimationTime < (float)this.getAnimationTimePart(part);
            }
            case FOURTH: {
                return this.mLoadingAnimationTime > (float)this.getAnimationTimePart(AnimationPart.THIRD);
            }
        }
        return false;
    }

    private int getAnimationTimePart(AnimationPart part) {
        switch (part) {
            case SECOND: {
                return 40;
            }
            case THIRD: {
                return this.getAnimationTimePart(AnimationPart.FOURTH) * 3;
            }
            case FOURTH: {
                return 20;
            }
        }
        return 0;
    }

    private void setupAnimations() {
        this.mAnimation = new Animation(){

            public void applyTransformation(float interpolatedTime, @NonNull Transformation t) {
                TaurusHeader.this.setLoadingAnimationTime(interpolatedTime);
            }
        };
        this.mAnimation.setRepeatCount(-1);
        this.mAnimation.setRepeatMode(2);
        this.mAnimation.setInterpolator(ACCELERATE_DECELERATE_INTERPOLATOR);
        this.mAnimation.setDuration(1000L);
    }

    private void setLoadingAnimationTime(float loadingAnimationTime) {
        this.mLoadingAnimationTime = 80.0f * (loadingAnimationTime / 6.0f);
        this.invalidate();
    }

    private static enum AnimationPart {
        FIRST,
        SECOND,
        THIRD,
        FOURTH;

    }
}

