/*
 * Decompiled with CFR 0.152.
 */
package com.scwang.smart.refresh.layout.util;

import android.content.res.Resources;
import android.graphics.PointF;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.v4.view.NestedScrollingChild;
import android.support.v4.view.NestedScrollingParent;
import android.support.v4.view.ScrollingView;
import android.support.v4.view.ViewPager;
import android.support.v4.widget.NestedScrollView;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Interpolator;
import android.webkit.WebView;
import android.widget.AbsListView;
import android.widget.ListView;
import android.widget.ScrollView;

public class SmartUtil
implements Interpolator {
    public static int INTERPOLATOR_VISCOUS_FLUID = 0;
    public static int INTERPOLATOR_DECELERATE = 1;
    private int type;
    private static float density = Resources.getSystem().getDisplayMetrics().density;
    private static final float VISCOUS_FLUID_SCALE = 8.0f;
    private static final float VISCOUS_FLUID_NORMALIZE = 1.0f / SmartUtil.viscousFluid(1.0f);
    private static final float VISCOUS_FLUID_OFFSET = 1.0f - VISCOUS_FLUID_NORMALIZE * SmartUtil.viscousFluid(1.0f);

    public SmartUtil(int type) {
        this.type = type;
    }

    public static int measureViewHeight(View view) {
        ViewGroup.LayoutParams p = view.getLayoutParams();
        if (p == null) {
            p = new ViewGroup.LayoutParams(-1, -2);
        }
        int childWidthSpec = ViewGroup.getChildMeasureSpec((int)0, (int)0, (int)p.width);
        int childHeightSpec = p.height > 0 ? View.MeasureSpec.makeMeasureSpec((int)p.height, (int)0x40000000) : View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        view.measure(childWidthSpec, childHeightSpec);
        return view.getMeasuredHeight();
    }

    public static void scrollListBy(@NonNull AbsListView listView, int y) {
        if (Build.VERSION.SDK_INT >= 19) {
            listView.scrollListBy(y);
        } else if (listView instanceof ListView) {
            int firstPosition = listView.getFirstVisiblePosition();
            if (firstPosition == -1) {
                return;
            }
            AbsListView listGroup = listView;
            View firstView = listGroup.getChildAt(0);
            if (firstView == null) {
                return;
            }
            int newTop = firstView.getTop() - y;
            ((ListView)listView).setSelectionFromTop(firstPosition, newTop);
        } else {
            listView.smoothScrollBy(y, 0);
        }
    }

    public static boolean isScrollableView(View view) {
        return view instanceof AbsListView || view instanceof ScrollView || view instanceof ScrollingView || view instanceof WebView || view instanceof NestedScrollingChild;
    }

    public static boolean isContentView(View view) {
        return SmartUtil.isScrollableView(view) || view instanceof ViewPager || view instanceof NestedScrollingParent;
    }

    public static void fling(View scrollableView, int velocity) {
        if (scrollableView instanceof ScrollView) {
            ((ScrollView)scrollableView).fling(velocity);
        } else if (scrollableView instanceof AbsListView) {
            if (Build.VERSION.SDK_INT >= 21) {
                ((AbsListView)scrollableView).fling(velocity);
            }
        } else if (scrollableView instanceof WebView) {
            ((WebView)scrollableView).flingScroll(0, velocity);
        } else if (scrollableView instanceof NestedScrollView) {
            ((NestedScrollView)scrollableView).fling(velocity);
        } else if (scrollableView instanceof RecyclerView) {
            ((RecyclerView)scrollableView).fling(0, velocity);
        }
    }

    public static boolean canRefresh(@NonNull View targetView, PointF touch) {
        if (SmartUtil.canScrollVertically(targetView, -1) && targetView.getVisibility() == 0) {
            return false;
        }
        if (targetView instanceof ViewGroup && touch != null) {
            ViewGroup viewGroup = (ViewGroup)targetView;
            int childCount = viewGroup.getChildCount();
            PointF point = new PointF();
            for (int i = childCount; i > 0; --i) {
                View child = viewGroup.getChildAt(i - 1);
                if (!SmartUtil.isTransformedTouchPointInView((View)viewGroup, child, touch.x, touch.y, point)) continue;
                if ("fixed".equals(child.getTag()) || "fixed-bottom".equals(child.getTag())) {
                    return false;
                }
                touch.offset(point.x, point.y);
                boolean can = SmartUtil.canRefresh(child, touch);
                touch.offset(-point.x, -point.y);
                return can;
            }
        }
        return true;
    }

    public static boolean canLoadMore(@NonNull View targetView, PointF touch, boolean contentFull) {
        if (SmartUtil.canScrollVertically(targetView, 1) && targetView.getVisibility() == 0) {
            return false;
        }
        if (targetView instanceof ViewGroup && touch != null && !SmartUtil.isScrollableView(targetView)) {
            ViewGroup viewGroup = (ViewGroup)targetView;
            int childCount = viewGroup.getChildCount();
            PointF point = new PointF();
            for (int i = childCount; i > 0; --i) {
                View child = viewGroup.getChildAt(i - 1);
                if (!SmartUtil.isTransformedTouchPointInView((View)viewGroup, child, touch.x, touch.y, point)) continue;
                if ("fixed".equals(child.getTag()) || "fixed-top".equals(child.getTag())) {
                    return false;
                }
                touch.offset(point.x, point.y);
                boolean can = SmartUtil.canLoadMore(child, touch, contentFull);
                touch.offset(-point.x, -point.y);
                return can;
            }
        }
        return contentFull || SmartUtil.canScrollVertically(targetView, -1);
    }

    public static boolean canScrollVertically(@NonNull View targetView, int direction) {
        if (Build.VERSION.SDK_INT < 14) {
            if (targetView instanceof AbsListView) {
                ViewGroup viewGroup = (ViewGroup)targetView;
                AbsListView absListView = (AbsListView)targetView;
                int childCount = viewGroup.getChildCount();
                if (direction > 0) {
                    return childCount > 0 && (absListView.getLastVisiblePosition() < childCount - 1 || viewGroup.getChildAt(childCount - 1).getBottom() > targetView.getPaddingBottom());
                }
                return childCount > 0 && (absListView.getFirstVisiblePosition() > 0 || viewGroup.getChildAt(0).getTop() < targetView.getPaddingTop());
            }
            if (direction > 0) {
                return targetView.getScrollY() < 0;
            }
            return targetView.getScrollY() > 0;
        }
        return targetView.canScrollVertically(direction);
    }

    public static boolean isTransformedTouchPointInView(@NonNull View group, @NonNull View child, float x, float y, PointF outLocalPoint) {
        boolean isInView;
        if (child.getVisibility() != 0) {
            return false;
        }
        float[] point = new float[]{x, y};
        point[0] = point[0] + (float)(group.getScrollX() - child.getLeft());
        point[1] = point[1] + (float)(group.getScrollY() - child.getTop());
        boolean bl = isInView = point[0] >= 0.0f && point[1] >= 0.0f && point[0] < (float)child.getWidth() && point[1] < (float)child.getHeight();
        if (isInView && outLocalPoint != null) {
            outLocalPoint.set(point[0] - x, point[1] - y);
        }
        return isInView;
    }

    public static int dp2px(float dpValue) {
        return (int)(0.5f + dpValue * density);
    }

    public static float px2dp(int pxValue) {
        return (float)pxValue / density;
    }

    private static float viscousFluid(float x) {
        if ((x *= 8.0f) < 1.0f) {
            x -= 1.0f - (float)Math.exp(-x);
        } else {
            float start = 0.36787945f;
            x = 1.0f - (float)Math.exp(1.0f - x);
            x = start + x * (1.0f - start);
        }
        return x;
    }

    public float getInterpolation(float input) {
        if (this.type == INTERPOLATOR_DECELERATE) {
            return 1.0f - (1.0f - input) * (1.0f - input);
        }
        float interpolated = VISCOUS_FLUID_NORMALIZE * SmartUtil.viscousFluid(input);
        if (interpolated > 0.0f) {
            return interpolated + VISCOUS_FLUID_OFFSET;
        }
        return interpolated;
    }
}

