/*
 * Decompiled with CFR 0.152.
 */
package com.scwang.smart.refresh.header;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.view.NestedScrollingParent2;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.scwang.smart.refresh.header.ClassicsHeader;
import com.scwang.smart.refresh.header.listener.OnTwoLevelListener;
import com.scwang.smart.refresh.header.two.level.R;
import com.scwang.smart.refresh.layout.api.RefreshComponent;
import com.scwang.smart.refresh.layout.api.RefreshHeader;
import com.scwang.smart.refresh.layout.api.RefreshKernel;
import com.scwang.smart.refresh.layout.api.RefreshLayout;
import com.scwang.smart.refresh.layout.constant.RefreshState;
import com.scwang.smart.refresh.layout.constant.SpinnerStyle;
import com.scwang.smart.refresh.layout.simple.SimpleComponent;

public class TwoLevelHeader
extends SimpleComponent
implements RefreshHeader,
NestedScrollingParent2 {
    protected int mSpinner;
    protected float mPercent = 0.0f;
    protected float mMaxRate = 2.5f;
    protected float mFloorRate = 1.9f;
    protected float mRefreshRate = 1.0f;
    protected float mBottomPullUpToCloseRate = 0.16666667f;
    protected boolean mEnableRefresh = true;
    protected boolean mEnableTwoLevel = true;
    protected boolean mEnablePullToCloseTwoLevel = true;
    protected int mFloorDuration = 1000;
    protected int mHeaderHeight;
    protected RefreshComponent mRefreshHeader;
    protected RefreshKernel mRefreshKernel;
    protected OnTwoLevelListener mTwoLevelListener;
    private int mNestedScrollAxes = 0;

    public TwoLevelHeader(Context context) {
        this(context, null);
    }

    public TwoLevelHeader(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs, 0);
        this.mSpinnerStyle = SpinnerStyle.FixedBehind;
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.TwoLevelHeader);
        this.mMaxRate = ta.getFloat(R.styleable.TwoLevelHeader_srlMaxRate, this.mMaxRate);
        this.mFloorRate = ta.getFloat(R.styleable.TwoLevelHeader_srlFloorRate, this.mFloorRate);
        this.mRefreshRate = ta.getFloat(R.styleable.TwoLevelHeader_srlRefreshRate, this.mRefreshRate);
        this.mFloorDuration = ta.getInt(R.styleable.TwoLevelHeader_srlFloorDuration, this.mFloorDuration);
        this.mEnableRefresh = ta.getBoolean(R.styleable.TwoLevelHeader_srlEnableRefresh, this.mEnableRefresh);
        this.mEnableTwoLevel = ta.getBoolean(R.styleable.TwoLevelHeader_srlEnableTwoLevel, this.mEnableTwoLevel);
        this.mBottomPullUpToCloseRate = ta.getFloat(R.styleable.TwoLevelHeader_srlBottomPullUpToCloseRate, this.mBottomPullUpToCloseRate);
        this.mEnablePullToCloseTwoLevel = ta.getBoolean(R.styleable.TwoLevelHeader_srlEnablePullToCloseTwoLevel, this.mEnablePullToCloseTwoLevel);
        ta.recycle();
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        TwoLevelHeader thisGroup = this;
        int len = thisGroup.getChildCount();
        for (int i = 0; i < len; ++i) {
            View childAt = thisGroup.getChildAt(i);
            if (!(childAt instanceof RefreshHeader)) continue;
            this.mRefreshHeader = (RefreshHeader)childAt;
            this.mWrappedInternal = (RefreshComponent)childAt;
            thisGroup.bringChildToFront(childAt);
            break;
        }
        if (this.mRefreshHeader == null) {
            TwoLevelHeader thisView = this;
            this.setRefreshHeader((RefreshHeader)new ClassicsHeader(thisView.getContext()));
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mSpinnerStyle = SpinnerStyle.MatchLayout;
        if (this.mRefreshHeader == null) {
            TwoLevelHeader thisView = this;
            this.setRefreshHeader((RefreshHeader)new ClassicsHeader(thisView.getContext()));
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mSpinnerStyle = SpinnerStyle.FixedBehind;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        RefreshComponent refreshHeader = this.mRefreshHeader;
        if (refreshHeader != null) {
            int mode = View.MeasureSpec.getMode((int)heightMeasureSpec);
            if (mode == Integer.MIN_VALUE) {
                refreshHeader.getView().measure(widthMeasureSpec, heightMeasureSpec);
                int height = refreshHeader.getView().getMeasuredHeight();
                super.setMeasuredDimension(View.resolveSize((int)super.getSuggestedMinimumWidth(), (int)widthMeasureSpec), height);
            } else {
                super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            }
        } else {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        }
    }

    public boolean equals(Object obj) {
        RefreshComponent header = this.mRefreshHeader;
        return header != null && header.equals(obj) || super.equals(obj);
    }

    public void onInitialized(@NonNull RefreshKernel kernel, int height, int maxDragHeight) {
        TwoLevelHeader thisView = this;
        RefreshComponent refreshHeader = this.mRefreshHeader;
        if (refreshHeader == null) {
            return;
        }
        if (1.0f * (float)(maxDragHeight + height) / (float)height != this.mMaxRate && this.mHeaderHeight == 0) {
            this.mHeaderHeight = height;
            this.mRefreshHeader = null;
            kernel.getRefreshLayout().setHeaderMaxDragRate(this.mMaxRate);
            this.mRefreshHeader = refreshHeader;
        }
        if (this.mRefreshKernel == null && refreshHeader.getSpinnerStyle() == SpinnerStyle.Translate && !thisView.isInEditMode()) {
            ViewGroup.MarginLayoutParams params = (ViewGroup.MarginLayoutParams)refreshHeader.getView().getLayoutParams();
            params.topMargin -= height;
            refreshHeader.getView().setLayoutParams((ViewGroup.LayoutParams)params);
        }
        this.mHeaderHeight = height;
        this.mRefreshKernel = kernel;
        kernel.requestFloorDuration(this.mFloorDuration);
        kernel.requestFloorBottomPullUpToCloseRate(this.mBottomPullUpToCloseRate);
        kernel.requestNeedTouchEventFor((RefreshComponent)this, !this.mEnablePullToCloseTwoLevel);
        refreshHeader.onInitialized(kernel, height, maxDragHeight);
    }

    public void onStateChanged(@NonNull RefreshLayout refreshLayout, @NonNull RefreshState oldState, @NonNull RefreshState newState) {
        RefreshComponent refreshHeader = this.mRefreshHeader;
        if (refreshHeader != null) {
            RefreshComponent listener = this.mRefreshHeader;
            if (newState == RefreshState.ReleaseToRefresh && !this.mEnableRefresh) {
                newState = RefreshState.PullDownToRefresh;
            }
            listener.onStateChanged(refreshLayout, oldState, newState);
            switch (newState) {
                case TwoLevelReleased: {
                    RefreshKernel refreshKernel;
                    if (refreshHeader.getView() != this) {
                        refreshHeader.getView().animate().alpha(0.0f).setDuration((long)(this.mFloorDuration / 2));
                    }
                    if ((refreshKernel = this.mRefreshKernel) == null) break;
                    OnTwoLevelListener twoLevelListener = this.mTwoLevelListener;
                    refreshKernel.startTwoLevel(twoLevelListener == null || twoLevelListener.onTwoLevel(refreshLayout));
                    break;
                }
                case TwoLevel: {
                    break;
                }
                case TwoLevelFinish: {
                    if (refreshHeader.getView() == this) break;
                    refreshHeader.getView().animate().alpha(1.0f).setDuration((long)(this.mFloorDuration / 2));
                    break;
                }
                case PullDownToRefresh: {
                    if (refreshHeader.getView().getAlpha() != 0.0f || refreshHeader.getView() == this) break;
                    refreshHeader.getView().setAlpha(1.0f);
                }
            }
        }
    }

    public void onMoving(boolean isDragging, float percent, int offset, int height, int maxDragHeight) {
        this.moveSpinner(offset);
        RefreshComponent refreshHeader = this.mRefreshHeader;
        RefreshKernel refreshKernel = this.mRefreshKernel;
        if (refreshHeader != null) {
            refreshHeader.onMoving(isDragging, percent, offset, height, maxDragHeight);
        }
        if (isDragging) {
            if (this.mPercent < this.mFloorRate && percent >= this.mFloorRate && this.mEnableTwoLevel) {
                refreshKernel.setState(RefreshState.ReleaseToTwoLevel);
            } else if (this.mPercent >= this.mFloorRate && percent < this.mRefreshRate) {
                refreshKernel.setState(RefreshState.PullDownToRefresh);
            } else if (this.mPercent >= this.mFloorRate && percent < this.mFloorRate && this.mEnableRefresh) {
                refreshKernel.setState(RefreshState.ReleaseToRefresh);
            } else if (!this.mEnableRefresh && refreshKernel.getRefreshLayout().getState() != RefreshState.ReleaseToTwoLevel) {
                refreshKernel.setState(RefreshState.PullDownToRefresh);
            }
            this.mPercent = percent;
        }
    }

    protected void moveSpinner(int spinner) {
        RefreshComponent refreshHeader = this.mRefreshHeader;
        if (this.mSpinner != spinner && refreshHeader != null) {
            this.mSpinner = spinner;
            SpinnerStyle style = refreshHeader.getSpinnerStyle();
            if (style == SpinnerStyle.Translate) {
                refreshHeader.getView().setTranslationY((float)spinner);
            } else if (style.scale) {
                View view = refreshHeader.getView();
                view.layout(view.getLeft(), view.getTop(), view.getRight(), view.getTop() + Math.max(0, spinner));
            }
        }
    }

    public boolean onStartNestedScroll(@NonNull View child, @NonNull View target, int nestedScrollAxes) {
        return true;
    }

    public void onNestedScrollAccepted(@NonNull View child, @NonNull View target, int nestedScrollAxes) {
        this.mNestedScrollAxes = nestedScrollAxes;
    }

    public void onStopNestedScroll(@NonNull View target) {
    }

    public void onNestedScroll(@NonNull View target, int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed) {
    }

    public void onNestedPreScroll(@NonNull View target, int dx, int dy, @NonNull int[] consumed) {
    }

    public boolean onNestedFling(@NonNull View target, float velocityX, float velocityY, boolean consumed) {
        return false;
    }

    public boolean onNestedPreFling(@NonNull View target, float velocityX, float velocityY) {
        return false;
    }

    public int getNestedScrollAxes() {
        return this.mNestedScrollAxes;
    }

    public boolean onStartNestedScroll(@NonNull View child, @NonNull View target, int nestedScrollAxes, int i1) {
        return true;
    }

    public void onNestedScrollAccepted(@NonNull View child, @NonNull View target, int nestedScrollAxes, int i1) {
        this.mNestedScrollAxes = nestedScrollAxes;
    }

    public void onStopNestedScroll(@NonNull View view, int i) {
    }

    public void onNestedScroll(@NonNull View target, int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed, int i4) {
    }

    public void onNestedPreScroll(@NonNull View target, int dx, int dy, @NonNull int[] consumed, int i2) {
    }

    public TwoLevelHeader setRefreshHeader(RefreshHeader header) {
        return this.setRefreshHeader(header, 0, 0);
    }

    public TwoLevelHeader setRefreshHeader(RefreshHeader header, int width, int height) {
        TwoLevelHeader thisGroup = this;
        if (header != null) {
            RefreshComponent refreshHeader;
            width = width == 0 ? -1 : width;
            height = height == 0 ? -2 : height;
            RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(width, height);
            ViewGroup.LayoutParams olp = header.getView().getLayoutParams();
            if (olp instanceof RelativeLayout.LayoutParams) {
                lp = (RelativeLayout.LayoutParams)olp;
            }
            if ((refreshHeader = this.mRefreshHeader) != null) {
                thisGroup.removeView(refreshHeader.getView());
            }
            if ((refreshHeader = header).getSpinnerStyle() == SpinnerStyle.FixedBehind) {
                thisGroup.addView(refreshHeader.getView(), 0, (ViewGroup.LayoutParams)lp);
            } else {
                thisGroup.addView(refreshHeader.getView(), thisGroup.getChildCount(), (ViewGroup.LayoutParams)lp);
            }
            this.mRefreshHeader = header;
            this.mWrappedInternal = header;
        }
        return this;
    }

    public TwoLevelHeader setMaxRate(float rate) {
        if (this.mMaxRate != rate) {
            this.mMaxRate = rate;
            RefreshKernel refreshKernel = this.mRefreshKernel;
            if (refreshKernel != null) {
                this.mHeaderHeight = 0;
                refreshKernel.getRefreshLayout().setHeaderMaxDragRate(this.mMaxRate);
            }
        }
        return this;
    }

    public TwoLevelHeader setEnablePullToCloseTwoLevel(boolean enabled) {
        RefreshKernel refreshKernel = this.mRefreshKernel;
        this.mEnablePullToCloseTwoLevel = enabled;
        if (refreshKernel != null) {
            refreshKernel.requestNeedTouchEventFor((RefreshComponent)this, !enabled);
        }
        return this;
    }

    public TwoLevelHeader setEnableRefresh(boolean enabled) {
        this.mEnableRefresh = enabled;
        return this;
    }

    public TwoLevelHeader setFloorRate(float rate) {
        this.mFloorRate = rate;
        return this;
    }

    public TwoLevelHeader setRefreshRate(float rate) {
        this.mRefreshRate = rate;
        return this;
    }

    public TwoLevelHeader setEnableTwoLevel(boolean enabled) {
        this.mEnableTwoLevel = enabled;
        return this;
    }

    public TwoLevelHeader setFloorDuration(int duration) {
        this.mFloorDuration = duration;
        return this;
    }

    public TwoLevelHeader setBottomPullUpToCloseRate(float rate) {
        this.mBottomPullUpToCloseRate = rate;
        return this;
    }

    public TwoLevelHeader setOnTwoLevelListener(OnTwoLevelListener listener) {
        this.mTwoLevelListener = listener;
        return this;
    }

    public TwoLevelHeader finishTwoLevel() {
        RefreshKernel refreshKernel = this.mRefreshKernel;
        if (refreshKernel != null) {
            refreshKernel.finishTwoLevel();
        }
        return this;
    }

    public TwoLevelHeader openTwoLevel(boolean widthOnTwoLevelListener) {
        RefreshKernel refreshKernel = this.mRefreshKernel;
        if (refreshKernel != null) {
            OnTwoLevelListener twoLevelListener = this.mTwoLevelListener;
            refreshKernel.startTwoLevel(!widthOnTwoLevelListener || twoLevelListener == null || twoLevelListener.onTwoLevel(refreshKernel.getRefreshLayout()));
        }
        return this;
    }
}

