/*
 * Decompiled with CFR 0.152.
 */
package com.scwang.smart.refresh.header;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;
import android.support.annotation.NonNull;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.view.animation.AccelerateDecelerateInterpolator;
import com.scwang.smart.refresh.header.radar.R;
import com.scwang.smart.refresh.layout.api.RefreshHeader;
import com.scwang.smart.refresh.layout.api.RefreshLayout;
import com.scwang.smart.refresh.layout.constant.RefreshState;
import com.scwang.smart.refresh.layout.constant.SpinnerStyle;
import com.scwang.smart.refresh.layout.simple.SimpleComponent;
import com.scwang.smart.refresh.layout.util.SmartUtil;

public class BezierRadarHeader
extends SimpleComponent
implements RefreshHeader {
    protected int mAccentColor;
    protected int mPrimaryColor;
    protected boolean mManualPrimaryColor;
    protected boolean mManualAccentColor;
    protected boolean mWavePulling;
    protected boolean mEnableHorizontalDrag = false;
    protected Path mPath;
    protected Paint mPaint;
    protected int mWaveTop;
    protected int mWaveHeight;
    protected int mWaveOffsetX = -1;
    protected int mWaveOffsetY = 0;
    protected float mDotAlpha;
    protected float mDotFraction;
    protected float mDotRadius;
    protected float mRippleRadius;
    protected int mRadarAngle = 0;
    protected float mRadarRadius = 0.0f;
    protected float mRadarCircle = 0.0f;
    protected float mRadarScale = 0.0f;
    protected Animator mAnimatorSet;
    protected RectF mRadarRect = new RectF(0.0f, 0.0f, 0.0f, 0.0f);
    protected static final byte PROPERTY_RADAR_SCALE = 0;
    protected static final byte PROPERTY_WAVE_HEIGHT = 1;
    protected static final byte PROPERTY_DOT_ALPHA = 2;
    protected static final byte PROPERTY_RIPPLE_RADIUS = 3;
    protected static final byte PROPERTY_RADAR_ANGLE = 4;

    public BezierRadarHeader(Context context) {
        this(context, null);
    }

    public BezierRadarHeader(Context context, AttributeSet attrs) {
        super(context, attrs, 0);
        this.mSpinnerStyle = SpinnerStyle.FixedBehind;
        BezierRadarHeader thisView = this;
        this.mPath = new Path();
        this.mPaint = new Paint();
        this.mPaint.setAntiAlias(true);
        this.mDotRadius = SmartUtil.dp2px((float)7.0f);
        this.mRadarRadius = SmartUtil.dp2px((float)20.0f);
        this.mRadarCircle = SmartUtil.dp2px((float)7.0f);
        this.mPaint.setStrokeWidth((float)SmartUtil.dp2px((float)3.0f));
        thisView.setMinimumHeight(SmartUtil.dp2px((float)100.0f));
        if (thisView.isInEditMode()) {
            this.mWaveTop = 1000;
            this.mRadarScale = 1.0f;
            this.mRadarAngle = 270;
        } else {
            this.mRadarScale = 0.0f;
        }
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.BezierRadarHeader);
        this.mEnableHorizontalDrag = ta.getBoolean(R.styleable.BezierRadarHeader_srlEnableHorizontalDrag, this.mEnableHorizontalDrag);
        this.setAccentColor(ta.getColor(R.styleable.BezierRadarHeader_srlAccentColor, -1));
        this.setPrimaryColor(ta.getColor(R.styleable.BezierRadarHeader_srlPrimaryColor, -14540254));
        this.mManualAccentColor = ta.hasValue(R.styleable.BezierRadarHeader_srlAccentColor);
        this.mManualPrimaryColor = ta.hasValue(R.styleable.BezierRadarHeader_srlPrimaryColor);
        ta.recycle();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mAnimatorSet != null) {
            this.mAnimatorSet.removeAllListeners();
            this.mAnimatorSet.end();
            this.mAnimatorSet = null;
        }
    }

    protected void dispatchDraw(Canvas canvas) {
        BezierRadarHeader thisView = this;
        int width = thisView.getWidth();
        int height = thisView.isInEditMode() ? thisView.getHeight() : this.mWaveOffsetY;
        this.drawWave(canvas, width);
        this.drawDot(canvas, width, height);
        this.drawRadar(canvas, width, height);
        this.drawRipple(canvas, width, height);
        super.dispatchDraw(canvas);
    }

    protected void drawWave(Canvas canvas, int width) {
        this.mPath.reset();
        this.mPath.lineTo(0.0f, (float)this.mWaveTop);
        this.mPath.quadTo(this.mWaveOffsetX >= 0 ? (float)this.mWaveOffsetX : (float)width / 2.0f, (float)(this.mWaveTop + this.mWaveHeight), (float)width, (float)this.mWaveTop);
        this.mPath.lineTo((float)width, 0.0f);
        this.mPaint.setColor(this.mPrimaryColor);
        canvas.drawPath(this.mPath, this.mPaint);
    }

    protected void drawDot(Canvas canvas, int width, int height) {
        if (this.mDotAlpha > 0.0f) {
            this.mPaint.setColor(this.mAccentColor);
            int num = 7;
            float x = SmartUtil.px2dp((int)height);
            float wide = 1.0f * (float)width / 7.0f * this.mDotFraction - (this.mDotFraction > 1.0f ? (this.mDotFraction - 1.0f) * (1.0f * (float)width / 7.0f) / this.mDotFraction : 0.0f);
            float high = (float)height - (this.mDotFraction > 1.0f ? (this.mDotFraction - 1.0f) * (float)height / 2.0f / this.mDotFraction : 0.0f);
            for (int i = 0; i < 7; ++i) {
                float index = 1.0f + (float)i - 4.0f;
                float alpha = 255.0f * (1.0f - 2.0f * (Math.abs(index) / 7.0f));
                this.mPaint.setAlpha((int)((double)(this.mDotAlpha * alpha) * (1.0 - 1.0 / Math.pow((double)x / 800.0 + 1.0, 15.0))));
                float radius = this.mDotRadius * (1.0f - 1.0f / (x / 10.0f + 1.0f));
                canvas.drawCircle((float)width / 2.0f - radius / 2.0f + wide * index, high / 2.0f, radius, this.mPaint);
            }
            this.mPaint.setAlpha(255);
        }
    }

    protected void drawRadar(Canvas canvas, int width, int height) {
        BezierRadarHeader thisView = this;
        if (this.mAnimatorSet != null || thisView.isInEditMode()) {
            float radius = this.mRadarRadius * this.mRadarScale;
            float circle = this.mRadarCircle * this.mRadarScale;
            this.mPaint.setColor(this.mAccentColor);
            this.mPaint.setStyle(Paint.Style.FILL);
            canvas.drawCircle((float)width / 2.0f, (float)height / 2.0f, radius, this.mPaint);
            this.mPaint.setStyle(Paint.Style.STROKE);
            canvas.drawCircle((float)width / 2.0f, (float)height / 2.0f, radius + circle, this.mPaint);
            this.mPaint.setColor(this.mPrimaryColor & 0xFFFFFF | 0x55000000);
            this.mPaint.setStyle(Paint.Style.FILL);
            this.mRadarRect.set((float)width / 2.0f - radius, (float)height / 2.0f - radius, (float)width / 2.0f + radius, (float)height / 2.0f + radius);
            canvas.drawArc(this.mRadarRect, 270.0f, (float)this.mRadarAngle, true, this.mPaint);
            this.mPaint.setStyle(Paint.Style.STROKE);
            this.mRadarRect.set((float)width / 2.0f - (radius += circle), (float)height / 2.0f - radius, (float)width / 2.0f + radius, (float)height / 2.0f + radius);
            canvas.drawArc(this.mRadarRect, 270.0f, (float)this.mRadarAngle, false, this.mPaint);
            this.mPaint.setStyle(Paint.Style.FILL);
        }
    }

    protected void drawRipple(Canvas canvas, int width, int height) {
        if (this.mRippleRadius > 0.0f) {
            this.mPaint.setColor(this.mAccentColor);
            canvas.drawCircle((float)width / 2.0f, (float)height / 2.0f, this.mRippleRadius, this.mPaint);
        }
    }

    public void onMoving(boolean isDragging, float percent, int offset, int height, int maxDragHeight) {
        this.mWaveOffsetY = offset;
        if (isDragging || this.mWavePulling) {
            this.mWavePulling = true;
            this.mWaveTop = Math.min(height, offset);
            this.mWaveHeight = (int)(1.9f * (float)Math.max(0, offset - height));
            this.mDotFraction = percent;
            BezierRadarHeader thisView = this;
            thisView.invalidate();
        }
    }

    public void onReleased(@NonNull RefreshLayout refreshLayout, int height, int maxDragHeight) {
        this.mWaveTop = height - 1;
        this.mWavePulling = false;
        SmartUtil interpolatorDecelerate = new SmartUtil(SmartUtil.INTERPOLATOR_DECELERATE);
        ValueAnimator animatorDotAlpha = ValueAnimator.ofFloat((float[])new float[]{1.0f, 0.0f});
        animatorDotAlpha.setInterpolator((TimeInterpolator)interpolatorDecelerate);
        animatorDotAlpha.addUpdateListener((ValueAnimator.AnimatorUpdateListener)new AnimatorUpdater(2));
        ValueAnimator animatorRadarScale = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        animatorDotAlpha.setInterpolator((TimeInterpolator)interpolatorDecelerate);
        animatorRadarScale.addUpdateListener((ValueAnimator.AnimatorUpdateListener)new AnimatorUpdater(0));
        ValueAnimator mRadarAnimator = ValueAnimator.ofInt((int[])new int[]{0, 360});
        mRadarAnimator.setDuration(720L);
        mRadarAnimator.setRepeatCount(-1);
        mRadarAnimator.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        mRadarAnimator.addUpdateListener((ValueAnimator.AnimatorUpdateListener)new AnimatorUpdater(4));
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.playSequentially(new Animator[]{animatorDotAlpha, animatorRadarScale, mRadarAnimator});
        animatorSet.start();
        ValueAnimator animatorWave = ValueAnimator.ofInt((int[])new int[]{this.mWaveHeight, 0, -((int)((float)this.mWaveHeight * 0.8f)), 0, -((int)((float)this.mWaveHeight * 0.4f)), 0});
        animatorWave.addUpdateListener((ValueAnimator.AnimatorUpdateListener)new AnimatorUpdater(1));
        animatorWave.setInterpolator((TimeInterpolator)new SmartUtil(SmartUtil.INTERPOLATOR_DECELERATE));
        animatorWave.setDuration(800L);
        animatorWave.start();
        this.mAnimatorSet = animatorSet;
    }

    public int onFinish(@NonNull RefreshLayout layout, boolean success) {
        if (this.mAnimatorSet != null) {
            this.mAnimatorSet.removeAllListeners();
            this.mAnimatorSet.end();
            this.mAnimatorSet = null;
        }
        int duration = 400;
        BezierRadarHeader thisView = this;
        int width = thisView.getWidth();
        int height = this.mWaveOffsetY;
        float bigRadius = (float)Math.sqrt(width * width + height * height);
        ValueAnimator animator = ValueAnimator.ofFloat((float[])new float[]{this.mRadarRadius, bigRadius});
        animator.setDuration(400L);
        animator.addUpdateListener((ValueAnimator.AnimatorUpdateListener)new AnimatorUpdater(3));
        animator.start();
        return 400;
    }

    public void onStateChanged(@NonNull RefreshLayout refreshLayout, @NonNull RefreshState oldState, @NonNull RefreshState newState) {
        switch (newState) {
            case None: 
            case PullDownToRefresh: {
                this.mDotAlpha = 1.0f;
                this.mRadarScale = 0.0f;
                this.mRippleRadius = 0.0f;
            }
        }
    }

    @Deprecated
    public void setPrimaryColors(int ... colors) {
        if (colors.length > 0 && !this.mManualPrimaryColor) {
            this.setPrimaryColor(colors[0]);
            this.mManualPrimaryColor = false;
        }
        if (colors.length > 1 && !this.mManualAccentColor) {
            this.setAccentColor(colors[1]);
            this.mManualAccentColor = false;
        }
    }

    public boolean isSupportHorizontalDrag() {
        return this.mEnableHorizontalDrag;
    }

    public void onHorizontalDrag(float percentX, int offsetX, int offsetMax) {
        this.mWaveOffsetX = offsetX;
        BezierRadarHeader thisView = this;
        thisView.invalidate();
    }

    public BezierRadarHeader setPrimaryColor(@ColorInt int color) {
        this.mPrimaryColor = color;
        this.mManualPrimaryColor = true;
        return this;
    }

    public BezierRadarHeader setAccentColor(@ColorInt int color) {
        this.mAccentColor = color;
        this.mManualAccentColor = true;
        return this;
    }

    public BezierRadarHeader setPrimaryColorId(@ColorRes int colorId) {
        BezierRadarHeader thisView = this;
        this.setPrimaryColor(ContextCompat.getColor((Context)thisView.getContext(), (int)colorId));
        return this;
    }

    public BezierRadarHeader setAccentColorId(@ColorRes int colorId) {
        BezierRadarHeader thisView = this;
        this.setAccentColor(ContextCompat.getColor((Context)thisView.getContext(), (int)colorId));
        return this;
    }

    public BezierRadarHeader setEnableHorizontalDrag(boolean enable) {
        this.mEnableHorizontalDrag = enable;
        if (!enable) {
            this.mWaveOffsetX = -1;
        }
        return this;
    }

    protected class AnimatorUpdater
    implements ValueAnimator.AnimatorUpdateListener {
        byte propertyName;

        AnimatorUpdater(byte name) {
            this.propertyName = name;
        }

        public void onAnimationUpdate(ValueAnimator animation) {
            if (0 == this.propertyName) {
                BezierRadarHeader.this.mRadarScale = ((Float)animation.getAnimatedValue()).floatValue();
            } else if (1 == this.propertyName) {
                if (BezierRadarHeader.this.mWavePulling) {
                    animation.cancel();
                    return;
                }
                BezierRadarHeader.this.mWaveHeight = (Integer)animation.getAnimatedValue() / 2;
            } else if (2 == this.propertyName) {
                BezierRadarHeader.this.mDotAlpha = ((Float)animation.getAnimatedValue()).floatValue();
            } else if (3 == this.propertyName) {
                BezierRadarHeader.this.mRippleRadius = ((Float)animation.getAnimatedValue()).floatValue();
            } else if (4 == this.propertyName) {
                BezierRadarHeader.this.mRadarAngle = (Integer)animation.getAnimatedValue();
            }
            BezierRadarHeader thisView = BezierRadarHeader.this;
            thisView.invalidate();
        }
    }
}

