/*
 * Decompiled with CFR 0.152.
 */
package com.scwang.smart.drawable.path;

import android.graphics.Matrix;
import android.graphics.Path;
import android.os.Build;
import android.support.annotation.NonNull;
import java.util.ArrayList;
import java.util.List;

public class PathParser {
    private static final String TAG = "PathParser";

    private static float[] copyOfRange(@NonNull float[] original, int start, int end) {
        int originalLength = original.length;
        int resultLength = end - start;
        int copyLength = Math.min(resultLength, originalLength - start);
        float[] result = new float[resultLength];
        System.arraycopy(original, start, result, 0, copyLength);
        return result;
    }

    public static List<Path> transformScale(float ratioWidth, float ratioHeight, List<Path> originPaths, List<String> orginSvgs) {
        Matrix matrix = new Matrix();
        matrix.setScale(ratioWidth, ratioHeight);
        ArrayList<Path> paths = new ArrayList<Path>();
        if (Build.VERSION.SDK_INT > 16) {
            for (Path path : originPaths) {
                Path nPath = new Path();
                path.transform(matrix, nPath);
                paths.add(nPath);
            }
        } else {
            for (String svgPath : orginSvgs) {
                Path path = new Path();
                PathDataNode[] nodes = PathParser.createNodesFromPathData(svgPath);
                PathParser.transformScaleNodes(ratioWidth, ratioHeight, nodes);
                PathDataNode.nodesToPath(nodes, path);
                paths.add(path);
            }
        }
        return paths;
    }

    private static void transformScaleNodes(float ratioWidth, float ratioHeight, PathDataNode[] node) {
        for (PathDataNode aNode : node) {
            PathParser.transformScaleCommand(ratioWidth, ratioHeight, aNode.type, aNode.params);
        }
    }

    private static void transformScaleCommand(float ratioWidth, float ratioHeight, char cmd, float[] val) {
        int inc = 2;
        switch (cmd) {
            case 'Z': 
            case 'z': {
                break;
            }
            case 'L': 
            case 'M': 
            case 'T': 
            case 'l': 
            case 'm': 
            case 't': {
                inc = 2;
                break;
            }
            case 'H': 
            case 'V': 
            case 'h': 
            case 'v': {
                inc = 1;
                break;
            }
            case 'C': 
            case 'c': {
                inc = 6;
                break;
            }
            case 'Q': 
            case 'S': 
            case 'q': 
            case 's': {
                inc = 4;
                break;
            }
            case 'A': 
            case 'a': {
                inc = 7;
            }
        }
        block16: for (int k = 0; k < val.length; k += inc) {
            switch (cmd) {
                case 'L': 
                case 'M': 
                case 'T': 
                case 'l': 
                case 'm': 
                case 't': {
                    int n = k;
                    val[n] = val[n] * ratioWidth;
                    int n2 = k + 1;
                    val[n2] = val[n2] * ratioHeight;
                    continue block16;
                }
                case 'H': 
                case 'h': {
                    int n = k;
                    val[n] = val[n] * ratioWidth;
                    continue block16;
                }
                case 'V': 
                case 'v': {
                    int n = k;
                    val[n] = val[n] * ratioHeight;
                    continue block16;
                }
                case 'C': 
                case 'c': {
                    int n = k;
                    val[n] = val[n] * ratioWidth;
                    int n3 = k + 1;
                    val[n3] = val[n3] * ratioHeight;
                    int n4 = k + 2;
                    val[n4] = val[n4] * ratioWidth;
                    int n5 = k + 3;
                    val[n5] = val[n5] * ratioHeight;
                    int n6 = k + 4;
                    val[n6] = val[n6] * ratioWidth;
                    int n7 = k + 5;
                    val[n7] = val[n7] * ratioHeight;
                    continue block16;
                }
                case 'Q': 
                case 'S': 
                case 'q': 
                case 's': {
                    int n = k;
                    val[n] = val[n] * ratioWidth;
                    int n8 = k + 1;
                    val[n8] = val[n8] * ratioHeight;
                    int n9 = k + 2;
                    val[n9] = val[n9] * ratioWidth;
                    int n10 = k + 3;
                    val[n10] = val[n10] * ratioHeight;
                }
                case 'A': 
                case 'a': {
                    int n = k;
                    val[n] = val[n] * ratioWidth;
                    int n11 = k + 1;
                    val[n11] = val[n11] * ratioHeight;
                    int n12 = k + 5;
                    val[n12] = val[n12] * ratioWidth;
                    int n13 = k + 6;
                    val[n13] = val[n13] * ratioHeight;
                }
            }
        }
    }

    public static Path createPathFromPathData(String pathData) {
        Path path = new Path();
        PathDataNode[] nodes = PathParser.createNodesFromPathData(pathData);
        if (nodes != null) {
            try {
                PathDataNode.nodesToPath(nodes, path);
            }
            catch (RuntimeException e) {
                throw new RuntimeException("Error in parsing " + pathData, e);
            }
            return path;
        }
        return null;
    }

    public static PathDataNode[] createNodesFromPathData(String pathData) {
        if (pathData == null) {
            return null;
        }
        int start = 0;
        int end = 1;
        ArrayList<PathDataNode> list = new ArrayList<PathDataNode>();
        while (end < pathData.length()) {
            String s = pathData.substring(start, end = PathParser.nextStart(pathData, end)).trim();
            if (s.length() > 0) {
                float[] val = PathParser.getFloats(s);
                PathParser.addNode(list, s.charAt(0), val);
            }
            start = end++;
        }
        if (end - start == 1 && start < pathData.length()) {
            PathParser.addNode(list, pathData.charAt(start), new float[0]);
        }
        return list.toArray(new PathDataNode[0]);
    }

    private static int nextStart(String s, int end) {
        while (end < s.length()) {
            char c = s.charAt(end);
            if (((c - 65) * (c - 90) <= 0 || (c - 97) * (c - 122) <= 0) && c != 'e' && c != 'E') {
                return end;
            }
            ++end;
        }
        return end;
    }

    private static void addNode(List<PathDataNode> list, char cmd, float[] val) {
        list.add(new PathDataNode(cmd, val));
    }

    private static float[] getFloats(String s) {
        if (s.charAt(0) == 'z' | s.charAt(0) == 'Z') {
            return new float[0];
        }
        try {
            float[] results = new float[s.length()];
            int count = 0;
            int startPosition = 1;
            ExtractFloatResult result = new ExtractFloatResult();
            int totalLength = s.length();
            while (startPosition < totalLength) {
                PathParser.extract(s, startPosition, result);
                int endPosition = result.mEndPosition;
                if (startPosition < endPosition) {
                    results[count++] = Float.parseFloat(s.substring(startPosition, endPosition));
                }
                if (result.mEndWithNegOrDot) {
                    startPosition = endPosition;
                    continue;
                }
                startPosition = endPosition + 1;
            }
            return PathParser.copyOfRange(results, 0, count);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("error in parsing \"" + s + "\"", e);
        }
    }

    private static void extract(String s, int start, ExtractFloatResult result) {
        int currentIndex;
        boolean foundSeparator = false;
        result.mEndWithNegOrDot = false;
        boolean secondDot = false;
        boolean isExponential = false;
        for (currentIndex = start; currentIndex < s.length(); ++currentIndex) {
            boolean isPrevExponential = isExponential;
            isExponential = false;
            char currentChar = s.charAt(currentIndex);
            switch (currentChar) {
                case ' ': 
                case ',': {
                    foundSeparator = true;
                    break;
                }
                case '-': {
                    if (currentIndex == start || isPrevExponential) break;
                    foundSeparator = true;
                    result.mEndWithNegOrDot = true;
                    break;
                }
                case '.': {
                    if (!secondDot) {
                        secondDot = true;
                        break;
                    }
                    foundSeparator = true;
                    result.mEndWithNegOrDot = true;
                    break;
                }
                case 'E': 
                case 'e': {
                    isExponential = true;
                }
            }
            if (foundSeparator) break;
        }
        result.mEndPosition = currentIndex;
    }

    public static class PathDataNode {
        char type;
        float[] params;

        PathDataNode(char type, float[] params) {
            this.type = type;
            this.params = params;
        }

        public static void nodesToPath(PathDataNode[] node, Path path) {
            float[] current = new float[6];
            char previousCommand = 'm';
            for (PathDataNode aNode : node) {
                PathDataNode.addCommand(path, current, previousCommand, aNode.type, aNode.params);
                previousCommand = aNode.type;
            }
        }

        private static void addCommand(Path path, float[] current, char previousCmd, char cmd, float[] val) {
            int inc = 2;
            float currentX = current[0];
            float currentY = current[1];
            float ctrlPointX = current[2];
            float ctrlPointY = current[3];
            float currentSegmentStartX = current[4];
            float currentSegmentStartY = current[5];
            switch (cmd) {
                case 'Z': 
                case 'z': {
                    path.close();
                    currentX = currentSegmentStartX;
                    currentY = currentSegmentStartY;
                    ctrlPointX = currentSegmentStartX;
                    ctrlPointY = currentSegmentStartY;
                    path.moveTo(currentX, currentY);
                    break;
                }
                case 'L': 
                case 'M': 
                case 'T': 
                case 'l': 
                case 'm': 
                case 't': {
                    inc = 2;
                    break;
                }
                case 'H': 
                case 'V': 
                case 'h': 
                case 'v': {
                    inc = 1;
                    break;
                }
                case 'C': 
                case 'c': {
                    inc = 6;
                    break;
                }
                case 'Q': 
                case 'S': 
                case 'q': 
                case 's': {
                    inc = 4;
                    break;
                }
                case 'A': 
                case 'a': {
                    inc = 7;
                }
            }
            for (int k = 0; k < val.length; k += inc) {
                switch (cmd) {
                    case 'm': {
                        currentX += val[k + 0];
                        currentY += val[k + 1];
                        if (k > 0) {
                            path.rLineTo(val[k + 0], val[k + 1]);
                            break;
                        }
                        path.rMoveTo(val[k + 0], val[k + 1]);
                        currentSegmentStartX = currentX;
                        currentSegmentStartY = currentY;
                        break;
                    }
                    case 'M': {
                        currentX = val[k + 0];
                        currentY = val[k + 1];
                        if (k > 0) {
                            path.lineTo(val[k + 0], val[k + 1]);
                            break;
                        }
                        path.moveTo(val[k + 0], val[k + 1]);
                        currentSegmentStartX = currentX;
                        currentSegmentStartY = currentY;
                        break;
                    }
                    case 'l': {
                        path.rLineTo(val[k + 0], val[k + 1]);
                        currentX += val[k + 0];
                        currentY += val[k + 1];
                        break;
                    }
                    case 'L': {
                        path.lineTo(val[k + 0], val[k + 1]);
                        currentX = val[k + 0];
                        currentY = val[k + 1];
                        break;
                    }
                    case 'h': {
                        path.rLineTo(val[k + 0], 0.0f);
                        currentX += val[k + 0];
                        break;
                    }
                    case 'H': {
                        path.lineTo(val[k + 0], currentY);
                        currentX = val[k + 0];
                        break;
                    }
                    case 'v': {
                        path.rLineTo(0.0f, val[k + 0]);
                        currentY += val[k + 0];
                        break;
                    }
                    case 'V': {
                        path.lineTo(currentX, val[k + 0]);
                        currentY = val[k + 0];
                        break;
                    }
                    case 'c': {
                        path.rCubicTo(val[k + 0], val[k + 1], val[k + 2], val[k + 3], val[k + 4], val[k + 5]);
                        ctrlPointX = currentX + val[k + 2];
                        ctrlPointY = currentY + val[k + 3];
                        currentX += val[k + 4];
                        currentY += val[k + 5];
                        break;
                    }
                    case 'C': {
                        path.cubicTo(val[k + 0], val[k + 1], val[k + 2], val[k + 3], val[k + 4], val[k + 5]);
                        currentX = val[k + 4];
                        currentY = val[k + 5];
                        ctrlPointX = val[k + 2];
                        ctrlPointY = val[k + 3];
                        break;
                    }
                    case 's': {
                        float reflectiveCtrlPointX = 0.0f;
                        float reflectiveCtrlPointY = 0.0f;
                        if (previousCmd == 'c' || previousCmd == 's' || previousCmd == 'C' || previousCmd == 'S') {
                            reflectiveCtrlPointX = currentX - ctrlPointX;
                            reflectiveCtrlPointY = currentY - ctrlPointY;
                        }
                        path.rCubicTo(reflectiveCtrlPointX, reflectiveCtrlPointY, val[k + 0], val[k + 1], val[k + 2], val[k + 3]);
                        ctrlPointX = currentX + val[k + 0];
                        ctrlPointY = currentY + val[k + 1];
                        currentX += val[k + 2];
                        currentY += val[k + 3];
                        break;
                    }
                    case 'S': {
                        float reflectiveCtrlPointX = currentX;
                        float reflectiveCtrlPointY = currentY;
                        if (previousCmd == 'c' || previousCmd == 's' || previousCmd == 'C' || previousCmd == 'S') {
                            reflectiveCtrlPointX = 2.0f * currentX - ctrlPointX;
                            reflectiveCtrlPointY = 2.0f * currentY - ctrlPointY;
                        }
                        path.cubicTo(reflectiveCtrlPointX, reflectiveCtrlPointY, val[k + 0], val[k + 1], val[k + 2], val[k + 3]);
                        ctrlPointX = val[k + 0];
                        ctrlPointY = val[k + 1];
                        currentX = val[k + 2];
                        currentY = val[k + 3];
                        break;
                    }
                    case 'q': {
                        path.rQuadTo(val[k + 0], val[k + 1], val[k + 2], val[k + 3]);
                        ctrlPointX = currentX + val[k + 0];
                        ctrlPointY = currentY + val[k + 1];
                        currentX += val[k + 2];
                        currentY += val[k + 3];
                        break;
                    }
                    case 'Q': {
                        path.quadTo(val[k + 0], val[k + 1], val[k + 2], val[k + 3]);
                        ctrlPointX = val[k + 0];
                        ctrlPointY = val[k + 1];
                        currentX = val[k + 2];
                        currentY = val[k + 3];
                        break;
                    }
                    case 't': {
                        float reflectiveCtrlPointX = 0.0f;
                        float reflectiveCtrlPointY = 0.0f;
                        if (previousCmd == 'q' || previousCmd == 't' || previousCmd == 'Q' || previousCmd == 'T') {
                            reflectiveCtrlPointX = currentX - ctrlPointX;
                            reflectiveCtrlPointY = currentY - ctrlPointY;
                        }
                        path.rQuadTo(reflectiveCtrlPointX, reflectiveCtrlPointY, val[k + 0], val[k + 1]);
                        ctrlPointX = currentX + reflectiveCtrlPointX;
                        ctrlPointY = currentY + reflectiveCtrlPointY;
                        currentX += val[k + 0];
                        currentY += val[k + 1];
                        break;
                    }
                    case 'T': {
                        float reflectiveCtrlPointX = currentX;
                        float reflectiveCtrlPointY = currentY;
                        if (previousCmd == 'q' || previousCmd == 't' || previousCmd == 'Q' || previousCmd == 'T') {
                            reflectiveCtrlPointX = 2.0f * currentX - ctrlPointX;
                            reflectiveCtrlPointY = 2.0f * currentY - ctrlPointY;
                        }
                        path.quadTo(reflectiveCtrlPointX, reflectiveCtrlPointY, val[k + 0], val[k + 1]);
                        ctrlPointX = reflectiveCtrlPointX;
                        ctrlPointY = reflectiveCtrlPointY;
                        currentX = val[k + 0];
                        currentY = val[k + 1];
                        break;
                    }
                    case 'a': {
                        PathDataNode.drawArc(path, currentX, currentY, val[k + 5] + currentX, val[k + 6] + currentY, val[k + 0], val[k + 1], val[k + 2], val[k + 3] != 0.0f, val[k + 4] != 0.0f);
                        ctrlPointX = currentX += val[k + 5];
                        ctrlPointY = currentY += val[k + 6];
                        break;
                    }
                    case 'A': {
                        PathDataNode.drawArc(path, currentX, currentY, val[k + 5], val[k + 6], val[k + 0], val[k + 1], val[k + 2], val[k + 3] != 0.0f, val[k + 4] != 0.0f);
                        currentX = val[k + 5];
                        currentY = val[k + 6];
                        ctrlPointX = currentX;
                        ctrlPointY = currentY;
                    }
                }
                previousCmd = cmd;
            }
            current[0] = currentX;
            current[1] = currentY;
            current[2] = ctrlPointX;
            current[3] = ctrlPointY;
            current[4] = currentSegmentStartX;
            current[5] = currentSegmentStartY;
        }

        private static void drawArc(Path p, float x0, float y0, float x1, float y1, float a, float b, float theta, boolean isMoreThanHalf, boolean isPositiveArc) {
            double cy;
            double cx;
            double thetaD = Math.toRadians(theta);
            double cosTheta = Math.cos(thetaD);
            double sinTheta = Math.sin(thetaD);
            double x0p = ((double)x0 * cosTheta + (double)y0 * sinTheta) / (double)a;
            double y0p = ((double)(-x0) * sinTheta + (double)y0 * cosTheta) / (double)b;
            double x1p = ((double)x1 * cosTheta + (double)y1 * sinTheta) / (double)a;
            double y1p = ((double)(-x1) * sinTheta + (double)y1 * cosTheta) / (double)b;
            double dx = x0p - x1p;
            double dy = y0p - y1p;
            double xm = (x0p + x1p) / 2.0;
            double ym = (y0p + y1p) / 2.0;
            double dsq = dx * dx + dy * dy;
            if (dsq == 0.0) {
                return;
            }
            double disc = 1.0 / dsq - 0.25;
            if (disc < 0.0) {
                float adjust = (float)(Math.sqrt(dsq) / 1.99999);
                PathDataNode.drawArc(p, x0, y0, x1, y1, a * adjust, b * adjust, theta, isMoreThanHalf, isPositiveArc);
                return;
            }
            double s = Math.sqrt(disc);
            double sdx = s * dx;
            double sdy = s * dy;
            if (isMoreThanHalf == isPositiveArc) {
                cx = xm - sdy;
                cy = ym + sdx;
            } else {
                cx = xm + sdy;
                cy = ym - sdx;
            }
            double eta0 = Math.atan2(y0p - cy, x0p - cx);
            double eta1 = Math.atan2(y1p - cy, x1p - cx);
            double sweep = eta1 - eta0;
            if (isPositiveArc != sweep >= 0.0) {
                sweep = sweep > 0.0 ? (sweep -= Math.PI * 2) : (sweep += Math.PI * 2);
            }
            double tcx = cx *= (double)a;
            cx = cx * cosTheta - (cy *= (double)b) * sinTheta;
            cy = tcx * sinTheta + cy * cosTheta;
            PathDataNode.arcToBezier(p, cx, cy, a, b, x0, y0, thetaD, eta0, sweep);
        }

        private static void arcToBezier(Path p, double cx, double cy, double a, double b, double e1x, double e1y, double theta, double start, double sweep) {
            int numSegments = (int)Math.ceil(Math.abs(sweep * 4.0 / Math.PI));
            double eta1 = start;
            double cosTheta = Math.cos(theta);
            double sinTheta = Math.sin(theta);
            double cosEta1 = Math.cos(eta1);
            double sinEta1 = Math.sin(eta1);
            double ep1x = -a * cosTheta * sinEta1 - b * sinTheta * cosEta1;
            double ep1y = -a * sinTheta * sinEta1 + b * cosTheta * cosEta1;
            double anglePerSegment = sweep / (double)numSegments;
            for (int i = 0; i < numSegments; ++i) {
                double eta2 = eta1 + anglePerSegment;
                double sinEta2 = Math.sin(eta2);
                double cosEta2 = Math.cos(eta2);
                double e2x = cx + a * cosTheta * cosEta2 - b * sinTheta * sinEta2;
                double e2y = cy + a * sinTheta * cosEta2 + b * cosTheta * sinEta2;
                double ep2x = -a * cosTheta * sinEta2 - b * sinTheta * cosEta2;
                double ep2y = -a * sinTheta * sinEta2 + b * cosTheta * cosEta2;
                double tanDiff2 = Math.tan((eta2 - eta1) / 2.0);
                double alpha = Math.sin(eta2 - eta1) * (Math.sqrt(4.0 + 3.0 * tanDiff2 * tanDiff2) - 1.0) / 3.0;
                double q1x = e1x + alpha * ep1x;
                double q1y = e1y + alpha * ep1y;
                double q2x = e2x - alpha * ep2x;
                double q2y = e2y - alpha * ep2y;
                p.rLineTo(0.0f, 0.0f);
                p.cubicTo((float)q1x, (float)q1y, (float)q2x, (float)q2y, (float)e2x, (float)e2y);
                eta1 = eta2;
                e1x = e2x;
                e1y = e2y;
                ep1x = ep2x;
                ep1y = ep2y;
            }
        }
    }

    private static class ExtractFloatResult {
        int mEndPosition;
        boolean mEndWithNegOrDot;

        private ExtractFloatResult() {
        }
    }
}

