/*
 * Decompiled with CFR 0.152.
 */
package com.scottyab.rootbeer;

import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Build;
import com.scottyab.rootbeer.Const;
import com.scottyab.rootbeer.RootBeerNative;
import com.scottyab.rootbeer.util.QLog;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Scanner;

public class RootBeer {
    private final Context mContext;
    private boolean loggingEnabled = true;

    public RootBeer(Context context) {
        this.mContext = context;
    }

    public boolean isRooted() {
        return this.detectRootManagementApps() || this.detectPotentiallyDangerousApps() || this.checkForBinary("su") || this.checkForBinary("busybox") || this.checkForDangerousProps() || this.checkForRWPaths() || this.detectTestKeys() || this.checkSuExists() || this.checkForRootNative() || this.checkForMagiskBinary();
    }

    public boolean isRootedWithoutBusyBoxCheck() {
        return this.detectRootManagementApps() || this.detectPotentiallyDangerousApps() || this.checkForBinary("su") || this.checkForDangerousProps() || this.checkForRWPaths() || this.detectTestKeys() || this.checkSuExists() || this.checkForRootNative() || this.checkForMagiskBinary();
    }

    public boolean detectTestKeys() {
        String buildTags = Build.TAGS;
        return buildTags != null && buildTags.contains("test-keys");
    }

    public boolean detectRootManagementApps() {
        return this.detectRootManagementApps(null);
    }

    public boolean detectRootManagementApps(String[] additionalRootManagementApps) {
        ArrayList<String> packages = new ArrayList<String>();
        packages.addAll(Arrays.asList(Const.knownRootAppsPackages));
        if (additionalRootManagementApps != null && additionalRootManagementApps.length > 0) {
            packages.addAll(Arrays.asList(additionalRootManagementApps));
        }
        return this.isAnyPackageFromListInstalled(packages);
    }

    public boolean detectPotentiallyDangerousApps() {
        return this.detectPotentiallyDangerousApps(null);
    }

    public boolean detectPotentiallyDangerousApps(String[] additionalDangerousApps) {
        ArrayList<String> packages = new ArrayList<String>();
        packages.addAll(Arrays.asList(Const.knownDangerousAppsPackages));
        if (additionalDangerousApps != null && additionalDangerousApps.length > 0) {
            packages.addAll(Arrays.asList(additionalDangerousApps));
        }
        return this.isAnyPackageFromListInstalled(packages);
    }

    public boolean detectRootCloakingApps() {
        return this.detectRootCloakingApps(null) || this.canLoadNativeLibrary() && !this.checkForNativeLibraryReadAccess();
    }

    public boolean detectRootCloakingApps(String[] additionalRootCloakingApps) {
        ArrayList<String> packages = new ArrayList<String>();
        packages.addAll(Arrays.asList(Const.knownRootCloakingPackages));
        if (additionalRootCloakingApps != null && additionalRootCloakingApps.length > 0) {
            packages.addAll(Arrays.asList(additionalRootCloakingApps));
        }
        return this.isAnyPackageFromListInstalled(packages);
    }

    public boolean checkForSuBinary() {
        return this.checkForBinary("su");
    }

    public boolean checkForMagiskBinary() {
        return this.checkForBinary("magisk");
    }

    public boolean checkForBusyBoxBinary() {
        return this.checkForBinary("busybox");
    }

    public boolean checkForBinary(String filename) {
        String[] pathsArray = Const.suPaths;
        boolean result = false;
        for (String path : pathsArray) {
            String completePath = path + filename;
            File f = new File(path, filename);
            boolean fileExists = f.exists();
            if (!fileExists) continue;
            QLog.v(completePath + " binary detected!");
            result = true;
        }
        return result;
    }

    public void setLogging(boolean logging) {
        this.loggingEnabled = logging;
        QLog.LOGGING_LEVEL = logging ? 5 : 0;
    }

    private String[] propsReader() {
        try {
            InputStream inputstream = Runtime.getRuntime().exec("getprop").getInputStream();
            if (inputstream == null) {
                return null;
            }
            String propVal = new Scanner(inputstream).useDelimiter("\\A").next();
            return propVal.split("\n");
        }
        catch (IOException | NoSuchElementException e) {
            e.printStackTrace();
            return null;
        }
    }

    private String[] mountReader() {
        try {
            InputStream inputstream = Runtime.getRuntime().exec("mount").getInputStream();
            if (inputstream == null) {
                return null;
            }
            String propVal = new Scanner(inputstream).useDelimiter("\\A").next();
            return propVal.split("\n");
        }
        catch (IOException | NoSuchElementException e) {
            e.printStackTrace();
            return null;
        }
    }

    private boolean isAnyPackageFromListInstalled(List<String> packages) {
        boolean result = false;
        PackageManager pm = this.mContext.getPackageManager();
        for (String packageName : packages) {
            try {
                pm.getPackageInfo(packageName, 0);
                QLog.e(packageName + " ROOT management app detected!");
                result = true;
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {}
        }
        return result;
    }

    public boolean checkForDangerousProps() {
        HashMap<String, String> dangerousProps = new HashMap<String, String>();
        dangerousProps.put("ro.debuggable", "1");
        dangerousProps.put("ro.secure", "0");
        boolean result = false;
        String[] lines = this.propsReader();
        if (lines == null) {
            return result;
        }
        for (String line : lines) {
            for (String key : dangerousProps.keySet()) {
                if (!line.contains(key)) continue;
                String badValue = (String)dangerousProps.get(key);
                badValue = "[" + badValue + "]";
                if (!line.contains(badValue)) continue;
                QLog.v(key + " = " + badValue + " detected!");
                result = true;
            }
        }
        return result;
    }

    public boolean checkForRWPaths() {
        boolean result = false;
        String[] lines = this.mountReader();
        if (lines == null) {
            return result;
        }
        for (String line : lines) {
            String[] args = line.split(" ");
            if (args.length < 4) {
                QLog.e("Error formatting mount line: " + line);
                continue;
            }
            String mountPoint = args[1];
            String mountOptions = args[3];
            block1: for (String pathToCheck : Const.pathsThatShouldNotBeWrtiable) {
                if (!mountPoint.equalsIgnoreCase(pathToCheck)) continue;
                for (String option : mountOptions.split(",")) {
                    if (!option.equalsIgnoreCase("rw")) continue;
                    QLog.v(pathToCheck + " path is mounted with rw permissions! " + line);
                    result = true;
                    continue block1;
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkSuExists() {
        Process process = null;
        try {
            process = Runtime.getRuntime().exec(new String[]{"which", "su"});
            BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));
            boolean bl = in.readLine() != null;
            return bl;
        }
        catch (Throwable t) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (process != null) {
                process.destroy();
            }
        }
    }

    public boolean checkForNativeLibraryReadAccess() {
        RootBeerNative rootBeerNative = new RootBeerNative();
        try {
            rootBeerNative.setLogDebugMessages(this.loggingEnabled);
            return true;
        }
        catch (UnsatisfiedLinkError e) {
            return false;
        }
    }

    public boolean canLoadNativeLibrary() {
        return new RootBeerNative().wasNativeLibraryLoaded();
    }

    public boolean checkForRootNative() {
        if (!this.canLoadNativeLibrary()) {
            QLog.e("We could not load the native library to test for root");
            return false;
        }
        String binaryName = "su";
        Object[] paths = new String[Const.suPaths.length];
        for (int i = 0; i < paths.length; ++i) {
            paths[i] = Const.suPaths[i] + binaryName;
        }
        RootBeerNative rootBeerNative = new RootBeerNative();
        try {
            rootBeerNative.setLogDebugMessages(this.loggingEnabled);
            return rootBeerNative.checkForRoot(paths) > 0;
        }
        catch (UnsatisfiedLinkError e) {
            return false;
        }
    }
}

