/*
 * Decompiled with CFR 0.152.
 */
package com.scottyab.rootbeer;

import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Build;
import com.scottyab.rootbeer.Const;
import com.scottyab.rootbeer.RootBeerNative;
import com.scottyab.rootbeer.util.QLog;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Scanner;

public class RootBeer {
    final Context mContext;

    public RootBeer(Context context) {
        this.mContext = context;
    }

    public boolean isRooted() {
        boolean rootManagement = this.detectRootManagementApps();
        boolean potentiallyDangerousApps = this.detectPotentiallyDangerousApps();
        boolean suBinary = this.checkForBinary("su");
        boolean busyboxBinary = this.checkForBinary("busybox");
        boolean dangerousProps = this.checkForDangerousProps();
        boolean rwSystem = this.checkForRWPaths();
        boolean testKeys = this.detectTestKeys();
        boolean testSuExists = this.checkSuExists();
        boolean testRootNative = this.checkForRootNative();
        boolean result = rootManagement || potentiallyDangerousApps || suBinary || busyboxBinary || dangerousProps || rwSystem || testKeys || testSuExists || testRootNative;
        return result;
    }

    public boolean detectTestKeys() {
        String buildTags = Build.TAGS;
        return buildTags != null && buildTags.contains("test-keys");
    }

    public boolean detectRootManagementApps() {
        return this.detectRootManagementApps(null);
    }

    public boolean detectRootManagementApps(String[] additionalRootManagementApps) {
        ArrayList<String> packages = new ArrayList<String>();
        packages.addAll(Arrays.asList(Const.knownRootAppsPackages));
        if (additionalRootManagementApps != null && additionalRootManagementApps.length > 0) {
            packages.addAll(Arrays.asList(additionalRootManagementApps));
        }
        return this.isAnyPackageFromListInstalled(packages);
    }

    public boolean detectPotentiallyDangerousApps() {
        return this.detectPotentiallyDangerousApps(null);
    }

    public boolean detectPotentiallyDangerousApps(String[] additionalDangerousApps) {
        ArrayList<String> packages = new ArrayList<String>();
        packages.addAll(Arrays.asList(Const.knownDangerousAppsPackages));
        if (additionalDangerousApps != null && additionalDangerousApps.length > 0) {
            packages.addAll(Arrays.asList(additionalDangerousApps));
        }
        return this.isAnyPackageFromListInstalled(packages);
    }

    public boolean detectRootCloakingApps() {
        return this.detectRootCloakingApps(null);
    }

    public boolean detectRootCloakingApps(String[] additionalRootCloakingApps) {
        ArrayList<String> packages = new ArrayList<String>();
        packages.addAll(Arrays.asList(Const.knownRootCloakingPackages));
        if (additionalRootCloakingApps != null && additionalRootCloakingApps.length > 0) {
            packages.addAll(Arrays.asList(additionalRootCloakingApps));
        }
        return this.isAnyPackageFromListInstalled(packages);
    }

    public boolean checkForSuBinary() {
        return this.checkForBinary("su");
    }

    public boolean checkForBusyBoxBinary() {
        return this.checkForBinary("busybox");
    }

    public boolean checkForBinary(String filename) {
        String[] pathsArray = Const.suPaths;
        boolean result = false;
        for (String path : pathsArray) {
            String completePath = path + filename;
            File f = new File(completePath);
            boolean fileExists = f.exists();
            if (!fileExists) continue;
            QLog.v(completePath + " binary detected!");
            result = true;
        }
        return result;
    }

    private String[] propsReader() {
        InputStream inputstream = null;
        try {
            inputstream = Runtime.getRuntime().exec("getprop").getInputStream();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String propval = "";
        try {
            propval = new Scanner(inputstream).useDelimiter("\\A").next();
        }
        catch (NoSuchElementException e) {
            QLog.e("Error getprop, NoSuchElementException: " + e.getMessage(), e);
        }
        return propval.split("\n");
    }

    private String[] mountReader() {
        InputStream inputstream = null;
        try {
            inputstream = Runtime.getRuntime().exec("mount").getInputStream();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (inputstream == null) {
            return null;
        }
        String propval = "";
        try {
            propval = new Scanner(inputstream).useDelimiter("\\A").next();
        }
        catch (NoSuchElementException e) {
            e.printStackTrace();
        }
        return propval.split("\n");
    }

    private boolean isAnyPackageFromListInstalled(List<String> packages) {
        boolean result = false;
        PackageManager pm = this.mContext.getPackageManager();
        for (String packageName : packages) {
            try {
                pm.getPackageInfo(packageName, 0);
                QLog.e(packageName + " ROOT management app detected!");
                result = true;
            }
            catch (PackageManager.NameNotFoundException e) {}
        }
        return result;
    }

    public boolean checkForDangerousProps() {
        String[] lines;
        HashMap<String, String> dangerousProps = new HashMap<String, String>();
        dangerousProps.put("ro.debuggable", "1");
        dangerousProps.put("ro.secure", "0");
        boolean result = false;
        for (String line : lines = this.propsReader()) {
            for (String key : dangerousProps.keySet()) {
                if (!line.contains(key)) continue;
                String badValue = (String)dangerousProps.get(key);
                badValue = "[" + badValue + "]";
                if (!line.contains(badValue)) continue;
                QLog.v(key + " = " + badValue + " detected!");
                result = true;
            }
        }
        return result;
    }

    public boolean checkForRWPaths() {
        String[] lines;
        boolean result = false;
        block0: for (String line : lines = this.mountReader()) {
            for (String pathToCheck : Const.pathsThatShouldNotBeWrtiable) {
                if (!line.contains(pathToCheck) || !line.contains(" rw,")) continue;
                QLog.v(pathToCheck + " path is mounted with rw permissions!");
                result = true;
                continue block0;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkSuExists() {
        Process process = null;
        try {
            process = Runtime.getRuntime().exec(new String[]{"/system/xbin/which", "su"});
            BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));
            if (in.readLine() != null) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Throwable t) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (process != null) {
                process.destroy();
            }
        }
    }

    public boolean checkForRootNative() {
        String binaryName = "su";
        Object[] paths = new String[Const.suPaths.length];
        for (int i = 0; i < paths.length; ++i) {
            paths[i] = Const.suPaths[i] + binaryName;
        }
        RootBeerNative rootBeerNative = new RootBeerNative();
        rootBeerNative.setLogDebugMessages(true);
        boolean nativeRoot = rootBeerNative.checkForRoot(paths) > 0;
        return nativeRoot;
    }
}

