/*
 * Decompiled with CFR 0.152.
 */
package com.scloudic.rabbitframework.core.springboot.configure;

import com.scloudic.rabbitframework.core.notification.NotificationServerManager;
import com.scloudic.rabbitframework.core.springboot.configure.RabbitCommonsProperties;
import com.scloudic.rabbitframework.core.utils.CommonResponseUrl;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={RabbitCommonsProperties.class})
public class RabbitCommonsAutoConfiguration {
    private final RabbitCommonsProperties rabbitCommonsProperties;

    public RabbitCommonsAutoConfiguration(RabbitCommonsProperties rabbitCommonsProperties) {
        this.rabbitCommonsProperties = rabbitCommonsProperties;
    }

    @Bean
    @ConditionalOnMissingBean
    public CommonResponseUrl commonResponseUrl() {
        CommonResponseUrl commonResponseUrl = new CommonResponseUrl();
        commonResponseUrl.setFrontBlack(this.rabbitCommonsProperties.isFrontBlack());
        commonResponseUrl.setLoginUrl(this.rabbitCommonsProperties.getLoginUrl());
        commonResponseUrl.setOtherError(this.rabbitCommonsProperties.getOtherError());
        commonResponseUrl.setSys404ErrorUrl(this.rabbitCommonsProperties.getSys404ErrorUrl());
        commonResponseUrl.setSys405ErrorUrl(this.rabbitCommonsProperties.getSys405ErrorUrl());
        commonResponseUrl.setSys500ErrorUrl(this.rabbitCommonsProperties.getSys500ErrorUrl());
        commonResponseUrl.setUnauthorizedUrl(this.rabbitCommonsProperties.getUnauthorizedUrl());
        commonResponseUrl.setPage404(this.rabbitCommonsProperties.isPage404());
        return commonResponseUrl;
    }

    @Bean(destroyMethod="release")
    @ConditionalOnMissingBean
    public NotificationServerManager notificationServerManager() {
        return new NotificationServerManager();
    }
}

