/*
 * Decompiled with CFR 0.152.
 */
package org.serversass.ast;

import java.util.ArrayList;
import java.util.List;
import org.serversass.Generator;
import org.serversass.Scope;
import org.serversass.ast.Expression;

public class ValueList
implements Expression {
    private List<Expression> elements = new ArrayList<Expression>();
    private boolean keepCommas = false;

    public ValueList(boolean keepCommas) {
        this.keepCommas = keepCommas;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Expression expr : this.elements) {
            if (sb.length() > 0) {
                sb.append(this.keepCommas ? "," : " ");
            }
            sb.append(expr);
        }
        return sb.toString();
    }

    public void add(Expression element) {
        this.elements.add(element);
    }

    public List<Expression> getElements() {
        return this.elements;
    }

    @Override
    public boolean isConstant() {
        for (Expression expr : this.elements) {
            if (expr.isConstant()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Expression eval(Scope scope, Generator gen) {
        ValueList result = new ValueList(this.keepCommas);
        for (Expression expr : this.elements) {
            result.elements.add(expr.eval(scope, gen));
        }
        return result;
    }
}

