/*
 * Decompiled with CFR 0.152.
 */
package org.serversass.ast;

import java.util.ArrayList;
import java.util.List;
import org.serversass.ast.Mixin;
import org.serversass.ast.Section;
import org.serversass.ast.Variable;

public class Stylesheet {
    private String name;
    private List<Variable> variables = new ArrayList<Variable>();
    private List<Mixin> mixins = new ArrayList<Mixin>();
    private List<Section> sections = new ArrayList<Section>();
    private List<String> imports = new ArrayList<String>();

    public Stylesheet(String name) {
        this.name = name;
    }

    public void addImport(String name) {
        this.imports.add(name);
    }

    public void addVariable(Variable variable) {
        this.variables.add(variable);
    }

    public void addSection(Section section) {
        this.sections.add(section);
    }

    public void addMixin(Mixin mixin) {
        this.mixins.add(mixin);
    }

    public List<Variable> getVariables() {
        return this.variables;
    }

    public List<Mixin> getMixins() {
        return this.mixins;
    }

    public List<Section> getSections() {
        return this.sections;
    }

    public List<String> getImports() {
        return this.imports;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Variable var : this.variables) {
            sb.append(var);
            sb.append(";\n");
        }
        for (Section s : this.sections) {
            sb.append("\n");
            sb.append(s);
        }
        return sb.toString();
    }
}

