/*
 * Decompiled with CFR 0.152.
 */
package org.serversass.ast;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.serversass.Generator;
import org.serversass.Output;
import org.serversass.Scope;
import org.serversass.ast.Attribute;
import org.serversass.ast.Expression;
import org.serversass.ast.MixinReference;

public class Section {
    private List<List<String>> selectors = new ArrayList<List<String>>();
    private List<Expression> mediaQueries = new ArrayList<Expression>();
    private List<String> extendedSections = new ArrayList<String>();
    private List<Attribute> attributes = new ArrayList<Attribute>();
    private List<Section> subSections = new ArrayList<Section>();
    private List<MixinReference> references = new ArrayList<MixinReference>();

    public List<List<String>> getSelectors() {
        return this.selectors;
    }

    public void addAttribute(Attribute attr) {
        this.attributes.add(attr);
    }

    public void addMediaQuery(Expression query) {
        this.mediaQueries.add(query);
    }

    public void addSubSection(Section section) {
        this.subSections.add(section);
    }

    public void addExtends(String name) {
        this.extendedSections.add(name);
    }

    public void addMixinReference(MixinReference ref) {
        this.references.add(ref);
    }

    public List<String> getExtendedSections() {
        return this.extendedSections;
    }

    public List<Attribute> getAttributes() {
        return this.attributes;
    }

    public List<Section> getSubSections() {
        return this.subSections;
    }

    public List<MixinReference> getReferences() {
        return this.references;
    }

    public String getMediaQuery(Scope scope, Generator gen) {
        StringBuilder sb = new StringBuilder();
        for (Expression expr : this.mediaQueries) {
            if (sb.length() > 0) {
                sb.append(" and ");
            }
            sb.append(expr.eval(scope, gen));
        }
        return sb.toString();
    }

    public String getSelectorString() {
        StringBuilder sb = new StringBuilder();
        for (List<String> selector : this.selectors) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            for (String s : selector) {
                if (sb.length() > 0) {
                    sb.append(" ");
                }
                sb.append(s);
            }
        }
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getSelectorString());
        sb.append(" {\n");
        for (Attribute attr : this.attributes) {
            sb.append(" ");
            sb.append(attr);
            sb.append("\n");
        }
        for (Section child : this.subSections) {
            sb.append(child);
            sb.append("\n");
        }
        sb.append("}");
        return sb.toString();
    }

    public void generate(Output out) throws IOException {
        out.output(this.getSelectorString());
        out.output(" {");
        out.incIndent();
        for (Attribute attr : this.attributes) {
            out.optionalLineBreak();
            out.output(attr);
        }
        for (Section child : this.subSections) {
            out.lineBreak();
            child.generate(out);
        }
        out.decIndent();
        out.optionalLineBreak();
        out.output("}");
    }
}

