/*
 * Decompiled with CFR 0.152.
 */
package org.serversass.ast;

import java.util.Locale;
import org.serversass.Generator;
import org.serversass.Scope;
import org.serversass.ast.Expression;
import org.serversass.ast.Number;
import org.serversass.ast.Value;

public class Operation
implements Expression {
    private String op;
    private Expression left;
    private Expression right;
    private boolean protect = false;

    public Operation(String operation, Expression left, Expression right) {
        this.op = operation;
        this.left = left;
        this.right = right;
    }

    public void protect() {
        this.protect = true;
    }

    public String getOperation() {
        return this.op;
    }

    public boolean isProtect() {
        return this.protect;
    }

    public Expression getLeft() {
        return this.left;
    }

    public Expression getRight() {
        return this.right;
    }

    public void setRight(Expression right) {
        this.right = right;
    }

    public String toString() {
        return (this.protect ? "(" : "") + this.left + " " + this.op + " " + this.right + (this.protect ? ")" : "");
    }

    @Override
    public boolean isConstant() {
        return this.left.isConstant() && this.right.isConstant();
    }

    @Override
    public Expression eval(Scope scope, Generator gen) {
        Expression newLeft = this.left.eval(scope, gen);
        Expression newRight = this.right.eval(scope, gen);
        if (newLeft instanceof Number && newRight instanceof Number) {
            return this.evalNumbers(gen, (Number)newLeft, (Number)newRight);
        }
        return new Value(newLeft.toString() + newRight.toString());
    }

    protected Expression evalNumbers(Generator gen, Number l, Number r) {
        double rounded;
        double lVal = l.getNumericValue();
        String lUnit = l.getUnit();
        if ("%".equals(lUnit)) {
            lVal /= 100.0;
            lUnit = "";
        }
        double rVal = r.getNumericValue();
        String rUnit = r.getUnit();
        if ("%".equals(rUnit)) {
            rVal /= 100.0;
            rUnit = "";
        }
        double value = this.evalOperation(gen, lVal, rVal);
        String unit = "";
        if (!"/".equals(this.op)) {
            if (this.isPercentResult(l, r)) {
                value *= 100.0;
                unit = "%";
            } else {
                unit = this.determineResultUnit(gen, lUnit, rUnit);
            }
        }
        if (Math.abs(value - (rounded = (double)Math.round(value))) > 0.009) {
            return new Number(value, String.format(Locale.ENGLISH, "%1.2f", value), unit);
        }
        return new Number(value, String.valueOf(Math.round(value)), unit);
    }

    private boolean isPercentResult(Number l, Number r) {
        if ("%".equals(l.getUnit()) && "%".equals(r.getUnit())) {
            return true;
        }
        if ("%".equals(l.getUnit()) || "%".equals(r.getUnit())) {
            if (l.getUnit() != null && l.getUnit().isEmpty()) {
                return true;
            }
            if (r.getUnit() != null && r.getUnit().isEmpty()) {
                return true;
            }
        }
        return false;
    }

    private String determineResultUnit(Generator gen, String lUnit, String rUnit) {
        if (lUnit != null && lUnit.isEmpty()) {
            return rUnit;
        }
        if (rUnit != null && !rUnit.isEmpty() && !rUnit.equals(lUnit)) {
            gen.warn(String.format("Incompatible units mixed in expression '%s': Using left unit for result", this));
        }
        return lUnit;
    }

    protected double evalOperation(Generator gen, double lVal, double rVal) {
        double value = 0.0;
        if ("/".equals(this.op)) {
            if (rVal != 0.0) {
                value = lVal / rVal;
            } else {
                gen.warn(String.format("Cannot evaluate: '%s': division by 0. Defaulting to 0 as result", this));
            }
        } else if ("*".equals(this.op)) {
            value = lVal * rVal;
        } else if ("%".equals(this.op)) {
            value = lVal % rVal;
        } else if ("+".equals(this.op)) {
            value = lVal + rVal;
        } else if ("-".equals(this.op)) {
            value = lVal - rVal;
        }
        return value;
    }
}

