/*
 * Decompiled with CFR 0.152.
 */
package org.serversass.ast;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.serversass.Generator;
import org.serversass.Scope;
import org.serversass.ast.Expression;

public class Number
implements Expression {
    private final String value;
    private final String unit;
    private static final Pattern NORMAL_NUMBER = Pattern.compile("(\\d+)([a-z]+|%)");
    private static final Pattern DECIMAL_NUMBER = Pattern.compile("(\\.\\d+|\\d+\\.\\d+)([a-z]+|%)");
    private final Double numericValue;

    public Number(double numericValue, String value, String unit) {
        this.numericValue = numericValue;
        this.value = value;
        this.unit = unit;
    }

    public Number(String value) {
        this.numericValue = null;
        Matcher m = NORMAL_NUMBER.matcher(value);
        if (m.matches()) {
            this.value = m.group(1);
            this.unit = m.group(2);
        } else {
            m = DECIMAL_NUMBER.matcher(value);
            if (m.matches()) {
                this.value = m.group(1);
                this.unit = m.group(2);
            } else {
                this.value = value;
                this.unit = "";
            }
        }
    }

    public String getValue() {
        return this.value;
    }

    public String getUnit() {
        return this.unit;
    }

    public double getNumericValue() {
        if (this.numericValue != null) {
            return this.numericValue;
        }
        return Double.parseDouble(this.value);
    }

    public String toString() {
        return this.value + this.unit;
    }

    @Override
    public boolean isConstant() {
        return true;
    }

    @Override
    public Expression eval(Scope scope, Generator gen) {
        return this;
    }
}

