/*
 * Decompiled with CFR 0.152.
 */
package org.serversass.ast;

import org.serversass.Generator;
import org.serversass.Scope;
import org.serversass.ast.Expression;

public class NamedParameter
implements Expression {
    private String name;
    private Expression value;

    public NamedParameter(String name, Expression value) {
        this.name = name;
        this.value = value;
    }

    public String toString() {
        if (this.name != null) {
            return this.name + " = " + this.value.toString();
        }
        return this.value.toString();
    }

    @Override
    public boolean isConstant() {
        return this.value.isConstant();
    }

    @Override
    public Expression eval(Scope scope, Generator gen) {
        if (this.isConstant()) {
            return this;
        }
        return new NamedParameter(this.name, this.value.eval(scope, gen));
    }
}

