/*
 * Decompiled with CFR 0.152.
 */
package org.serversass.ast;

import java.util.ArrayList;
import java.util.List;
import org.serversass.Generator;
import org.serversass.Scope;
import org.serversass.ast.Color;
import org.serversass.ast.Expression;

public class FunctionCall
implements Expression {
    private String name;
    private List<Expression> parameters = new ArrayList<Expression>();

    public String getName() {
        return this.name;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        FunctionCall.appendNameAndParameters(sb, this.name, this.parameters);
        return sb.toString();
    }

    protected static void appendNameAndParameters(StringBuilder sb, String name, List<Expression> parameters) {
        sb.append(name);
        sb.append("(");
        boolean first = true;
        for (Expression expr : parameters) {
            if (!first) {
                sb.append(", ");
            }
            first = false;
            sb.append(expr);
        }
        sb.append(")");
    }

    public void setName(String name) {
        this.name = name;
    }

    public void addParameter(Expression expression) {
        this.parameters.add(expression);
    }

    public List<Expression> getParameters() {
        return this.parameters;
    }

    public Expression getExpectedParam(int index) {
        if (this.parameters.size() <= index) {
            throw new IllegalArgumentException("Parameter index out of bounds: " + index + ". Function call: " + this);
        }
        return this.parameters.get(index);
    }

    public Color getExpectedColorParam(int index) {
        Expression expr = this.getExpectedParam(index);
        if (!(expr instanceof Color)) {
            throw new IllegalArgumentException("Parameter " + index + " isn't a color. Function call: " + this);
        }
        return (Color)expr;
    }

    public int getExpectedIntParam(int index) {
        return Integer.parseInt(this.getExpectedParam(index).toString().replace("%", ""));
    }

    public float getExpectedFloatParam(int index) {
        return Float.parseFloat(this.getExpectedParam(index).toString());
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    @Override
    public Expression eval(Scope scope, Generator gen) {
        if ("calc".equals(this.name)) {
            return this;
        }
        FunctionCall call = new FunctionCall();
        call.setName(this.name);
        for (Expression expr : this.parameters) {
            call.addParameter(expr.eval(scope, gen));
        }
        return gen.evaluateFunction(call);
    }
}

