/*
 * Decompiled with CFR 0.152.
 */
package org.serversass.ast;

import java.text.NumberFormat;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.serversass.Generator;
import org.serversass.Scope;
import org.serversass.ast.Expression;

public class Color
implements Expression {
    public static final double EPSILON = 0.001;
    private int r = 0;
    private int g = 0;
    private int b = 0;
    private float a = 1.0f;
    private static final Pattern RGB_HEX_PATTERN = Pattern.compile("#?([\\da-fA-F]{2})([\\da-fA-F]{2})([\\da-fA-F]{2})");
    private static final Pattern SHORT_RGB_HEX_PATTERN = Pattern.compile("#?([\\da-fA-F])([\\da-fA-F])([\\da-fA-F])");

    public Color(String hexString) {
        Matcher m = RGB_HEX_PATTERN.matcher(hexString);
        if (m.matches()) {
            this.r = Integer.parseInt(m.group(1).toLowerCase(), 16);
            this.g = Integer.parseInt(m.group(2).toLowerCase(), 16);
            this.b = Integer.parseInt(m.group(3).toLowerCase(), 16);
            return;
        }
        m = SHORT_RGB_HEX_PATTERN.matcher(hexString);
        if (!m.matches()) {
            throw new IllegalArgumentException("Cannot parse '" + hexString + "' as hex color. Expected a pattern like #FF00FF");
        }
        this.r = Integer.parseInt(m.group(1).toLowerCase() + m.group(1).toLowerCase(), 16);
        this.g = Integer.parseInt(m.group(2).toLowerCase() + m.group(2).toLowerCase(), 16);
        this.b = Integer.parseInt(m.group(3).toLowerCase() + m.group(3).toLowerCase(), 16);
    }

    public Color(int r, int g, int b) {
        this.r = r;
        this.g = g;
        this.b = b;
    }

    public Color(int r, int g, int b, float a) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = Math.max(0.0f, Math.min(1.0f, a));
    }

    public Color(int hue, double saturation, double lightness, float transparency) {
        this.a = transparency;
        if (saturation < 0.001) {
            this.r = (int)Math.round(255.0 * lightness);
            this.g = (int)Math.round(255.0 * lightness);
            this.b = (int)Math.round(255.0 * lightness);
            return;
        }
        double temporary1 = lightness < 0.5 ? lightness * (1.0 + saturation) : lightness + saturation - lightness * saturation;
        double temporary2 = 2.0 * lightness - temporary1;
        double h = (double)hue / 360.0;
        double temporaryR = this.fixRange(h + 0.3333333333333333);
        double temporaryG = this.fixRange(h);
        double temporaryB = this.fixRange(h - 0.3333333333333333);
        this.r = (int)Math.round(255.0 * this.computeColorChannel(temporary1, temporary2, temporaryR));
        this.g = (int)Math.round(255.0 * this.computeColorChannel(temporary1, temporary2, temporaryG));
        this.b = (int)Math.round(255.0 * this.computeColorChannel(temporary1, temporary2, temporaryB));
    }

    @Override
    public boolean isConstant() {
        return true;
    }

    @Override
    public Expression eval(Scope scope, Generator gen) {
        return this;
    }

    public HSL getHSL() {
        double red = (double)this.r / 255.0;
        double green = (double)this.g / 255.0;
        double blue = (double)this.b / 255.0;
        double min = Math.min(red, Math.min(green, blue));
        double max = Math.max(red, Math.max(green, blue));
        double delta = max - min;
        double l = (min + max) / 2.0;
        double s = 0.0;
        if (Math.abs(delta) > 0.001) {
            s = l < 0.5 ? delta / (max + min) : delta / (2.0 - max - min);
        }
        double h = 0.0;
        if (delta > 0.0) {
            h = red == max ? (green - blue) / delta : (green == max ? (blue - red) / delta + 2.0 : (red - green) / delta + 4.0);
        }
        return new HSL((int)Math.round(h *= 60.0), s, l);
    }

    public int getR() {
        return this.r;
    }

    public int getG() {
        return this.g;
    }

    public int getB() {
        return this.b;
    }

    public float getA() {
        return this.a;
    }

    private double computeColorChannel(double temporary1, double temporary2, double temporaryColor) {
        if (temporaryColor < 0.16666666666666666) {
            return temporary2 + (temporary1 - temporary2) * 6.0 * temporaryColor;
        }
        if (temporaryColor < 0.5) {
            return temporary1;
        }
        if (temporaryColor < 0.6666666666666666) {
            return temporary2 + (temporary1 - temporary2) * (0.6666666666666666 - temporaryColor) * 6.0;
        }
        return temporary2;
    }

    private double fixRange(double valueBetween0And1) {
        double fixedValue;
        for (fixedValue = valueBetween0And1; fixedValue < 0.0; fixedValue += 1.0) {
        }
        while (fixedValue > 1.0) {
            fixedValue -= 1.0;
        }
        return fixedValue;
    }

    public String toString() {
        if ((double)(this.a - 1.0f) > 0.001 || (double)(this.a - 1.0f) < -0.001) {
            NumberFormat alphaNumberFormat = NumberFormat.getNumberInstance(Locale.ENGLISH);
            alphaNumberFormat.setMaximumFractionDigits(3);
            return "rgba(" + this.r + "," + this.g + "," + this.b + "," + alphaNumberFormat.format(this.a) + ")";
        }
        String result = "#" + this.paddedHex(this.r) + this.paddedHex(this.g) + this.paddedHex(this.b);
        if (this.canBeExpressedAs3DigitHex(result)) {
            return this.computeThreeDigitHex(result);
        }
        return result;
    }

    private String computeThreeDigitHex(String result) {
        return "#" + result.charAt(1) + result.charAt(3) + result.charAt(5);
    }

    private boolean canBeExpressedAs3DigitHex(String result) {
        return result.charAt(1) == result.charAt(2) && result.charAt(3) == result.charAt(4) && result.charAt(5) == result.charAt(6);
    }

    private String paddedHex(int value) {
        String result = Integer.toHexString(value);
        if (result.length() == 1) {
            return "0" + result;
        }
        return result;
    }

    public class HSL {
        private int h;
        private double s;
        private double l;

        private HSL(int h, double s, double l) {
            this.setH(h);
            this.setS(s);
            this.setL(l);
        }

        public void setH(int h) {
            this.h = h;
            while (this.h < 0) {
                this.h += 360;
            }
            while (this.h > 360) {
                this.h -= 360;
            }
        }

        public void setS(double s) {
            this.s = Color.this.fixRange(s);
        }

        public void setL(double l) {
            this.l = Color.this.fixRange(l);
        }

        public int getH() {
            return this.h;
        }

        public double getS() {
            return this.s;
        }

        public double getL() {
            return this.l;
        }

        public Color getColor() {
            return new Color(this.h, this.s, this.l, Color.this.a);
        }
    }
}

