/*
 * Decompiled with CFR 0.152.
 */
package org.serversass;

import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.serversass.ast.Attribute;
import org.serversass.ast.Color;
import org.serversass.ast.Expression;
import org.serversass.ast.FunctionCall;
import org.serversass.ast.MediaFilter;
import org.serversass.ast.Mixin;
import org.serversass.ast.MixinReference;
import org.serversass.ast.NamedParameter;
import org.serversass.ast.Number;
import org.serversass.ast.Operation;
import org.serversass.ast.Section;
import org.serversass.ast.Stylesheet;
import org.serversass.ast.Value;
import org.serversass.ast.ValueList;
import org.serversass.ast.Variable;
import org.serversass.ast.VariableReference;
import parsii.tokenizer.Char;
import parsii.tokenizer.ParseException;
import parsii.tokenizer.Position;
import parsii.tokenizer.Token;
import parsii.tokenizer.Tokenizer;

public class Parser {
    private static final String KEYWORD_IMPORT = "import";
    private static final String KEYWORD_MIXIN = "mixin";
    private static final String KEYWORD_INCLUDE = "include";
    private static final String KEYWORD_EXTEND = "extend";
    private static final String KEYWORD_MEDIA = "media";
    private final SassTokenizer tokenizer;
    private Stylesheet result;

    public Parser(String name, Reader input) {
        this.tokenizer = new SassTokenizer(input);
        this.result = new Stylesheet(name);
    }

    public Stylesheet parse() throws ParseException {
        while (this.tokenizer.more()) {
            if (((Token)this.tokenizer.current()).isKeyword(new String[]{KEYWORD_IMPORT})) {
                this.parseImport();
                continue;
            }
            if (((Token)this.tokenizer.current()).isKeyword(new String[]{KEYWORD_MIXIN})) {
                Mixin mixin = this.parseMixin();
                if (mixin.getName() == null) continue;
                this.result.addMixin(mixin);
                continue;
            }
            if (((Token)this.tokenizer.current()).isKeyword(new String[]{KEYWORD_MEDIA})) {
                this.result.addSection(this.parseSection(true));
                continue;
            }
            if (((Token)this.tokenizer.current()).isSpecialIdentifier(new String[]{"$"}) && ((Token)this.tokenizer.next()).isSymbol(new String[]{":"})) {
                this.parseVariableDeclaration();
                continue;
            }
            this.result.addSection(this.parseSection(false));
        }
        if (!this.tokenizer.getProblemCollector().isEmpty()) {
            throw ParseException.create((List)this.tokenizer.getProblemCollector());
        }
        return this.result;
    }

    private Section parseSection(boolean mediaQuery) {
        Section section = new Section();
        this.parseSectionSelector(mediaQuery, section);
        this.tokenizer.consumeExpectedSymbol("{");
        while (this.tokenizer.more()) {
            if (((Token)this.tokenizer.current()).isSymbol(new String[]{"}"})) {
                this.tokenizer.consumeExpectedSymbol("}");
                return section;
            }
            if (this.isAtAttribute()) {
                Attribute attr = this.parseAttribute();
                section.addAttribute(attr);
                continue;
            }
            if (((Token)this.tokenizer.current()).isKeyword(new String[]{KEYWORD_MEDIA})) {
                section.addSubSection(this.parseSection(true));
                continue;
            }
            if (((Token)this.tokenizer.current()).isKeyword(new String[]{KEYWORD_INCLUDE})) {
                this.parseInclude(section);
                continue;
            }
            if (((Token)this.tokenizer.current()).isKeyword(new String[]{KEYWORD_EXTEND})) {
                this.parseExtend(section);
                continue;
            }
            section.addSubSection(this.parseSection(false));
        }
        this.tokenizer.consumeExpectedSymbol("}");
        return section;
    }

    private boolean isAtAttribute() {
        if (!((Token)this.tokenizer.current()).isIdentifier(new String[0]) || !((Token)this.tokenizer.next()).isSymbol(new String[]{":"})) {
            return false;
        }
        int i = 2;
        Token next;
        while (!(next = (Token)this.tokenizer.next(i)).isEnd() && !next.isSymbol(new String[]{";"})) {
            if (next.isSymbol(new String[]{"{"})) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void parseExtend(Section result) {
        this.tokenizer.consumeExpectedKeyword(KEYWORD_EXTEND);
        if (((Token)this.tokenizer.current()).isIdentifier(new String[0]) || ((Token)this.tokenizer.current()).isSpecialIdentifier(new String[]{"#"})) {
            result.addExtends(((Token)this.tokenizer.consume()).getSource());
        } else {
            this.tokenizer.addError((Position)this.tokenizer.current(), "Unexpected token: '" + ((Token)this.tokenizer.current()).getSource() + "'. Expected a selector to include.", new Object[0]);
        }
        if (((Token)this.tokenizer.current()).isSymbol(new String[]{";"}) || !((Token)this.tokenizer.next()).isSymbol(new String[]{"}"})) {
            this.tokenizer.consumeExpectedSymbol(";");
        }
    }

    private void parseInclude(Section result) {
        this.tokenizer.consumeExpectedKeyword(KEYWORD_INCLUDE);
        MixinReference ref = new MixinReference();
        if (((Token)this.tokenizer.current()).isIdentifier(new String[0])) {
            ref.setName(((Token)this.tokenizer.consume()).getContents());
        } else {
            this.tokenizer.addError((Position)this.tokenizer.current(), "Unexpected token: '" + ((Token)this.tokenizer.current()).getSource() + "'. Expected a mixin to use", new Object[0]);
        }
        if (((Token)this.tokenizer.current()).isSymbol(new String[]{"("})) {
            this.tokenizer.consumeExpectedSymbol("(");
            while (this.tokenizer.more() && !((Token)this.tokenizer.current()).isSymbol(new String[]{")", ";", "{", "}"})) {
                ref.addParameter(this.parseExpression(false));
                this.consumeExpectedComma();
            }
            this.tokenizer.consumeExpectedSymbol(")");
        }
        if (((Token)this.tokenizer.current()).isSymbol(new String[]{";"}) || !((Token)this.tokenizer.next()).isSymbol(new String[]{"}"})) {
            this.tokenizer.consumeExpectedSymbol(";");
        }
        if (ref.getName() != null) {
            result.addMixinReference(ref);
        }
    }

    private void parseSectionSelector(boolean mediaQuery, Section result) {
        if (mediaQuery) {
            this.parseMediaQuerySelector(result);
        } else {
            while (this.tokenizer.more()) {
                List<String> selector = this.parseSelector();
                result.getSelectors().add(selector);
                if (!((Token)this.tokenizer.current()).isSymbol(new String[]{","})) break;
                this.tokenizer.consumeExpectedSymbol(",");
            }
        }
    }

    private void parseMediaQuerySelector(Section result) {
        this.tokenizer.consumeExpectedKeyword(KEYWORD_MEDIA);
        while (true) {
            if (((Token)this.tokenizer.current()).isIdentifier(new String[0])) {
                result.addMediaQuery(new Value(((Token)this.tokenizer.consume()).getContents()));
            } else if (((Token)this.tokenizer.current()).isSymbol(new String[]{"("})) {
                this.parseMediaQueryFilters(result);
            } else {
                return;
            }
            if (!((Token)this.tokenizer.current()).isIdentifier(new String[]{"and"})) {
                return;
            }
            this.tokenizer.consume();
        }
    }

    private void parseMediaQueryFilters(Section result) {
        this.tokenizer.consumeExpectedSymbol("(");
        if (((Token)this.tokenizer.current()).isIdentifier(new String[0]) && ((Token)this.tokenizer.next()).isSymbol(new String[]{":"})) {
            this.parseMediaQueryFilter(result);
            while (((Token)this.tokenizer.next()).hasContent("and")) {
                this.tokenizer.consumeExpectedSymbol(")");
                this.tokenizer.consume();
                this.tokenizer.consumeExpectedSymbol("(");
                this.parseMediaQueryFilter(result);
            }
        } else {
            this.tokenizer.addError((Position)this.tokenizer.current(), "Unexpected symbol: '%s'. Expected an attribute filter.", new Object[]{((Token)this.tokenizer.current()).getSource()});
        }
        this.tokenizer.consumeExpectedSymbol(")");
    }

    private void parseMediaQueryFilter(Section result) {
        MediaFilter attr = new MediaFilter(((Token)this.tokenizer.consume()).getContents());
        this.tokenizer.consumeExpectedSymbol(":");
        attr.setExpression(this.parseExpression(true));
        result.addMediaQuery(attr);
    }

    private Attribute parseAttribute() {
        Attribute attr = new Attribute(((Token)this.tokenizer.consume()).getContents());
        this.tokenizer.consumeExpectedSymbol(":");
        attr.setExpression(this.parseExpression(true));
        if (((Token)this.tokenizer.current()).isSymbol(new String[]{";"}) || !((Token)this.tokenizer.next()).isSymbol(new String[]{"}"})) {
            this.tokenizer.consumeExpectedSymbol(";");
        }
        return attr;
    }

    private List<String> parseSelector() {
        ArrayList<String> selector = new ArrayList<String>();
        this.parseSelectorPrefix(selector);
        while (this.tokenizer.more()) {
            if (((Token)this.tokenizer.current()).isSymbol(new String[]{"{", ","})) {
                if (selector.isEmpty()) {
                    this.tokenizer.addError((Position)this.tokenizer.current(), "Unexpected end of CSS selector", new Object[0]);
                }
                return selector;
            }
            if (((Token)this.tokenizer.current()).isIdentifier(new String[0]) || ((Token)this.tokenizer.current()).isSpecialIdentifier(new String[]{"#", "@"}) || ((Token)this.tokenizer.current()).isNumber()) {
                StringBuilder sb = new StringBuilder(((Token)this.tokenizer.consume()).getSource());
                this.parseFilterInSelector(sb);
                this.parseOperatorInSelector(sb);
                selector.add(sb.toString());
                continue;
            }
            if (((Token)this.tokenizer.current()).isSymbol(new String[]{"&"}) || ((Token)this.tokenizer.current()).isSymbol(new String[]{"*"})) {
                selector.add(((Token)this.tokenizer.consume()).getTrigger());
                continue;
            }
            if (((Token)this.tokenizer.current()).isSymbol(new String[]{">", "+", "~"})) {
                selector.add(((Token)this.tokenizer.consume()).getSource());
                continue;
            }
            this.tokenizer.addError((Position)this.tokenizer.current(), "Unexpected Token: %s", new Object[]{((Token)this.tokenizer.consume()).getSource()});
        }
        return selector;
    }

    private void parseSelectorPrefix(List<String> selector) {
        if (this.tokenizer.more() && ((Token)this.tokenizer.current()).isSymbol(new String[]{"["})) {
            StringBuilder sb = new StringBuilder();
            this.parseFilterInSelector(sb);
            this.parseOperatorInSelector(sb);
            selector.add(sb.toString());
        }
        if (this.tokenizer.more() && ((Token)this.tokenizer.current()).isSymbol(new String[]{"&"})) {
            selector.add(((Token)this.tokenizer.consume()).getTrigger());
        }
        if (this.tokenizer.more() && ((Token)this.tokenizer.current()).isSymbol(new String[]{"&:"})) {
            this.tokenizer.consume();
            if (((Token)this.tokenizer.current()).is(Token.TokenType.ID)) {
                selector.add("&");
                selector.add(":" + ((Token)this.tokenizer.consume()).getContents());
            }
        }
        if (this.tokenizer.more() && ((Token)this.tokenizer.current()).isSymbol(new String[]{"&::"})) {
            this.tokenizer.consume();
            if (((Token)this.tokenizer.current()).is(Token.TokenType.ID)) {
                selector.add("&");
                selector.add("::" + ((Token)this.tokenizer.consume()).getContents());
            }
        }
        if (this.tokenizer.more() && ((Token)this.tokenizer.current()).isSymbol(new String[]{"::"}) && ((Token)this.tokenizer.next()).is(Token.TokenType.ID)) {
            this.tokenizer.consume();
            selector.add("::" + ((Token)this.tokenizer.consume()).getContents());
        }
    }

    private void parseOperatorInSelector(StringBuilder sb) {
        while (((Token)this.tokenizer.current()).isSymbol(new String[]{":"}) || ((Token)this.tokenizer.current()).isSymbol(new String[]{"::"})) {
            sb.append(((Token)this.tokenizer.consume()).getSource());
            sb.append(((Token)this.tokenizer.consume()).getSource());
            if (!((Token)this.tokenizer.current()).isSymbol(new String[]{"("})) continue;
            this.consumeArgument(sb);
        }
    }

    private void consumeArgument(StringBuilder sb) {
        sb.append(((Token)this.tokenizer.consume()).getSource());
        int braces = 1;
        while (!((Token)this.tokenizer.current()).isEnd() && braces > 0) {
            if (((Token)this.tokenizer.current()).isSymbol(new String[]{"("})) {
                ++braces;
            }
            if (((Token)this.tokenizer.current()).isSymbol(new String[]{")"})) {
                --braces;
            }
            sb.append(((Token)this.tokenizer.consume()).getSource());
        }
    }

    private void parseFilterInSelector(StringBuilder sb) {
        while (((Token)this.tokenizer.current()).isSymbol(new String[]{"["})) {
            sb.append(((Token)this.tokenizer.consume()).getContents());
            this.readAttributeName(sb);
            this.readOperator(sb);
            this.readValue(sb);
            this.readClosingBracket(sb);
        }
    }

    private void readClosingBracket(StringBuilder sb) {
        if (!((Token)this.tokenizer.current()).isSymbol(new String[]{"]"})) {
            this.tokenizer.addError((Position)this.tokenizer.current(), "Unexpected token: '%s'. Expected: ']'", new Object[]{((Token)this.tokenizer.current()).getSource()});
        } else {
            sb.append(((Token)this.tokenizer.consume()).getContents());
        }
    }

    private void readValue(StringBuilder sb) {
        if (!((Token)this.tokenizer.current()).isSymbol(new String[]{"]"})) {
            sb.append(((Token)this.tokenizer.consume()).getSource());
        }
    }

    private void readOperator(StringBuilder sb) {
        if (!((Token)this.tokenizer.current()).isSymbol(new String[]{"]"})) {
            if (!((Token)this.tokenizer.current()).isSymbol(new String[]{"=", "~=", "|=", "^=", "$=", "*="})) {
                this.tokenizer.addError((Position)this.tokenizer.current(), "Unexpected token: '%s'. Expected an operation.", new Object[]{((Token)this.tokenizer.current()).getSource()});
            }
            sb.append(((Token)this.tokenizer.consume()).getTrigger());
        }
    }

    private void readAttributeName(StringBuilder sb) {
        if (!((Token)this.tokenizer.current()).isSymbol(new String[]{"]"})) {
            if (!((Token)this.tokenizer.current()).isIdentifier(new String[0])) {
                this.tokenizer.addError((Position)this.tokenizer.current(), "Unexpected token: '%s'. Expected an attribute name.", new Object[]{((Token)this.tokenizer.current()).getSource()});
            }
            sb.append(((Token)this.tokenizer.consume()).getContents());
        }
    }

    private void parseVariableDeclaration() {
        Variable var = new Variable();
        var.setName(((Token)this.tokenizer.consume()).getContents());
        this.tokenizer.consumeExpectedSymbol(":");
        var.setValue(this.parseExpression(true));
        if (((Token)this.tokenizer.current()).isSymbol(new String[]{"!"}) && ((Token)this.tokenizer.next()).hasContent("default")) {
            var.setDefaultValue(true);
            this.tokenizer.consume();
            this.tokenizer.consume();
        }
        this.result.addVariable(var);
        this.tokenizer.consumeExpectedSymbol(";");
    }

    private Expression parseExpression(boolean acceptLists) {
        Expression expression;
        Expression expression2 = expression = acceptLists ? this.parseAtomList() : this.parseAtom();
        while (this.tokenizer.more()) {
            if (((Token)this.tokenizer.current()).isSymbol(new String[]{"+", "-"})) {
                expression = new Operation(((Token)this.tokenizer.consume()).getTrigger(), expression, this.parseAtom());
                continue;
            }
            if (((Token)this.tokenizer.current()).isSymbol(new String[]{"*", "/", "%"})) {
                String operation = ((Token)this.tokenizer.consume()).getTrigger();
                Expression next = this.parseAtom();
                expression = this.joinOperations(expression, operation, next);
                continue;
            }
            if (((Token)this.tokenizer.current()).isSymbol(new String[0]) && !((Token)this.tokenizer.current()).isSymbol(new String[]{"!"})) break;
            ValueList list = new ValueList(false);
            list.add(expression);
            list.add(acceptLists ? this.parseAtomList() : this.parseAtom());
            expression = list;
        }
        return expression;
    }

    private Expression joinOperations(Expression result, String operation, Expression next) {
        if (!(result instanceof Operation)) {
            return new Operation(operation, result, next);
        }
        Operation farRight = (Operation)result;
        while (farRight.getRight() instanceof Operation) {
            farRight = (Operation)farRight.getRight();
        }
        if (!farRight.isProtect() && ("+".equals(farRight.getOperation()) || "-".equals(farRight.getOperation()))) {
            farRight.setRight(new Operation(operation, farRight.getRight(), next));
            return result;
        }
        return new Operation(operation, result, next);
    }

    private Expression parseAtomList() {
        Expression exp = this.parseAtom();
        if (!((Token)this.tokenizer.current()).isSymbol(new String[]{","})) {
            return exp;
        }
        ValueList atomList = new ValueList(true);
        atomList.add(exp);
        while (((Token)this.tokenizer.current()).isSymbol(new String[]{","})) {
            this.tokenizer.consume();
            atomList.add(this.parseAtom());
        }
        return atomList;
    }

    private Expression parseAtom() {
        if (((Token)this.tokenizer.current()).isNumber()) {
            return new Number(((Token)this.tokenizer.consume()).getContents());
        }
        if (((Token)this.tokenizer.current()).isSpecialIdentifier(new String[]{"#"})) {
            return new Color(((Token)this.tokenizer.consume()).getSource());
        }
        if (((Token)this.tokenizer.current()).isIdentifier(new String[0]) || ((Token)this.tokenizer.current()).isString()) {
            return this.parseIdentifierOrFunctionCall();
        }
        if (((Token)this.tokenizer.current()).isSpecialIdentifier(new String[]{"$"})) {
            return new VariableReference(((Token)this.tokenizer.consume()).getContents());
        }
        if (((Token)this.tokenizer.current()).isSymbol(new String[]{"("})) {
            this.tokenizer.consumeExpectedSymbol("(");
            Expression expression = this.parseExpression(true);
            this.tokenizer.consumeExpectedSymbol(")");
            if (expression instanceof Operation) {
                ((Operation)expression).protect();
            }
            return expression;
        }
        if (((Token)this.tokenizer.current()).isSymbol(new String[]{"!"}) && ((Token)this.tokenizer.next()).isIdentifier(new String[0])) {
            this.tokenizer.consumeExpectedSymbol("!");
            return new Value("!" + ((Token)this.tokenizer.consume()).getContents());
        }
        this.tokenizer.addError((Position)this.tokenizer.current(), "Unexpected token: '" + ((Token)this.tokenizer.consume()).getSource() + "'. Expected an expression.", new Object[0]);
        return new Value("");
    }

    private Expression parseIdentifierOrFunctionCall() {
        StringBuilder id = new StringBuilder();
        while (((Token)this.tokenizer.current()).isIdentifier(new String[0]) && ((Token)this.tokenizer.next()).isSymbol(new String[]{":"})) {
            id.append(((Token)this.tokenizer.consume()).getSource()).append(":");
            this.tokenizer.consume();
        }
        id.append(((Token)this.tokenizer.consume()).getSource());
        if (((Token)this.tokenizer.current()).isSymbol(new String[]{"("})) {
            FunctionCall fun = new FunctionCall();
            fun.setName(id.toString());
            this.tokenizer.consumeExpectedSymbol("(");
            while (this.tokenizer.more() && !((Token)this.tokenizer.current()).isSymbol(new String[]{")", ";", "{", "}"})) {
                if (((Token)this.tokenizer.current()).isIdentifier(new String[0]) && ((Token)this.tokenizer.next()).isSymbol(new String[]{"="})) {
                    String name = ((Token)this.tokenizer.consume()).getContents();
                    this.tokenizer.consume();
                    fun.addParameter(new NamedParameter(name, this.parseExpression(false)));
                } else {
                    fun.addParameter(this.parseExpression(false));
                }
                this.consumeExpectedComma();
            }
            this.tokenizer.consumeExpectedSymbol(")");
            return fun;
        }
        return new Value(id.toString());
    }

    private void consumeExpectedComma() {
        if (((Token)this.tokenizer.current()).isSymbol(new String[]{","})) {
            this.tokenizer.consumeExpectedSymbol(",");
        } else if (!((Token)this.tokenizer.current()).isSymbol(new String[]{")"})) {
            this.tokenizer.addError((Position)this.tokenizer.current(), "Unexpected token: '" + ((Token)this.tokenizer.consume()).getSource() + "'. Expected a comma between the parameters.", new Object[0]);
        }
    }

    private Mixin parseMixin() {
        this.tokenizer.consumeExpectedKeyword(KEYWORD_MIXIN);
        Mixin mixin = new Mixin();
        this.parseName(mixin);
        this.parseParameterNames(mixin);
        this.parseMixinAttributes(mixin);
        return mixin;
    }

    private void parseName(Mixin mixin) {
        if (((Token)this.tokenizer.current()).isIdentifier(new String[0])) {
            mixin.setName(((Token)this.tokenizer.consume()).getContents());
        } else {
            this.tokenizer.addError((Position)this.tokenizer.current(), "Unexpected token: '" + ((Token)this.tokenizer.current()).getSource() + "'. Expected the name of the mixin as identifier.", new Object[0]);
        }
    }

    private void parseMixinAttributes(Mixin mixin) {
        this.tokenizer.consumeExpectedSymbol("{");
        while (this.tokenizer.more()) {
            if (((Token)this.tokenizer.current()).isSymbol(new String[]{"}"})) {
                this.tokenizer.consumeExpectedSymbol("}");
                return;
            }
            if (this.isAtAttribute()) {
                Attribute attr = this.parseAttribute();
                mixin.addAttribute(attr);
                continue;
            }
            this.parseMixinSubSection(mixin);
        }
        this.tokenizer.consumeExpectedSymbol("}");
    }

    private void parseMixinSubSection(Mixin mixin) {
        Section subSection = new Section();
        this.parseSectionSelector(false, subSection);
        this.tokenizer.consumeExpectedSymbol("{");
        while (this.tokenizer.more() && !((Token)this.tokenizer.current()).isSymbol(new String[]{"}"})) {
            if (((Token)this.tokenizer.current()).isIdentifier(new String[0]) && ((Token)this.tokenizer.next()).isSymbol(new String[]{":"})) {
                Attribute attr = this.parseAttribute();
                subSection.addAttribute(attr);
                continue;
            }
            this.tokenizer.addError((Position)this.tokenizer.current(), "Unexpected token: '" + ((Token)this.tokenizer.current()).getSource() + "'. Expected an attribute definition", new Object[0]);
            this.tokenizer.consume();
        }
        this.tokenizer.consumeExpectedSymbol("}");
        mixin.addSubSection(subSection);
    }

    private void parseParameterNames(Mixin mixin) {
        this.tokenizer.consumeExpectedSymbol("(");
        while (this.tokenizer.more()) {
            if (((Token)this.tokenizer.current()).isSymbol(new String[]{"{"})) {
                this.tokenizer.addError((Position)this.tokenizer.current(), "Unexpected token: '" + ((Token)this.tokenizer.current()).getSource() + "'. Expected ')' to complete the parameter list.", new Object[0]);
                return;
            }
            if (((Token)this.tokenizer.current()).isSymbol(new String[]{")"})) {
                this.tokenizer.consumeExpectedSymbol(")");
                return;
            }
            if (((Token)this.tokenizer.current()).isSpecialIdentifier(new String[]{"$"})) {
                mixin.addParameter(((Token)this.tokenizer.consume()).getContents());
            } else {
                this.tokenizer.addError((Position)this.tokenizer.current(), "Unexpected token: '" + ((Token)this.tokenizer.consume()).getSource() + "'. Expected a parameter name like $parameter.", new Object[0]);
            }
            if (((Token)this.tokenizer.current()).isSymbol(new String[]{","})) {
                this.tokenizer.consumeExpectedSymbol(",");
                continue;
            }
            if (((Token)this.tokenizer.current()).isSymbol(new String[]{")"})) continue;
            this.tokenizer.addError((Position)this.tokenizer.current(), "Unexpected token: '" + ((Token)this.tokenizer.consume()).getSource() + "'. Expected a comma between the parameter names.", new Object[0]);
        }
    }

    private void parseImport() {
        this.tokenizer.consumeExpectedKeyword(KEYWORD_IMPORT);
        if (!((Token)this.tokenizer.current()).isString()) {
            this.tokenizer.addError((Position)this.tokenizer.current(), "Unexpected token: '" + ((Token)this.tokenizer.current()).getSource() + "'. Expected a string constant naming an import file.", new Object[0]);
        } else {
            this.result.addImport(((Token)this.tokenizer.consume()).getContents());
        }
        this.tokenizer.consumeExpectedSymbol(";");
    }

    static class SassTokenizer
    extends Tokenizer {
        SassTokenizer(Reader input) {
            super(input);
            this.setLineComment("//");
            this.setBlockCommentStart("/*");
            this.setBlockCommentEnd("*/");
            this.addSpecialIdStarter('@');
            this.addSpecialIdStarter('$');
            this.addSpecialIdStarter('#');
            this.addKeyword(Parser.KEYWORD_IMPORT);
            this.addKeyword(Parser.KEYWORD_MIXIN);
            this.addKeyword(Parser.KEYWORD_INCLUDE);
            this.addKeyword(Parser.KEYWORD_EXTEND);
            this.addKeyword(Parser.KEYWORD_MEDIA);
            this.addStringDelimiter('\'', '\'');
        }

        protected Token fetchNumber() {
            Token token = super.fetchNumber();
            if (((Char)this.input.current()).is(new char[]{'%'})) {
                token.addToContent((Char)this.input.consume());
                return token;
            }
            while (((Char)this.input.current()).isLetter()) {
                token.addToContent((Char)this.input.consume());
            }
            return token;
        }

        protected boolean handleStringEscape(char separator, char escapeChar, Token stringToken) {
            stringToken.addToContent((Char)this.input.consume());
            return true;
        }

        protected boolean isAtBracket(boolean inSymbol) {
            return super.isAtBracket(inSymbol) || ((Char)this.input.current()).is(new char[]{'%'});
        }

        protected boolean isAtStartOfIdentifier() {
            if (super.isAtStartOfIdentifier()) {
                return true;
            }
            return (((Char)this.input.current()).is(new char[]{'-'}) || ((Char)this.input.current()).is(new char[]{'.'})) && ((Char)this.input.next()).isLetter();
        }

        protected boolean isIdentifierChar(Char current) {
            if (super.isIdentifierChar(current)) {
                return true;
            }
            return (current.is(new char[]{'-'}) || current.is(new char[]{'.'}) || current.is(new char[]{'#'})) && !((Char)this.input.next()).isWhitepace();
        }

        protected boolean isSymbolCharacter(Char ch) {
            return super.isSymbolCharacter(ch) && !ch.is(new char[]{'#'});
        }

        protected Token fetchSymbol() {
            Token result = Token.create((Token.TokenType)Token.TokenType.SYMBOL, (Position)((Position)this.input.current()));
            result.addToTrigger((Char)this.input.consume());
            while (this.isSymbolCharacter((Char)this.input.current()) && !((Char)this.input.current()).is(new char[]{','})) {
                result.addToTrigger((Char)this.input.consume());
            }
            return result;
        }
    }
}

