/*
 * Decompiled with CFR 0.152.
 */
package org.serversass;

import java.io.IOException;
import java.io.Writer;

public class Output {
    protected int indentLevel = 0;
    protected String indentDepth = "    ";
    protected Writer writer;
    protected boolean skipOptionalOutput;

    public Output(Writer writer, boolean skipOptionalOutput) {
        this.writer = writer;
        this.skipOptionalOutput = skipOptionalOutput;
    }

    public Output output(Object value) throws IOException {
        if (value != null) {
            this.writer.write(value.toString());
        }
        return this;
    }

    public Output optionalLineBreak() throws IOException {
        if (this.skipOptionalOutput) {
            this.writer.write(" ");
        } else {
            this.writer.write("\n");
            for (int i = 0; i < this.indentLevel; ++i) {
                this.writer.write(this.indentDepth);
            }
        }
        return this;
    }

    public Output lineBreak() throws IOException {
        this.writer.write("\n");
        if (!this.skipOptionalOutput) {
            for (int i = 0; i < this.indentLevel; ++i) {
                this.writer.write(this.indentDepth);
            }
        }
        return this;
    }

    public Output incIndent() {
        ++this.indentLevel;
        return this;
    }

    public Output decIndent() {
        --this.indentLevel;
        return this;
    }

    public String toString() {
        return this.writer.toString();
    }
}

