/*
 * Decompiled with CFR 0.152.
 */
package org.serversass;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.serversass.Functions;
import org.serversass.Output;
import org.serversass.Parser;
import org.serversass.Scope;
import org.serversass.ast.Attribute;
import org.serversass.ast.Expression;
import org.serversass.ast.FunctionCall;
import org.serversass.ast.Mixin;
import org.serversass.ast.MixinReference;
import org.serversass.ast.Section;
import org.serversass.ast.Stylesheet;
import org.serversass.ast.Value;
import org.serversass.ast.Variable;
import parsii.tokenizer.ParseException;

public class Generator {
    protected Set<String> importedSheets = new TreeSet<String>();
    protected List<Section> sections = new ArrayList<Section>();
    protected Map<String, Section> extensibleSections = new HashMap<String, Section>();
    protected Map<String, Section> mediaQueries = new LinkedHashMap<String, Section>();
    protected Map<String, Mixin> mixins = new HashMap<String, Mixin>();
    protected Scope scope = new Scope();
    protected File baseDir;

    public Generator() {
    }

    public Generator(File baseDir) {
        this.baseDir = baseDir;
    }

    public void warn(String message) {
    }

    public void debug(String message) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Stylesheet resolve(String sheet) {
        try {
            sheet = sheet.replace("\\", "/");
            if (!sheet.endsWith(".scss")) {
                sheet = sheet + ".scss";
            }
            try (InputStream is = this.resolveIntoStream(sheet);){
                if (is == null) {
                    this.warn("Cannot resolve '" + sheet + "'. Skipping import.");
                    Stylesheet stylesheet2 = null;
                    return stylesheet2;
                }
                Parser p = new Parser(sheet, new InputStreamReader(is));
                Stylesheet stylesheet = p.parse();
                return stylesheet;
            }
        }
        catch (ParseException e) {
            this.warn(String.format("Error parsing: %s%n%s", sheet, e.toString()));
            return null;
        }
        catch (Exception e) {
            this.warn(String.format("Error importing: %s: %s (%s)", sheet, e.getMessage(), e.getClass().getName()));
        }
        return null;
    }

    protected InputStream resolveIntoStream(String sheet) throws IOException {
        if (this.baseDir != null) {
            File file = this.baseDir;
            for (String part : sheet.split("/")) {
                file = new File(file, part);
            }
            if (file.exists() && file.isFile()) {
                return new FileInputStream(file);
            }
            return null;
        }
        InputStream is = this.getClass().getResourceAsStream((sheet.startsWith("/") ? "" : "/") + sheet);
        if (is == null) {
            is = this.getClass().getResourceAsStream((sheet.startsWith("/") ? "" : "/") + "_" + sheet);
        }
        return is;
    }

    public void importStylesheet(String sheet) {
        if (this.importedSheets.contains(sheet)) {
            return;
        }
        this.importStylesheet(this.resolve(sheet));
    }

    public void importStylesheet(Stylesheet sheet) {
        if (sheet == null) {
            return;
        }
        if (this.importedSheets.contains(sheet.getName())) {
            return;
        }
        this.importedSheets.add(sheet.getName());
        for (String imp : sheet.getImports()) {
            this.importStylesheet(imp);
        }
        for (Mixin mix : sheet.getMixins()) {
            this.mixins.put(mix.getName(), mix);
        }
        for (Variable var : sheet.getVariables()) {
            if (!this.scope.has(var.getName()) || !var.isDefaultValue()) {
                this.scope.set(var.getName(), var.getValue());
                continue;
            }
            this.debug("Skipping redundant variable definition: '" + var + "'");
        }
        for (Section section : sheet.getSections()) {
            ArrayList<Section> stack = new ArrayList<Section>();
            this.expand(null, section, stack);
        }
    }

    private void expand(String mediaQueryPath, Section section, List<Section> stack) {
        stack = new ArrayList<Section>(stack);
        if (!section.getSelectors().isEmpty()) {
            this.expandSection(mediaQueryPath, section, stack);
        } else {
            mediaQueryPath = this.expandMediaQuery(mediaQueryPath, section, stack);
        }
        if (section.getSelectorString() != null && !section.getSelectorString().startsWith("@")) {
            for (Section child : section.getSubSections()) {
                this.expand(mediaQueryPath, child, stack);
            }
            section.getSubSections().clear();
        }
    }

    private String expandMediaQuery(String mediaQueryPath, Section section, List<Section> stack) {
        mediaQueryPath = this.expandMediaQueryPath(mediaQueryPath, section);
        if (!section.getAttributes().isEmpty()) {
            this.transfertImplicitAttributes(mediaQueryPath, section, stack);
        }
        return mediaQueryPath;
    }

    private void transfertImplicitAttributes(String mediaQueryPath, Section section, List<Section> stack) {
        Section copy = new Section();
        if (!stack.isEmpty()) {
            Section parent = stack.get(stack.size() - 1);
            if (copy.getSelectors().isEmpty()) {
                copy.getSelectors().addAll(parent.getSelectors());
            } else if (!parent.getSelectors().isEmpty()) {
                for (List<String> selector : copy.getSelectors()) {
                    selector.addAll(0, (Collection<String>)parent.getSelectors().get(0));
                }
            }
        }
        if (copy.getSelectors().isEmpty()) {
            this.warn(String.format("Cannot define attributes in @media selector '%s'", section.getMediaQuery(this.scope, this)));
        } else {
            copy.getAttributes().addAll(section.getAttributes());
            this.addResultSection(mediaQueryPath, copy);
        }
    }

    private String expandMediaQueryPath(String mediaQueryPath, Section section) {
        mediaQueryPath = mediaQueryPath == null ? "@media " + section.getMediaQuery(this.scope, this) : mediaQueryPath + " and " + section.getMediaQuery(this.scope, this);
        return mediaQueryPath;
    }

    private void expandSection(String mediaQueryPath, Section section, List<Section> stack) {
        if (mediaQueryPath == null) {
            this.sections.add(section);
        } else {
            this.addResultSection(mediaQueryPath, section);
        }
        ArrayList<List<String>> newSelectors = new ArrayList<List<String>>();
        for (List<String> selector : section.getSelectors()) {
            if (stack.isEmpty()) {
                newSelectors.add(this.expandSelector(section, selector, null));
                continue;
            }
            for (List<String> parentSelector : stack.get(stack.size() - 1).getSelectors()) {
                newSelectors.add(this.expandSelector(section, new ArrayList<String>(selector), parentSelector));
            }
        }
        section.getSelectors().clear();
        section.getSelectors().addAll(newSelectors);
        stack.add(section);
    }

    private List<String> expandSelector(Section section, List<String> selector, List<String> parentSelector) {
        if (parentSelector != null) {
            if (selector.size() > 1 && !parentSelector.isEmpty() && "&".equals(selector.get(0))) {
                this.combineSelectors(selector, parentSelector);
            } else if ("&".equals(selector.get(selector.size() - 1))) {
                selector.remove(selector.size() - 1);
                selector.addAll(parentSelector);
            } else {
                selector.addAll(0, parentSelector);
            }
        }
        if (selector.size() == 1) {
            this.extensibleSections.put(selector.get(0), section);
        }
        return selector;
    }

    private void combineSelectors(List<String> selector, List<String> parentSelectors) {
        String firstChild = selector.get(1);
        selector.remove(0);
        selector.remove(0);
        ArrayList<String> selectorsToAdd = new ArrayList<String>(parentSelectors);
        String lastParent = (String)selectorsToAdd.get(selectorsToAdd.size() - 1);
        selectorsToAdd.remove(selectorsToAdd.size() - 1);
        selector.add(0, lastParent + firstChild);
        selector.addAll(0, selectorsToAdd);
    }

    private void addResultSection(String mediaQueryPath, Section section) {
        Section qry = this.mediaQueries.get(mediaQueryPath);
        if (qry == null) {
            qry = new Section();
            qry.getSelectors().add(Collections.singletonList(mediaQueryPath));
            this.mediaQueries.put(mediaQueryPath, qry);
        }
        qry.addSubSection(section);
    }

    public void compile() {
        this.sections.addAll(this.mediaQueries.values());
        for (Section section2 : new ArrayList<Section>(this.sections)) {
            for (String extend : section2.getExtendedSections()) {
                Section toBeExtended = this.extensibleSections.get(extend);
                if (toBeExtended != null) {
                    toBeExtended.getSelectors().addAll(section2.getSelectors());
                    continue;
                }
                this.warn(String.format("Skipping unknown @extend '%s' referenced by selector '%s'", extend, section2.getSelectorString()));
            }
            this.compileMixins(section2);
            for (Attribute attr : section2.getAttributes()) {
                attr.setExpression(attr.getExpression().eval(this.scope, this));
            }
        }
        this.sections.removeIf(section -> section.getSubSections().isEmpty() && section.getAttributes().isEmpty());
    }

    protected void compileMixins(Section section) {
        for (MixinReference ref : section.getReferences()) {
            Scope subScope = new Scope(this.scope);
            Mixin mixin = this.mixins.get(ref.getName());
            if (mixin == null) {
                this.warn(String.format("Skipping unknown @mixin '%s' referenced by selector '%s'", ref.getName(), section.getSelectorString()));
                return;
            }
            this.compileMixin(section, ref, subScope, mixin);
        }
    }

    private void compileMixin(Section section, MixinReference ref, Scope subScope, Mixin mixin) {
        if (mixin.getParameters().size() != ref.getParameters().size()) {
            this.warn(String.format("@mixin call '%s' by selector '%s' does not match expected number of parameters. Found: %d, expected: %d", ref.getName(), section.getSelectorString(), ref.getParameters().size(), mixin.getParameters().size()));
        }
        this.evaluateParameters(ref, subScope, mixin);
        this.copyAndEvaluateAttributes(section, subScope, mixin);
        for (Section child : mixin.getSubSections()) {
            this.processSubSection(section, subScope, child);
        }
    }

    private void processSubSection(Section section, Scope subScope, Section child) {
        Section newCombination = new Section();
        for (List<String> outer : child.getSelectors()) {
            for (List<String> inner : section.getSelectors()) {
                ArrayList<String> fullSelector = new ArrayList<String>(outer);
                if ("&".equals(outer.get(outer.size() - 1))) {
                    fullSelector.remove(fullSelector.size() - 1);
                    fullSelector.addAll(inner);
                } else if ("&".equals(outer.get(0))) {
                    this.combineSelectors(fullSelector, inner);
                } else {
                    fullSelector.addAll(0, inner);
                }
                newCombination.getSelectors().add(fullSelector);
            }
        }
        for (Attribute attr : child.getAttributes()) {
            Attribute copy = new Attribute(attr.getName());
            copy.setExpression(attr.getExpression().eval(subScope, this));
            newCombination.addAttribute(copy);
        }
        this.sections.add(newCombination);
    }

    private void copyAndEvaluateAttributes(Section section, Scope subScope, Mixin mixin) {
        for (Attribute attr : mixin.getAttributes()) {
            if (attr.getExpression().isConstant()) {
                section.addAttribute(attr);
                continue;
            }
            Attribute copy = new Attribute(attr.getName());
            copy.setExpression(attr.getExpression().eval(subScope, this));
            section.addAttribute(copy);
        }
    }

    private void evaluateParameters(MixinReference ref, Scope subScope, Mixin mixin) {
        int i = 0;
        for (String name : mixin.getParameters()) {
            if (ref.getParameters().size() > i) {
                subScope.set(name, ref.getParameters().get(i));
            }
            ++i;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Section section : this.sections) {
            sb.append(section);
            sb.append("\n");
        }
        return sb.toString();
    }

    public void generate(Output out) throws IOException {
        for (Section section : this.sections) {
            section.generate(out);
            out.lineBreak();
            out.optionalLineBreak();
        }
    }

    public Expression evaluateFunction(FunctionCall call) {
        try {
            return (Expression)Functions.class.getDeclaredMethod(call.getName().toLowerCase().replaceAll("[^a-z0-9]", ""), Generator.class, FunctionCall.class).invoke(null, this, call);
        }
        catch (NoSuchMethodException ignored) {
            return new Value(call.toString());
        }
        catch (InvocationTargetException e) {
            this.warn("Cannot execute function: " + call + " - " + e.getCause().getMessage());
        }
        catch (Exception e) {
            this.warn("Cannot execute function: " + call + " - " + e.getMessage());
        }
        return new Value(call.toString());
    }
}

