/*
 * Decompiled with CFR 0.152.
 */
package org.serversass;

import org.serversass.Generator;
import org.serversass.ast.Color;
import org.serversass.ast.Expression;
import org.serversass.ast.FunctionCall;
import org.serversass.ast.Number;

public class Functions {
    private Functions() {
    }

    private static Expression changeLighteness(Color color, int changeInPercent) {
        Color.HSL hsl = color.getHSL();
        hsl.setL(Math.max(Math.min(hsl.getL() * (1.0 + (double)changeInPercent / 100.0), 1.0), 0.0));
        return hsl.getColor();
    }

    private static Expression changeSaturation(Color color, int changeInPercent) {
        Color.HSL hsl = color.getHSL();
        hsl.setS(Math.max(Math.min(hsl.getS() * (1.0 + (double)changeInPercent / 100.0), 1.0), 0.0));
        return hsl.getColor();
    }

    public static Expression rgb(Generator generator, FunctionCall input) {
        return new Color(input.getExpectedIntParam(0), input.getExpectedIntParam(1), input.getExpectedIntParam(2));
    }

    public static Expression rgba(Generator generator, FunctionCall input) {
        if (input.getParameters().size() == 4) {
            return new Color(input.getExpectedIntParam(0), input.getExpectedIntParam(1), input.getExpectedIntParam(2), input.getExpectedFloatParam(3));
        }
        if (input.getParameters().size() == 2) {
            Color color = input.getExpectedColorParam(0);
            float newA = input.getExpectedFloatParam(1);
            return new Color(color.getR(), color.getG(), color.getB(), newA);
        }
        throw new IllegalArgumentException("rgba must be called with either 2 or 4 parameters. Function call: " + input);
    }

    public static Expression adjusthue(Generator generator, FunctionCall input) {
        Color color = input.getExpectedColorParam(0);
        int changeInDegrees = input.getExpectedIntParam(1);
        Color.HSL hsl = color.getHSL();
        hsl.setH(hsl.getH() + changeInDegrees);
        return hsl.getColor();
    }

    public static Expression lighten(Generator generator, FunctionCall input) {
        Color color = input.getExpectedColorParam(0);
        int increase = input.getExpectedIntParam(1);
        return Functions.changeLighteness(color, increase);
    }

    public static Expression alpha(Generator generator, FunctionCall input) {
        Color color = input.getExpectedColorParam(0);
        return new Number(color.getA(), String.valueOf(color.getA()), "");
    }

    public static Expression opacity(Generator generator, FunctionCall input) {
        return Functions.alpha(generator, input);
    }

    public static Expression darken(Generator generator, FunctionCall input) {
        Color color = input.getExpectedColorParam(0);
        int decrease = input.getExpectedIntParam(1);
        return Functions.changeLighteness(color, -decrease);
    }

    public static Expression saturate(Generator generator, FunctionCall input) {
        Color color = input.getExpectedColorParam(0);
        int increase = input.getExpectedIntParam(1);
        return Functions.changeSaturation(color, increase);
    }

    public static Expression desaturate(Generator generator, FunctionCall input) {
        Color color = input.getExpectedColorParam(0);
        int decrease = input.getExpectedIntParam(1);
        return Functions.changeSaturation(color, -decrease);
    }

    public static Expression opacify(Generator generator, FunctionCall input) {
        Color color = input.getExpectedColorParam(0);
        float amount = input.getExpectedFloatParam(1);
        return new Color(color.getR(), color.getG(), color.getB(), color.getA() + amount);
    }

    public static Expression fade_in(Generator generator, FunctionCall input) {
        return Functions.opacify(generator, input);
    }

    public static Expression transparentize(Generator generator, FunctionCall input) {
        Color color = input.getExpectedColorParam(0);
        float amount = input.getExpectedFloatParam(1);
        return new Color(color.getR(), color.getG(), color.getB(), color.getA() - amount);
    }

    public static Expression fade_out(Generator generator, FunctionCall input) {
        return Functions.opacify(generator, input);
    }

    public static Expression mix(Generator generator, FunctionCall input) {
        Color color1 = input.getExpectedColorParam(0);
        Color color2 = input.getExpectedColorParam(1);
        float weight = input.getParameters().size() > 2 ? input.getExpectedFloatParam(2) : 0.5f;
        return new Color((int)Math.round((double)((float)color1.getR() * weight) + (double)color2.getR() * (1.0 - (double)weight)), (int)Math.round((double)((float)color1.getG() * weight) + (double)color2.getG() * (1.0 - (double)weight)), (int)Math.round((double)((float)color1.getB() * weight) + (double)color2.getB() * (1.0 - (double)weight)), (float)((double)(color1.getA() * weight) + (double)color2.getA() * (1.0 - (double)weight)));
    }
}

