/*
 * Made with all the love in the world
 * by scireum in Remshalden, Germany
 *
 * Copyright by scireum GmbH
 * http://www.scireum.de - info@scireum.de
 */

package org.serversass.ast;

import java.util.ArrayList;
import java.util.List;

/**
 * Represents a reference to a mixin generated by an include instruction.
 */
public class MixinReference {

    private String name;
    private List<Expression> parameters = new ArrayList<>();

    /**
     * Returns the name of the referenced mixin
     *
     * @return the name of the mixin
     */
    public String getName() {
        return name;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("@include ");
        FunctionCall.appendNameAndParameters(sb, name, parameters);
        return sb.toString();
    }

    /**
     * Sets the name of the referenced mixin
     *
     * @param name the name of the mixin being referenced
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * Adds an expression as parameter
     *
     * @param expression the expression to add
     */
    public void addParameter(Expression expression) {
        parameters.add(expression);
    }

    /**
     * Returns all parameters
     *
     * @return a list of parameters used to call the mixin
     */
    public List<Expression> getParameters() {
        return parameters;
    }
}
