/*
 * Decompiled with CFR 0.152.
 */
package com.schibsted.spt.data.jslt.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.schibsted.spt.data.jslt.JsltException;
import com.schibsted.spt.data.jslt.impl.AbstractNode;
import com.schibsted.spt.data.jslt.impl.ExpressionNode;
import com.schibsted.spt.data.jslt.impl.Location;
import com.schibsted.spt.data.jslt.impl.NodeUtils;
import com.schibsted.spt.data.jslt.impl.Scope;
import java.util.ArrayList;
import java.util.List;

public class ArraySlicer
extends AbstractNode {
    private ExpressionNode left;
    private boolean colon;
    private ExpressionNode right;
    private ExpressionNode parent;

    public ArraySlicer(ExpressionNode left, boolean colon, ExpressionNode right, ExpressionNode parent, Location location) {
        super(location);
        this.left = left;
        this.colon = colon;
        this.right = right;
        this.parent = parent;
    }

    @Override
    public JsonNode apply(Scope scope, JsonNode input) {
        JsonNode sequence = this.parent.apply(scope, input);
        if (!sequence.isArray() && !sequence.isTextual()) {
            return NullNode.instance;
        }
        int size = sequence.size();
        if (sequence.isTextual()) {
            size = sequence.asText().length();
        }
        int leftix = this.resolveIndex(scope, this.left, input, size, 0);
        if (!this.colon) {
            if (sequence.isArray()) {
                JsonNode val = sequence.get(leftix);
                if (val == null) {
                    val = NullNode.instance;
                }
                return val;
            }
            String string = sequence.asText();
            if (leftix >= string.length()) {
                throw new JsltException("String index out of range: " + leftix, this.location);
            }
            return new TextNode("" + string.charAt(leftix));
        }
        int rightix = this.resolveIndex(scope, this.right, input, size, size);
        if (rightix > size) {
            rightix = size;
        }
        if (sequence.isArray()) {
            ArrayNode result = NodeUtils.mapper.createArrayNode();
            for (int ix = leftix; ix < rightix; ++ix) {
                result.add(sequence.get(ix));
            }
            return result;
        }
        String string = sequence.asText();
        return new TextNode(string.substring(leftix, rightix));
    }

    private int resolveIndex(Scope scope, ExpressionNode expr, JsonNode input, int size, int ifnull) {
        if (expr == null) {
            return ifnull;
        }
        JsonNode node = expr.apply(scope, input);
        if (!node.isNumber()) {
            throw new JsltException("Can't index array/string with " + node, this.location);
        }
        int ix = node.intValue();
        if (ix < 0) {
            ix = size + ix;
        }
        return ix;
    }

    @Override
    public List<ExpressionNode> getChildren() {
        ArrayList<ExpressionNode> children = new ArrayList<ExpressionNode>();
        children.add(this.parent);
        if (this.left != null) {
            children.add(this.left);
        }
        if (this.right != null) {
            children.add(this.right);
        }
        return children;
    }

    @Override
    public void dump(int level) {
        if (this.parent != null) {
            this.parent.dump(level);
        }
        System.out.println(NodeUtils.indent(level) + this);
    }

    public String toString() {
        return "[" + this.left + " : " + this.right + "]";
    }
}

