/*
 * Decompiled with CFR 0.152.
 */
package com.schibsted.spt.data.jslt.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.schibsted.spt.data.jslt.impl.AbstractNode;
import com.schibsted.spt.data.jslt.impl.ExpressionNode;
import com.schibsted.spt.data.jslt.impl.Location;
import com.schibsted.spt.data.jslt.impl.NodeUtils;
import com.schibsted.spt.data.jslt.impl.Scope;

public class DotExpression
extends AbstractNode {
    private String key;
    private ExpressionNode parent;

    public DotExpression(Location location) {
        super(location);
    }

    public DotExpression(String key, ExpressionNode parent, Location location) {
        super(location);
        this.key = key;
        this.parent = parent;
    }

    @Override
    public JsonNode apply(Scope scope, JsonNode input) {
        JsonNode value;
        if (this.key == null) {
            return input;
        }
        if (this.parent != null) {
            input = this.parent.apply(scope, input);
        }
        if ((value = input.get(this.key)) == null) {
            value = NullNode.instance;
        }
        return value;
    }

    @Override
    public void dump(int level) {
        System.out.println(NodeUtils.indent(level) + this);
    }

    public String toString() {
        String me = "." + (this.key == null ? "" : this.key);
        if (this.parent != null) {
            return "" + this.parent + me;
        }
        return me;
    }

    public void checkOk(Location matcher) {
        if (this.parent != null) {
            ((DotExpression)this.parent).checkOk(matcher);
        }
    }
}

