/*
 * Decompiled with CFR 0.152.
 */
package com.schibsted.spt.data.jslt.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.schibsted.spt.data.jslt.Function;
import com.schibsted.spt.data.jslt.impl.DotExpression;
import com.schibsted.spt.data.jslt.impl.ExpressionNode;
import com.schibsted.spt.data.jslt.impl.FailDotExpression;
import com.schibsted.spt.data.jslt.impl.LetExpression;
import com.schibsted.spt.data.jslt.impl.NodeUtils;
import com.schibsted.spt.data.jslt.impl.Scope;
import java.util.HashMap;

public class FunctionDeclaration
implements Function {
    private String name;
    private String[] parameters;
    private LetExpression[] lets;
    private ExpressionNode body;

    public FunctionDeclaration(String name, String[] parameters, LetExpression[] lets, ExpressionNode body) {
        this.name = name;
        this.parameters = parameters;
        this.lets = lets;
        this.body = body;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getMinArguments() {
        return this.parameters.length;
    }

    @Override
    public int getMaxArguments() {
        return this.parameters.length;
    }

    @Override
    public JsonNode call(JsonNode input, JsonNode[] arguments) {
        HashMap<String, JsonNode> params = new HashMap<String, JsonNode>(arguments.length);
        for (int ix = 0; ix < arguments.length; ++ix) {
            params.put(this.parameters[ix], arguments[ix]);
        }
        Scope scope = Scope.makeScope(params);
        if (this.lets.length > 0) {
            scope = NodeUtils.evalLets(scope, input, this.lets);
        }
        return this.body.apply(scope, input);
    }

    public void optimize() {
        for (int ix = 0; ix < this.lets.length; ++ix) {
            this.lets[ix].optimize();
        }
        this.body = this.body.optimize();
    }

    public void computeMatchContexts(DotExpression parent) {
        FailDotExpression fail = new FailDotExpression(null, "function declaration");
        for (int ix = 0; ix < this.lets.length; ++ix) {
            this.lets[ix].computeMatchContexts(fail);
        }
        this.body.computeMatchContexts(fail);
    }
}

