/*
 * Decompiled with CFR 0.152.
 */
package com.schibsted.spt.data.jslt.impl;

import com.schibsted.spt.data.jslt.Function;
import com.schibsted.spt.data.jslt.JsltException;
import com.schibsted.spt.data.jslt.ResourceResolver;
import com.schibsted.spt.data.jslt.impl.BuiltinFunctions;
import com.schibsted.spt.data.jslt.impl.ClasspathResourceResolver;
import com.schibsted.spt.data.jslt.impl.FunctionExpression;
import com.schibsted.spt.data.jslt.impl.Location;
import com.schibsted.spt.data.jslt.impl.Macro;
import com.schibsted.spt.data.jslt.impl.Module;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ParseContext {
    private Collection<Function> extensions;
    private Map<String, Function> functions;
    private String source;
    private Map<String, Module> modules;
    private Collection<FunctionExpression> funcalls;
    private ParseContext parent;
    private ResourceResolver resolver;

    public ParseContext(Collection<Function> extensions, String source, ResourceResolver resolver) {
        this.extensions = extensions;
        this.functions = new HashMap<String, Function>();
        for (Function func : extensions) {
            this.functions.put(func.getName(), func);
        }
        this.source = source;
        this.funcalls = new ArrayList<FunctionExpression>();
        this.modules = new HashMap<String, Module>();
        this.resolver = resolver;
    }

    public ParseContext(String source) {
        this(Collections.EMPTY_SET, source, new ClasspathResourceResolver());
    }

    public void setParent(ParseContext parent) {
        this.parent = parent;
    }

    public Function getFunction(String name) {
        Function func = this.functions.get(name);
        if (func == null) {
            func = BuiltinFunctions.functions.get(name);
        }
        return func;
    }

    public Macro getMacro(String name) {
        return BuiltinFunctions.macros.get(name);
    }

    public String getSource() {
        return this.source;
    }

    public Collection<Function> getExtensions() {
        return this.extensions;
    }

    public void addDeclaredFunction(String name, Function function) {
        this.functions.put(name, function);
    }

    public void rememberFunctionCall(FunctionExpression fun) {
        this.funcalls.add(fun);
    }

    public void resolveFunctions() {
        for (FunctionExpression fun : this.funcalls) {
            String name = fun.getFunctionName();
            Function f = this.getFunction(name);
            if (f == null) {
                throw new JsltException("No such function: '" + name + "'", fun.getLocation());
            }
            fun.resolve(f);
        }
    }

    public Map<String, Function> getDeclaredFunctions() {
        return this.functions;
    }

    public void registerModule(String prefix, Module module) {
        this.modules.put(prefix, module);
    }

    public boolean isAlreadyImported(String module) {
        if (this.source != null && module.equals(this.source)) {
            return true;
        }
        if (this.parent != null) {
            return this.parent.isAlreadyImported(module);
        }
        return false;
    }

    public Function getImportedFunction(String prefix, String name, Location loc) {
        Module m = this.modules.get(prefix);
        if (m == null) {
            throw new JsltException("No such module '" + prefix + "'", loc);
        }
        Function f = m.getFunction(name);
        if (f == null) {
            throw new JsltException("No such function '" + name + "' in module '" + prefix + "'", loc);
        }
        return f;
    }

    public ResourceResolver getResolver() {
        return this.resolver;
    }
}

