/*
 * Decompiled with CFR 0.152.
 */
package com.schibsted.spt.data.jslt.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.schibsted.spt.data.jslt.impl.DotExpression;
import com.schibsted.spt.data.jslt.impl.ExpressionNode;
import com.schibsted.spt.data.jslt.impl.Location;
import com.schibsted.spt.data.jslt.impl.Scope;

public class DotKeyAndParentExpression
extends DotExpression {
    private String key;
    private ExpressionNode parent;

    public DotKeyAndParentExpression(String key, ExpressionNode parent, Location location) {
        super(location);
        this.key = key;
        this.parent = parent;
    }

    @Override
    public JsonNode apply(Scope scope, JsonNode input) {
        JsonNode value;
        if (this.key == null) {
            return input;
        }
        if (this.parent != null) {
            input = this.parent.apply(scope, input);
        }
        if ((value = input.get(this.key)) == null) {
            value = NullNode.instance;
        }
        return value;
    }

    @Override
    public String toString() {
        String me = "." + (this.key == null ? "" : this.key);
        if (this.parent != null) {
            return "" + this.parent + me;
        }
        return me;
    }

    @Override
    public void checkOk(Location matcher) {
        if (this.parent != null) {
            ((DotExpression)this.parent).checkOk(matcher);
        }
    }
}

