/*
 * Decompiled with CFR 0.152.
 */
package com.schibsted.spt.data.jslt.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.schibsted.spt.data.jslt.JsltException;
import com.schibsted.spt.data.jslt.impl.AbstractNode;
import com.schibsted.spt.data.jslt.impl.ExpressionNode;
import com.schibsted.spt.data.jslt.impl.LetExpression;
import com.schibsted.spt.data.jslt.impl.Location;
import com.schibsted.spt.data.jslt.impl.NodeUtils;
import com.schibsted.spt.data.jslt.impl.Scope;

public class ObjectComprehension
extends AbstractNode {
    private ExpressionNode loop;
    private LetExpression[] lets;
    private ExpressionNode key;
    private ExpressionNode value;

    public ObjectComprehension(ExpressionNode loop, ExpressionNode key, ExpressionNode value, Location location) {
        super(location);
        this.loop = loop;
        this.key = key;
        this.value = value;
    }

    @Override
    public JsonNode apply(Scope scope, JsonNode input) {
        JsonNode sequence = this.loop.apply(scope, input);
        if (sequence.isNull()) {
            return sequence;
        }
        if (sequence.isObject()) {
            sequence = NodeUtils.convertObjectToArray(sequence);
        } else if (!sequence.isArray()) {
            throw new JsltException("Object comprehension can't loop over " + sequence, this.location);
        }
        ObjectNode object = NodeUtils.mapper.createObjectNode();
        for (int ix = 0; ix < sequence.size(); ++ix) {
            JsonNode context = sequence.get(ix);
            JsonNode keyNode = this.key.apply(scope, context);
            if (!keyNode.isTextual()) {
                throw new JsltException("Object comprehension must have string as key, not " + keyNode, this.location);
            }
            JsonNode valueNode = this.value.apply(scope, context);
            if (!NodeUtils.isValue(valueNode)) continue;
            object.set(keyNode.asText(), valueNode);
        }
        return object;
    }

    @Override
    public void dump(int level) {
    }
}

