/*
 * Decompiled with CFR 0.152.
 */
package com.schibsted.spt.data.jslt.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.schibsted.spt.data.jslt.impl.AbstractNode;
import com.schibsted.spt.data.jslt.impl.DotExpression;
import com.schibsted.spt.data.jslt.impl.ExpressionNode;
import com.schibsted.spt.data.jslt.impl.Location;
import com.schibsted.spt.data.jslt.impl.NodeUtils;
import com.schibsted.spt.data.jslt.impl.Scope;

public class LetExpression
extends AbstractNode {
    private String variable;
    private ExpressionNode value;

    public LetExpression(String variable, ExpressionNode value, Location location) {
        super(location);
        this.variable = variable;
        this.value = value;
    }

    public String getVariable() {
        return this.variable;
    }

    @Override
    public JsonNode apply(Scope scope, JsonNode input) {
        return this.value.apply(scope, input);
    }

    @Override
    public void computeMatchContexts(DotExpression parent) {
        this.value.computeMatchContexts(parent);
    }

    @Override
    public void dump(int level) {
        System.out.println(NodeUtils.indent(level) + "let " + this.variable + " =");
        this.value.dump(level + 1);
    }

    @Override
    public ExpressionNode optimize() {
        this.value = this.value.optimize();
        return this;
    }
}

