/*
 * Decompiled with CFR 0.152.
 */
package com.schibsted.spt.data.jslt.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.schibsted.spt.data.jslt.Expression;
import com.schibsted.spt.data.jslt.Function;
import com.schibsted.spt.data.jslt.impl.DotExpression;
import com.schibsted.spt.data.jslt.impl.ExpressionNode;
import com.schibsted.spt.data.jslt.impl.FunctionDeclaration;
import com.schibsted.spt.data.jslt.impl.LetExpression;
import com.schibsted.spt.data.jslt.impl.NodeUtils;
import com.schibsted.spt.data.jslt.impl.Scope;
import java.util.Map;

public class ExpressionImpl
implements Expression {
    private LetExpression[] lets;
    private Map<String, Function> functions;
    private ExpressionNode actual;

    public ExpressionImpl(LetExpression[] lets, Map<String, Function> functions, ExpressionNode actual) {
        this.lets = lets;
        this.functions = functions;
        this.actual = actual;
        if (actual != null) {
            actual.computeMatchContexts(new DotExpression(null));
        }
    }

    public Function getFunction(String name) {
        return this.functions.get(name);
    }

    public boolean hasBody() {
        return this.actual != null;
    }

    @Override
    public JsonNode apply(Map<String, JsonNode> variables, JsonNode input) {
        if (input == null) {
            input = NullNode.instance;
        }
        Scope scope = NodeUtils.evalLets(Scope.makeScope(variables), input, this.lets);
        return this.actual.apply(scope, input);
    }

    @Override
    public JsonNode apply(JsonNode input) {
        if (input == null) {
            input = NullNode.instance;
        }
        Scope scope = NodeUtils.evalLets(Scope.getRoot(), input, this.lets);
        return this.actual.apply(scope, input);
    }

    public void dump() {
        for (int ix = 0; ix < this.lets.length; ++ix) {
            this.lets[ix].dump(0);
        }
        this.actual.dump(0);
    }

    public void optimize() {
        for (int ix = 0; ix < this.lets.length; ++ix) {
            this.lets[ix].optimize();
        }
        for (Function f : this.functions.values()) {
            if (!(f instanceof FunctionDeclaration)) continue;
            ((FunctionDeclaration)f).optimize();
        }
        if (this.actual != null) {
            this.actual = this.actual.optimize();
        }
    }

    public String toString() {
        return this.actual.toString();
    }
}

