/*
 * Decompiled with CFR 0.152.
 */
package com.schibsted.spain.parallaxlayerlayout;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.view.animation.LinearInterpolator;
import com.schibsted.spain.parallaxlayerlayout.ParallaxLayerLayout;

public class AnimatedTranslationUpdater
implements ParallaxLayerLayout.TranslationUpdater {
    private final float maxParallax;
    private ParallaxLayerLayout parallax;
    private ValueAnimator animation;

    public AnimatedTranslationUpdater() {
        this(1.0f);
    }

    public AnimatedTranslationUpdater(float maxParallax) {
        this.maxParallax = maxParallax;
    }

    @Override
    public void subscribe(ParallaxLayerLayout parallaxLayerLayout) {
        this.parallax = parallaxLayerLayout;
        ValueAnimator.AnimatorUpdateListener listener = new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animator) {
                AnimatedTranslationUpdater.this.parallax.updateTranslations(new float[]{((Float)animator.getAnimatedValue()).floatValue(), 0.0f});
            }
        };
        this.animation = ValueAnimator.ofFloat((float[])new float[]{0.0f, this.maxParallax, 0.0f, -this.maxParallax, 0.0f});
        this.animation.setDuration(1500L);
        this.animation.setInterpolator((TimeInterpolator)new LinearInterpolator());
        this.animation.setRepeatCount(-1);
        this.animation.setRepeatMode(1);
        this.animation.addUpdateListener(listener);
        this.animation.start();
    }

    @Override
    public void unSubscribe() {
        if (this.animation != null && this.animation.isStarted()) {
            this.animation.end();
        }
    }
}

