/*
 * Decompiled with CFR 0.152.
 */
package com.schibsted.spain.parallaxlayerlayout;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.WindowManager;
import com.schibsted.spain.parallaxlayerlayout.ParallaxLayerLayout;

public class SensorTranslationUpdater
implements ParallaxLayerLayout.TranslationUpdater,
SensorEventListener {
    private static final int DEFAULT_SAMPLING_PERIOD = 100;
    private final SensorManager sensorManager;
    private float[] mTiltVector = new float[3];
    private boolean mTargeted = false;
    private float[] mTargetMatrix = new float[16];
    private float[] mRotationMatrix = new float[16];
    private float[] mOrientedRotationMatrix = new float[16];
    private float[] mTruncatedRotationVector;
    private float mTiltSensitivity = 2.0f;
    private ParallaxLayerLayout parallax;

    public SensorTranslationUpdater(Context context) {
        this((SensorManager)context.getSystemService("sensor"));
    }

    public SensorTranslationUpdater(SensorManager sensorManager) {
        this.sensorManager = sensorManager;
    }

    @Override
    public void subscribe(ParallaxLayerLayout parallaxLayerLayout) {
        this.parallax = parallaxLayerLayout;
    }

    @Override
    public void unSubscribe() {
        this.parallax = null;
    }

    public void registerSensorManager() {
        if (this.sensorManager != null) {
            this.sensorManager.registerListener((SensorEventListener)this, this.sensorManager.getDefaultSensor(11), 100);
        }
    }

    public void unregisterSensorManager() {
        if (this.sensorManager != null) {
            this.sensorManager.unregisterListener((SensorEventListener)this);
        }
    }

    public void onSensorChanged(SensorEvent event) {
        if (this.parallax == null) {
            return;
        }
        float[] vectors = this.interpretSensorEvent(this.parallax.getContext(), event);
        if (vectors == null) {
            return;
        }
        float roll = vectors[2];
        float pitch = -vectors[1];
        this.parallax.updateTranslations(new float[]{roll, pitch});
    }

    public void onAccuracyChanged(Sensor sensor, int accuracy) {
    }

    @Nullable
    private float[] interpretSensorEvent(@NonNull Context context, @Nullable SensorEvent event) {
        if (event == null) {
            return null;
        }
        float[] rotationVector = this.getRotationVectorFromSensorEvent(event);
        if (!this.mTargeted) {
            this.setTargetVector(rotationVector);
            return null;
        }
        SensorManager.getRotationMatrixFromVector((float[])this.mRotationMatrix, (float[])rotationVector);
        int rotation = ((WindowManager)context.getSystemService("window")).getDefaultDisplay().getRotation();
        if (rotation == 0) {
            SensorManager.getAngleChange((float[])this.mTiltVector, (float[])this.mRotationMatrix, (float[])this.mTargetMatrix);
        } else {
            switch (rotation) {
                case 1: {
                    SensorManager.remapCoordinateSystem((float[])this.mRotationMatrix, (int)2, (int)129, (float[])this.mOrientedRotationMatrix);
                    break;
                }
                case 2: {
                    SensorManager.remapCoordinateSystem((float[])this.mRotationMatrix, (int)129, (int)130, (float[])this.mOrientedRotationMatrix);
                    break;
                }
                case 3: {
                    SensorManager.remapCoordinateSystem((float[])this.mRotationMatrix, (int)130, (int)1, (float[])this.mOrientedRotationMatrix);
                    break;
                }
            }
            SensorManager.getAngleChange((float[])this.mTiltVector, (float[])this.mOrientedRotationMatrix, (float[])this.mTargetMatrix);
        }
        for (int i = 0; i < this.mTiltVector.length; ++i) {
            int n = i;
            this.mTiltVector[n] = (float)((double)this.mTiltVector[n] / Math.PI);
            int n2 = i;
            this.mTiltVector[n2] = this.mTiltVector[n2] * this.mTiltSensitivity;
            if (this.mTiltVector[i] > 1.0f) {
                this.mTiltVector[i] = 1.0f;
                continue;
            }
            if (!(this.mTiltVector[i] < -1.0f)) continue;
            this.mTiltVector[i] = -1.0f;
        }
        return this.mTiltVector;
    }

    @NonNull
    private float[] getRotationVectorFromSensorEvent(@NonNull SensorEvent event) {
        if (event.values.length > 4) {
            if (this.mTruncatedRotationVector == null) {
                this.mTruncatedRotationVector = new float[4];
            }
            System.arraycopy(event.values, 0, this.mTruncatedRotationVector, 0, 4);
            return this.mTruncatedRotationVector;
        }
        return event.values;
    }

    private void setTargetVector(float[] values) {
        SensorManager.getRotationMatrixFromVector((float[])this.mTargetMatrix, (float[])values);
        this.mTargeted = true;
    }

    public void reset() {
        this.mTargeted = false;
    }

    public void setTiltSensitivity(float tiltSensitivity) {
        if (tiltSensitivity <= 0.0f) {
            throw new IllegalArgumentException("Tilt sensitivity must be positive");
        }
        this.mTiltSensitivity = tiltSensitivity;
    }
}

