/*
 * Decompiled with CFR 0.152.
 */
package com.schibsted.spain.parallaxlayerlayout;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.Size;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.widget.FrameLayout;
import com.schibsted.spain.parallaxlayerlayout.R;

public class ParallaxLayerLayout
extends FrameLayout {
    private static final int DEFAULT_BASE_OFFSET_DP = 10;
    private static final int DEFAULT_OFFSET_INCREMENT_DP = 5;
    private Interpolator interpolator = new DecelerateInterpolator();
    private int offsetIncrementPx;
    private int baseOffsetPx;
    private float scaleX = 1.0f;
    private float scaleY = 1.0f;
    private TranslationUpdater translationUpdater;

    public ParallaxLayerLayout(Context context) {
        super(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParallaxLayerLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.ParallaxLayerLayout);
        try {
            this.baseOffsetPx = a.getDimensionPixelSize(R.styleable.ParallaxLayerLayout_parallaxOffsetBase, -1);
            if (this.baseOffsetPx == -1) {
                this.baseOffsetPx = (int)TypedValue.applyDimension((int)1, (float)10.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
            }
            this.offsetIncrementPx = a.getDimensionPixelSize(R.styleable.ParallaxLayerLayout_parallaxOffsetIncrement, -1);
            if (this.offsetIncrementPx == -1) {
                this.offsetIncrementPx = (int)TypedValue.applyDimension((int)1, (float)5.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
            }
            this.scaleX = a.getFloat(R.styleable.ParallaxLayerLayout_parallaxScaleHorizontal, 1.0f);
            this.scaleY = a.getFloat(R.styleable.ParallaxLayerLayout_parallaxScaleVertical, 1.0f);
            if (this.scaleX > 1.0f || this.scaleX < 0.0f || this.scaleY > 1.0f || this.scaleY < 0.0f) {
                throw new RuntimeException("Parallax scale must be a value between -1.0 and 1.0");
            }
        }
        finally {
            a.recycle();
        }
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.computeOffsets();
        if (this.isInEditMode()) {
            this.updateTranslations(new float[]{1.0f, 1.0f});
        }
    }

    private void computeOffsets() {
        int childCount = this.getChildCount();
        for (int i = childCount - 1; i >= 0; --i) {
            View child = this.getChildAt(i);
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            int index = lp.customIndex == -1 ? childCount - 1 - i : lp.customIndex;
            lp.offsetPx = this.offsetPxForIndex(index, lp.incrementMultiplier);
        }
    }

    private float offsetPxForIndex(int index, float incrementMultiplier) {
        return incrementMultiplier * (float)this.baseOffsetPx + (float)(index * this.offsetIncrementPx);
    }

    public void updateTranslations(@Size(value=2L) float[] translations) {
        if (Math.abs(translations[0]) > 1.0f || Math.abs(translations[1]) > 1.0f) {
            throw new RuntimeException("Translation values must be between 1.0 and -1.0");
        }
        int childCount = this.getChildCount();
        for (int i = childCount - 1; i >= 0; --i) {
            View child = this.getChildAt(i);
            float[] translationsPx = this.calculateFinalTranslationPx(child, translations);
            child.setTranslationX(translationsPx[0]);
            child.setTranslationY(translationsPx[1]);
        }
    }

    public void setTranslationUpdater(TranslationUpdater translationUpdater) {
        if (this.translationUpdater != null) {
            this.translationUpdater.unSubscribe();
        }
        this.translationUpdater = translationUpdater;
        this.translationUpdater.subscribe(this);
    }

    @Size(value=2L)
    private float[] calculateFinalTranslationPx(View child, @Size(value=2L) float[] translations) {
        LayoutParams lp = (LayoutParams)child.getLayoutParams();
        int xSign = translations[0] > 0.0f ? 1 : -1;
        int ySign = translations[1] > 0.0f ? 1 : -1;
        float translationX = (float)xSign * lp.offsetPx * this.interpolator.getInterpolation(Math.abs(translations[0])) * this.scaleX;
        float translationY = (float)ySign * lp.offsetPx * this.interpolator.getInterpolation(Math.abs(translations[1])) * this.scaleY;
        return new float[]{translationX, translationY};
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof LayoutParams;
    }

    protected LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-2, -2);
    }

    public LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        return new LayoutParams(p.width, p.height);
    }

    public static interface TranslationUpdater {
        public void subscribe(ParallaxLayerLayout var1);

        public void unSubscribe();
    }

    public static class LayoutParams
    extends FrameLayout.LayoutParams {
        private float offsetPx;
        private int customIndex = -1;
        private float incrementMultiplier = 1.0f;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public LayoutParams(Context c, AttributeSet attrs) {
            super(c, attrs);
            this.gravity = 17;
            TypedArray a = c.obtainStyledAttributes(attrs, R.styleable.ParallaxLayerLayout_LayoutParams);
            try {
                this.customIndex = a.getInt(R.styleable.ParallaxLayerLayout_LayoutParams_layout_parallaxZIndex, -1);
                this.incrementMultiplier = a.getFloat(R.styleable.ParallaxLayerLayout_LayoutParams_layout_parallaxIncrementMultiplier, 1.0f);
            }
            finally {
                a.recycle();
            }
        }

        public LayoutParams(int width, int height) {
            super(width, height);
            this.gravity = 17;
        }
    }
}

