/*
 * Decompiled with CFR 0.152.
 */
package com.scglab.common.widget;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import com.scglab.common.widget.R;
import java.util.Arrays;

public class RoundedImageView
extends View {
    private Source source;
    private CornerSize cornerSize;

    public RoundedImageView(Context context) {
        super(context);
        this.init(null);
    }

    public RoundedImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context.getTheme().obtainStyledAttributes(attrs, R.styleable.RoundedImageView, 0, 0));
    }

    public RoundedImageView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context.getTheme().obtainStyledAttributes(attrs, R.styleable.RoundedImageView, defStyleAttr, 0));
    }

    public RoundedImageView(Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context.getTheme().obtainStyledAttributes(attrs, R.styleable.RoundedImageView, defStyleAttr, defStyleRes));
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int width = RoundedImageView.getDefaultSize((int)this.getSuggestedMinimumWidth(), (int)widthMeasureSpec);
        int height = RoundedImageView.getDefaultSize((int)this.getSuggestedMinimumHeight(), (int)heightMeasureSpec);
        if (this.source.hasSource()) {
            if (this.getLayoutParams().width == -2) {
                width = Math.min(this.source.getSourceWidth(this.getResources()), width);
            }
            if (this.getLayoutParams().height == -2) {
                height = Math.min(this.source.getSourceHeight(this.getResources()), height);
            }
            Log.d((String)"ROOEX", (String)(width + " / " + height));
        } else {
            Log.v((String)"ROOEX", (String)(width + " / " + height));
        }
        this.setMeasuredDimension(width, height);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.source.setCanvasRect(new Rect(this.getPaddingLeft(), this.getPaddingTop(), this.getMeasuredWidth() - this.getPaddingRight(), this.getMeasuredHeight() - this.getPaddingBottom()));
    }

    protected void onDraw(Canvas canvas) {
        if (null == this.source) {
            return;
        }
        this.source.draw(canvas, this.getResources());
    }

    public void setResource(int resId) {
        this.setBitmap(BitmapFactory.decodeResource((Resources)this.getResources(), (int)resId));
    }

    public void setBitmap(@NonNull Bitmap bitmap) {
        this.source.setSource(bitmap);
        this.requestLayout();
    }

    public boolean isScaleUp() {
        return this.source.isScaleUp();
    }

    public void setScaleUp(boolean value) {
        this.source.setScaleUp(value);
    }

    public CornerSize getCornerSize() {
        try {
            return this.cornerSize.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public void setCornerSize(CornerSize value) {
        this.cornerSize.set(value);
        this.source.setCornerSize(this.cornerSize.toArray());
    }

    private void init(TypedArray typedArray) {
        float density = this.getResources().getDisplayMetrics().density;
        float base = typedArray.getFloat(R.styleable.RoundedImageView_corner_size, 0.0f);
        this.cornerSize = new CornerSize();
        this.cornerSize.setTopLeft(typedArray.getFloat(R.styleable.RoundedImageView_top_left_corner_size, base) * density);
        this.cornerSize.setTopRight(typedArray.getFloat(R.styleable.RoundedImageView_top_left_corner_size, base) * density);
        this.cornerSize.setBottomRight(typedArray.getFloat(R.styleable.RoundedImageView_bottom_right_corner_size, base) * density);
        this.cornerSize.setBottomLeft(typedArray.getFloat(R.styleable.RoundedImageView_bottom_left_corner_size, base) * density);
        this.source = new Source(typedArray.getResourceId(R.styleable.RoundedImageView_default_image, -1));
        this.source.setScaleUp(typedArray.getBoolean(R.styleable.RoundedImageView_scale_up, false));
        this.source.setCornerSize(this.cornerSize.toArray());
        try {
            typedArray.recycle();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private class Source {
        private final Paint PAINT = new Paint();
        private final int DEFAULT_RES;
        private Bitmap bitmap;
        private boolean invalidateResize;
        private boolean invalidateCanvasRect;
        private boolean invalidateClipPath;
        private boolean isScaleUp;
        private float[] cornerSize;
        private Rect canvasRect;
        private RectF drawRect;
        private Rect bitmapRect;
        private Path clipPath;

        Source(int defaultRes) {
            this.PAINT.setAntiAlias(true);
            this.DEFAULT_RES = defaultRes;
            this.cornerSize = new float[8];
        }

        boolean hasSource() {
            return null != this.bitmap || this.DEFAULT_RES != -1;
        }

        int getSourceWidth(@NonNull Resources resources) {
            return this.getSource(resources).getHeight();
        }

        int getSourceHeight(@NonNull Resources resources) {
            return this.getSource(resources).getHeight();
        }

        void setCanvasRect(Rect rect) {
            if (null == this.canvasRect || !this.canvasRect.equals((Object)rect)) {
                this.canvasRect = rect;
                this.invalidateResize = true;
                this.invalidateCanvasRect = true;
                this.invalidateClipPath = true;
            }
        }

        boolean isScaleUp() {
            return this.isScaleUp;
        }

        void setScaleUp(boolean value) {
            if (value != this.isScaleUp) {
                this.isScaleUp = value;
                this.invalidateCanvasRect = true;
                this.invalidateClipPath = true;
            }
        }

        void setCornerSize(float[] value) {
            if (!Arrays.equals(this.cornerSize, value)) {
                this.cornerSize = Arrays.copyOf(value, value.length);
                this.invalidateClipPath = true;
            }
        }

        void setSource(@NonNull Bitmap bitmap) {
            this.clear();
            this.bitmap = bitmap;
        }

        void draw(@NonNull Canvas canvas, @NonNull Resources resources) {
            if (!this.hasSource()) {
                return;
            }
            this.invalidate(resources);
            canvas.save();
            canvas.clipPath(this.clipPath);
            canvas.drawBitmap(this.bitmap, this.bitmapRect, this.drawRect, this.PAINT);
            canvas.restore();
        }

        private void invalidate(Resources resources) {
            if (this.bitmap == null) {
                this.getSource(resources);
            }
            if (this.invalidateResize) {
                this.invalidateResize = false;
                this.resize();
            }
            if (null == this.bitmapRect) {
                this.bitmapRect = new Rect(0, 0, this.bitmap.getWidth(), this.bitmap.getHeight());
            }
            if (this.invalidateCanvasRect) {
                this.invalidateCanvasRect = false;
                this.forceScale();
            }
            if (this.invalidateClipPath) {
                this.invalidateClipPath = false;
                this.refreshClipPath();
            }
        }

        private void resize() {
            float rate;
            if (null == this.canvasRect) {
                return;
            }
            if (null == this.bitmap) {
                return;
            }
            if ((this.canvasRect.width() < this.bitmap.getWidth() || this.canvasRect.height() < this.bitmap.getHeight()) && (rate = Math.min((float)this.canvasRect.width() / (float)this.bitmap.getWidth(), (float)this.canvasRect.height() / (float)this.bitmap.getHeight())) < 1.0f && rate > 0.0f) {
                this.bitmap = Bitmap.createScaledBitmap((Bitmap)this.bitmap, (int)((int)((float)this.bitmap.getWidth() * rate)), (int)((int)((float)this.bitmap.getHeight() * rate)), (boolean)true);
            }
        }

        private void forceScale() {
            if (null == this.drawRect) {
                this.drawRect = new RectF();
            }
            if (this.isScaleUp) {
                float rate = Math.min((float)this.canvasRect.height() / (float)this.bitmapRect.height(), (float)this.canvasRect.width() / (float)this.bitmapRect.width());
                int targetWidth = (int)(((float)this.canvasRect.width() - (float)this.bitmapRect.width() * rate) / 2.0f);
                int targetHeight = (int)(((float)this.canvasRect.height() - (float)this.bitmapRect.height() * rate) / 2.0f);
                this.drawRect.left = this.canvasRect.left + targetWidth;
                this.drawRect.top = this.canvasRect.top + targetHeight;
                this.drawRect.right = this.canvasRect.right - targetWidth;
                this.drawRect.bottom = this.canvasRect.bottom - targetHeight;
            } else {
                this.drawRect.left = this.canvasRect.left + (int)((float)(this.canvasRect.width() - this.bitmap.getWidth()) / 2.0f);
                this.drawRect.top = this.canvasRect.top + (int)((float)(this.canvasRect.height() - this.bitmap.getHeight()) / 2.0f);
                this.drawRect.right = this.drawRect.left + (float)this.bitmap.getWidth();
                this.drawRect.bottom = this.drawRect.top + (float)this.bitmap.getHeight();
            }
        }

        private void refreshClipPath() {
            if (null == this.clipPath) {
                this.clipPath = new Path();
            } else {
                this.clipPath.reset();
            }
            this.clipPath.addRoundRect(this.drawRect, this.cornerSize, Path.Direction.CW);
        }

        private Bitmap getSource(Resources resources) {
            if (null == this.bitmap || this.hasSource()) {
                this.bitmap = BitmapFactory.decodeResource((Resources)resources, (int)this.DEFAULT_RES);
            }
            return this.bitmap;
        }

        private void clear() {
            this.bitmapRect = null;
            this.invalidateResize = true;
            this.invalidateCanvasRect = true;
            this.invalidateClipPath = true;
            try {
                this.bitmap.recycle();
            }
            catch (Exception exception) {
            }
            finally {
                this.bitmap = null;
            }
        }
    }

    public static class CornerSize
    implements Cloneable {
        private float topLeft;
        private float topRight;
        private float bottomLeft;
        private float bottomRight;

        private CornerSize() {
        }

        private void set(CornerSize value) {
            this.topLeft = value.topLeft;
            this.topRight = value.topRight;
            this.bottomLeft = value.bottomLeft;
            this.bottomRight = value.bottomRight;
        }

        public void setAll(float value) {
            this.bottomRight = this.bottomLeft = value;
            this.topRight = this.bottomLeft;
            this.topLeft = this.bottomLeft;
        }

        public float getTopLeft() {
            return this.topLeft;
        }

        public void setTopLeft(float value) {
            this.topLeft = value;
        }

        public float getTopRight() {
            return this.topRight;
        }

        public void setTopRight(float value) {
            this.topRight = value;
        }

        public float getBottomLeft() {
            return this.bottomLeft;
        }

        public void setBottomLeft(float value) {
            this.bottomLeft = value;
        }

        public float getBottomRight() {
            return this.bottomRight;
        }

        public void setBottomRight(float value) {
            this.bottomRight = value;
        }

        private float[] toArray() {
            return new float[]{this.topLeft, this.topLeft, this.topRight, this.topRight, this.bottomRight, this.bottomRight, this.bottomLeft, this.bottomLeft};
        }

        protected CornerSize clone() throws CloneNotSupportedException {
            return (CornerSize)super.clone();
        }
    }
}

